@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.DetectorFeatureArgs.builder
import com.pulumi.aws.guardduty.kotlin.inputs.DetectorFeatureAdditionalConfigurationArgs
import com.pulumi.aws.guardduty.kotlin.inputs.DetectorFeatureAdditionalConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a single Amazon GuardDuty [detector feature](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-features-activation-model.html#guardduty-features).
 * > **NOTE:** Deleting this resource does not disable the detector feature, the resource in simply removed from state instead.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.guardduty.Detector("example", {enable: true});
 * const eksRuntimeMonitoring = new aws.guardduty.DetectorFeature("eks_runtime_monitoring", {
 *     detectorId: example.id,
 *     name: "EKS_RUNTIME_MONITORING",
 *     status: "ENABLED",
 *     additionalConfigurations: [{
 *         name: "EKS_ADDON_MANAGEMENT",
 *         status: "ENABLED",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.guardduty.Detector("example", enable=True)
 * eks_runtime_monitoring = aws.guardduty.DetectorFeature("eks_runtime_monitoring",
 *     detector_id=example.id,
 *     name="EKS_RUNTIME_MONITORING",
 *     status="ENABLED",
 *     additional_configurations=[{
 *         "name": "EKS_ADDON_MANAGEMENT",
 *         "status": "ENABLED",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GuardDuty.Detector("example", new()
 *     {
 *         Enable = true,
 *     });
 *     var eksRuntimeMonitoring = new Aws.GuardDuty.DetectorFeature("eks_runtime_monitoring", new()
 *     {
 *         DetectorId = example.Id,
 *         Name = "EKS_RUNTIME_MONITORING",
 *         Status = "ENABLED",
 *         AdditionalConfigurations = new[]
 *         {
 *             new Aws.GuardDuty.Inputs.DetectorFeatureAdditionalConfigurationArgs
 *             {
 *                 Name = "EKS_ADDON_MANAGEMENT",
 *                 Status = "ENABLED",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := guardduty.NewDetector(ctx, "example", &guardduty.DetectorArgs{
 * 			Enable: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = guardduty.NewDetectorFeature(ctx, "eks_runtime_monitoring", &guardduty.DetectorFeatureArgs{
 * 			DetectorId: example.ID(),
 * 			Name:       pulumi.String("EKS_RUNTIME_MONITORING"),
 * 			Status:     pulumi.String("ENABLED"),
 * 			AdditionalConfigurations: guardduty.DetectorFeatureAdditionalConfigurationArray{
 * 				&guardduty.DetectorFeatureAdditionalConfigurationArgs{
 * 					Name:   pulumi.String("EKS_ADDON_MANAGEMENT"),
 * 					Status: pulumi.String("ENABLED"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.DetectorFeature;
 * import com.pulumi.aws.guardduty.DetectorFeatureArgs;
 * import com.pulumi.aws.guardduty.inputs.DetectorFeatureAdditionalConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Detector("example", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var eksRuntimeMonitoring = new DetectorFeature("eksRuntimeMonitoring", DetectorFeatureArgs.builder()
 *             .detectorId(example.id())
 *             .name("EKS_RUNTIME_MONITORING")
 *             .status("ENABLED")
 *             .additionalConfigurations(DetectorFeatureAdditionalConfigurationArgs.builder()
 *                 .name("EKS_ADDON_MANAGEMENT")
 *                 .status("ENABLED")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:guardduty:Detector
 *     properties:
 *       enable: true
 *   eksRuntimeMonitoring:
 *     type: aws:guardduty:DetectorFeature
 *     name: eks_runtime_monitoring
 *     properties:
 *       detectorId: ${example.id}
 *       name: EKS_RUNTIME_MONITORING
 *       status: ENABLED
 *       additionalConfigurations:
 *         - name: EKS_ADDON_MANAGEMENT
 *           status: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * @property additionalConfigurations Additional feature configuration block for features`EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
 * @property detectorId Amazon GuardDuty detector ID.
 * @property name The name of the detector feature. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`, `RUNTIME_MONITORING`. Only one of two features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING` can be added, adding both features will cause an error. Refer to the [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html) for the current list of supported values.
 * @property status The status of the detector feature. Valid values: `ENABLED`, `DISABLED`.
 */
public data class DetectorFeatureArgs(
    public val additionalConfigurations: Output<List<DetectorFeatureAdditionalConfigurationArgs>>? =
        null,
    public val detectorId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.DetectorFeatureArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.DetectorFeatureArgs =
        com.pulumi.aws.guardduty.DetectorFeatureArgs.builder()
            .additionalConfigurations(
                additionalConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DetectorFeatureArgs].
 */
@PulumiTagMarker
public class DetectorFeatureArgsBuilder internal constructor() {
    private var additionalConfigurations: Output<List<DetectorFeatureAdditionalConfigurationArgs>>? =
        null

    private var detectorId: Output<String>? = null

    private var name: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Additional feature configuration block for features`EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("iuqyfwrnbclfkqeb")
    public suspend fun additionalConfigurations(`value`: Output<List<DetectorFeatureAdditionalConfigurationArgs>>) {
        this.additionalConfigurations = value
    }

    @JvmName("tkyhgvnvogelupvu")
    public suspend fun additionalConfigurations(vararg values: Output<DetectorFeatureAdditionalConfigurationArgs>) {
        this.additionalConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Additional feature configuration block for features`EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("owuskimttbsbford")
    public suspend fun additionalConfigurations(values: List<Output<DetectorFeatureAdditionalConfigurationArgs>>) {
        this.additionalConfigurations = Output.all(values)
    }

    /**
     * @param value Amazon GuardDuty detector ID.
     */
    @JvmName("gvmfwghyiyuicdua")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value The name of the detector feature. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`, `RUNTIME_MONITORING`. Only one of two features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING` can be added, adding both features will cause an error. Refer to the [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html) for the current list of supported values.
     */
    @JvmName("slyhiwxxojxpqkkt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The status of the detector feature. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("vwkhubxgfyelsqtp")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Additional feature configuration block for features`EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("aucivhjfvpphappl")
    public suspend fun additionalConfigurations(`value`: List<DetectorFeatureAdditionalConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument Additional feature configuration block for features`EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("cscfpfjmynlgyhgd")
    public suspend fun additionalConfigurations(argument: List<suspend DetectorFeatureAdditionalConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DetectorFeatureAdditionalConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument Additional feature configuration block for features`EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("tynxrgabcqunamrb")
    public suspend fun additionalConfigurations(vararg argument: suspend DetectorFeatureAdditionalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DetectorFeatureAdditionalConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument Additional feature configuration block for features`EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("wbdhgpkvmtfafltu")
    public suspend fun additionalConfigurations(argument: suspend DetectorFeatureAdditionalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DetectorFeatureAdditionalConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param values Additional feature configuration block for features`EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("blyqpmvefvlgsixy")
    public suspend fun additionalConfigurations(vararg values: DetectorFeatureAdditionalConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param value Amazon GuardDuty detector ID.
     */
    @JvmName("qqrphwxdwravwnty")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value The name of the detector feature. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`, `RUNTIME_MONITORING`. Only one of two features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING` can be added, adding both features will cause an error. Refer to the [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html) for the current list of supported values.
     */
    @JvmName("rxmmmakiujytwjkl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The status of the detector feature. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("dwielyglbxqtcjsh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DetectorFeatureArgs = DetectorFeatureArgs(
        additionalConfigurations = additionalConfigurations,
        detectorId = detectorId,
        name = name,
        status = status,
    )
}
