@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.FilterArgs.builder
import com.pulumi.aws.guardduty.kotlin.inputs.FilterFindingCriteriaArgs
import com.pulumi.aws.guardduty.kotlin.inputs.FilterFindingCriteriaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a GuardDuty filter.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myFilter = new aws.guardduty.Filter("MyFilter", {
 *     name: "MyFilter",
 *     action: "ARCHIVE",
 *     detectorId: example.id,
 *     rank: 1,
 *     findingCriteria: {
 *         criterions: [
 *             {
 *                 field: "region",
 *                 equals: ["eu-west-1"],
 *             },
 *             {
 *                 field: "service.additionalInfo.threatListName",
 *                 notEquals: [
 *                     "some-threat",
 *                     "another-threat",
 *                 ],
 *             },
 *             {
 *                 field: "updatedAt",
 *                 greaterThan: "2020-01-01T00:00:00Z",
 *                 lessThan: "2020-02-01T00:00:00Z",
 *             },
 *             {
 *                 field: "severity",
 *                 greaterThanOrEqual: "4",
 *             },
 *         ],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_filter = aws.guardduty.Filter("MyFilter",
 *     name="MyFilter",
 *     action="ARCHIVE",
 *     detector_id=example["id"],
 *     rank=1,
 *     finding_criteria={
 *         "criterions": [
 *             {
 *                 "field": "region",
 *                 "equals": ["eu-west-1"],
 *             },
 *             {
 *                 "field": "service.additionalInfo.threatListName",
 *                 "not_equals": [
 *                     "some-threat",
 *                     "another-threat",
 *                 ],
 *             },
 *             {
 *                 "field": "updatedAt",
 *                 "greater_than": "2020-01-01T00:00:00Z",
 *                 "less_than": "2020-02-01T00:00:00Z",
 *             },
 *             {
 *                 "field": "severity",
 *                 "greater_than_or_equal": "4",
 *             },
 *         ],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myFilter = new Aws.GuardDuty.Filter("MyFilter", new()
 *     {
 *         Name = "MyFilter",
 *         Action = "ARCHIVE",
 *         DetectorId = example.Id,
 *         Rank = 1,
 *         FindingCriteria = new Aws.GuardDuty.Inputs.FilterFindingCriteriaArgs
 *         {
 *             Criterions = new[]
 *             {
 *                 new Aws.GuardDuty.Inputs.FilterFindingCriteriaCriterionArgs
 *                 {
 *                     Field = "region",
 *                     Equals = new[]
 *                     {
 *                         "eu-west-1",
 *                     },
 *                 },
 *                 new Aws.GuardDuty.Inputs.FilterFindingCriteriaCriterionArgs
 *                 {
 *                     Field = "service.additionalInfo.threatListName",
 *                     NotEquals = new[]
 *                     {
 *                         "some-threat",
 *                         "another-threat",
 *                     },
 *                 },
 *                 new Aws.GuardDuty.Inputs.FilterFindingCriteriaCriterionArgs
 *                 {
 *                     Field = "updatedAt",
 *                     GreaterThan = "2020-01-01T00:00:00Z",
 *                     LessThan = "2020-02-01T00:00:00Z",
 *                 },
 *                 new Aws.GuardDuty.Inputs.FilterFindingCriteriaCriterionArgs
 *                 {
 *                     Field = "severity",
 *                     GreaterThanOrEqual = "4",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := guardduty.NewFilter(ctx, "MyFilter", &guardduty.FilterArgs{
 * 			Name:       pulumi.String("MyFilter"),
 * 			Action:     pulumi.String("ARCHIVE"),
 * 			DetectorId: pulumi.Any(example.Id),
 * 			Rank:       pulumi.Int(1),
 * 			FindingCriteria: &guardduty.FilterFindingCriteriaArgs{
 * 				Criterions: guardduty.FilterFindingCriteriaCriterionArray{
 * 					&guardduty.FilterFindingCriteriaCriterionArgs{
 * 						Field: pulumi.String("region"),
 * 						Equals: pulumi.StringArray{
 * 							pulumi.String("eu-west-1"),
 * 						},
 * 					},
 * 					&guardduty.FilterFindingCriteriaCriterionArgs{
 * 						Field: pulumi.String("service.additionalInfo.threatListName"),
 * 						NotEquals: pulumi.StringArray{
 * 							pulumi.String("some-threat"),
 * 							pulumi.String("another-threat"),
 * 						},
 * 					},
 * 					&guardduty.FilterFindingCriteriaCriterionArgs{
 * 						Field:       pulumi.String("updatedAt"),
 * 						GreaterThan: pulumi.String("2020-01-01T00:00:00Z"),
 * 						LessThan:    pulumi.String("2020-02-01T00:00:00Z"),
 * 					},
 * 					&guardduty.FilterFindingCriteriaCriterionArgs{
 * 						Field:              pulumi.String("severity"),
 * 						GreaterThanOrEqual: pulumi.String("4"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Filter;
 * import com.pulumi.aws.guardduty.FilterArgs;
 * import com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myFilter = new Filter("myFilter", FilterArgs.builder()
 *             .name("MyFilter")
 *             .action("ARCHIVE")
 *             .detectorId(example.id())
 *             .rank(1)
 *             .findingCriteria(FilterFindingCriteriaArgs.builder()
 *                 .criterions(
 *                     FilterFindingCriteriaCriterionArgs.builder()
 *                         .field("region")
 *                         .equals("eu-west-1")
 *                         .build(),
 *                     FilterFindingCriteriaCriterionArgs.builder()
 *                         .field("service.additionalInfo.threatListName")
 *                         .notEquals(
 *                             "some-threat",
 *                             "another-threat")
 *                         .build(),
 *                     FilterFindingCriteriaCriterionArgs.builder()
 *                         .field("updatedAt")
 *                         .greaterThan("2020-01-01T00:00:00Z")
 *                         .lessThan("2020-02-01T00:00:00Z")
 *                         .build(),
 *                     FilterFindingCriteriaCriterionArgs.builder()
 *                         .field("severity")
 *                         .greaterThanOrEqual("4")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myFilter:
 *     type: aws:guardduty:Filter
 *     name: MyFilter
 *     properties:
 *       name: MyFilter
 *       action: ARCHIVE
 *       detectorId: ${example.id}
 *       rank: 1
 *       findingCriteria:
 *         criterions:
 *           - field: region
 *             equals:
 *               - eu-west-1
 *           - field: service.additionalInfo.threatListName
 *             notEquals:
 *               - some-threat
 *               - another-threat
 *           - field: updatedAt
 *             greaterThan: 2020-01-01T00:00:00Z
 *             lessThan: 2020-02-01T00:00:00Z
 *           - field: severity
 *             greaterThanOrEqual: '4'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GuardDuty filters using the detector ID and filter's name separated by a colon. For example:
 * ```sh
 * $ pulumi import aws:guardduty/filter:Filter MyFilter 00b00fd5aecc0ab60a708659477e9617:MyFilter
 * ```
 * @property action Specifies the action that is to be applied to the findings that match the filter. Can be one of `ARCHIVE` or `NOOP`.
 * @property description Description of the filter.
 * @property detectorId ID of a GuardDuty detector, attached to your account.
 * @property findingCriteria Represents the criteria to be used in the filter for querying findings. Contains one or more `criterion` blocks, documented below.
 * @property name The name of your filter.
 * @property rank Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.
 * @property tags The tags that you want to add to the Filter resource. A tag consists of a key and a value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FilterArgs(
    public val action: Output<String>? = null,
    public val description: Output<String>? = null,
    public val detectorId: Output<String>? = null,
    public val findingCriteria: Output<FilterFindingCriteriaArgs>? = null,
    public val name: Output<String>? = null,
    public val rank: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.FilterArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.FilterArgs =
        com.pulumi.aws.guardduty.FilterArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .findingCriteria(findingCriteria?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .rank(rank?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FilterArgs].
 */
@PulumiTagMarker
public class FilterArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var description: Output<String>? = null

    private var detectorId: Output<String>? = null

    private var findingCriteria: Output<FilterFindingCriteriaArgs>? = null

    private var name: Output<String>? = null

    private var rank: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the action that is to be applied to the findings that match the filter. Can be one of `ARCHIVE` or `NOOP`.
     */
    @JvmName("vswckddptaraebgb")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Description of the filter.
     */
    @JvmName("boeitrcyeyuwkmgc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ID of a GuardDuty detector, attached to your account.
     */
    @JvmName("ciaylnemdmocnycn")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value Represents the criteria to be used in the filter for querying findings. Contains one or more `criterion` blocks, documented below.
     */
    @JvmName("juyeigsgenmuygrj")
    public suspend fun findingCriteria(`value`: Output<FilterFindingCriteriaArgs>) {
        this.findingCriteria = value
    }

    /**
     * @param value The name of your filter.
     */
    @JvmName("vqqadtcnsnktiywo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.
     */
    @JvmName("yvffamknppxhhjch")
    public suspend fun rank(`value`: Output<Int>) {
        this.rank = value
    }

    /**
     * @param value The tags that you want to add to the Filter resource. A tag consists of a key and a value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("matbgbeauneweimj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the action that is to be applied to the findings that match the filter. Can be one of `ARCHIVE` or `NOOP`.
     */
    @JvmName("bqdmhlcafwqcycqa")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Description of the filter.
     */
    @JvmName("aadaibpeuyrksjwl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ID of a GuardDuty detector, attached to your account.
     */
    @JvmName("tfngqcgyvarrchqo")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value Represents the criteria to be used in the filter for querying findings. Contains one or more `criterion` blocks, documented below.
     */
    @JvmName("nthydhjdovxhgafk")
    public suspend fun findingCriteria(`value`: FilterFindingCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingCriteria = mapped
    }

    /**
     * @param argument Represents the criteria to be used in the filter for querying findings. Contains one or more `criterion` blocks, documented below.
     */
    @JvmName("ptajhoqhejftwgdq")
    public suspend fun findingCriteria(argument: suspend FilterFindingCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = FilterFindingCriteriaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.findingCriteria = mapped
    }

    /**
     * @param value The name of your filter.
     */
    @JvmName("uavuptlspoymvtrs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.
     */
    @JvmName("yqmqttocwxladidu")
    public suspend fun rank(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rank = mapped
    }

    /**
     * @param value The tags that you want to add to the Filter resource. A tag consists of a key and a value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hskqsoqgonjfikli")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags that you want to add to the Filter resource. A tag consists of a key and a value. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sqcbcvyhjrtjmvqc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FilterArgs = FilterArgs(
        action = action,
        description = description,
        detectorId = detectorId,
        findingCriteria = findingCriteria,
        name = name,
        rank = rank,
        tags = tags,
    )
}
