@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.GuarddutyFunctions.getDetectorPlain
import com.pulumi.aws.guardduty.GuarddutyFunctions.getFindingIdsPlain
import com.pulumi.aws.guardduty.kotlin.inputs.GetDetectorPlainArgs
import com.pulumi.aws.guardduty.kotlin.inputs.GetDetectorPlainArgsBuilder
import com.pulumi.aws.guardduty.kotlin.inputs.GetFindingIdsPlainArgs
import com.pulumi.aws.guardduty.kotlin.inputs.GetFindingIdsPlainArgsBuilder
import com.pulumi.aws.guardduty.kotlin.outputs.GetDetectorResult
import com.pulumi.aws.guardduty.kotlin.outputs.GetFindingIdsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.guardduty.kotlin.outputs.GetDetectorResult.Companion.toKotlin as getDetectorResultToKotlin
import com.pulumi.aws.guardduty.kotlin.outputs.GetFindingIdsResult.Companion.toKotlin as getFindingIdsResultToKotlin

public object GuarddutyFunctions {
    /**
     * Retrieve information about a GuardDuty detector.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.guardduty.getDetector({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.guardduty.get_detector()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.GuardDuty.GetDetector.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := guardduty.LookupDetector(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.guardduty.GuarddutyFunctions;
     * import com.pulumi.aws.guardduty.inputs.GetDetectorArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GuarddutyFunctions.getDetector();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:guardduty:getDetector
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDetector.
     * @return A collection of values returned by getDetector.
     */
    public suspend fun getDetector(argument: GetDetectorPlainArgs): GetDetectorResult =
        getDetectorResultToKotlin(getDetectorPlain(argument.toJava()).await())

    /**
     * @see [getDetector].
     * @param id ID of the detector.
     * @return A collection of values returned by getDetector.
     */
    public suspend fun getDetector(id: String? = null): GetDetectorResult {
        val argument = GetDetectorPlainArgs(
            id = id,
        )
        return getDetectorResultToKotlin(getDetectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getDetector].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;guardduty&#46;kotlin&#46;inputs&#46;GetDetectorPlainArgs].
     * @return A collection of values returned by getDetector.
     */
    public suspend fun getDetector(argument: suspend GetDetectorPlainArgsBuilder.() -> Unit): GetDetectorResult {
        val builder = GetDetectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDetectorResultToKotlin(getDetectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS GuardDuty Finding Ids.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.guardduty.getFindingIds({
     *     detectorId: exampleAwsGuarddutyDetector.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.guardduty.get_finding_ids(detector_id=example_aws_guardduty_detector["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.GuardDuty.GetFindingIds.Invoke(new()
     *     {
     *         DetectorId = exampleAwsGuarddutyDetector.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := guardduty.GetFindingIds(ctx, &guardduty.GetFindingIdsArgs{
     * 			DetectorId: exampleAwsGuarddutyDetector.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.guardduty.GuarddutyFunctions;
     * import com.pulumi.aws.guardduty.inputs.GetFindingIdsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GuarddutyFunctions.getFindingIds(GetFindingIdsArgs.builder()
     *             .detectorId(exampleAwsGuarddutyDetector.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:guardduty:getFindingIds
     *       Arguments:
     *         detectorId: ${exampleAwsGuarddutyDetector.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFindingIds.
     * @return A collection of values returned by getFindingIds.
     */
    public suspend fun getFindingIds(argument: GetFindingIdsPlainArgs): GetFindingIdsResult =
        getFindingIdsResultToKotlin(getFindingIdsPlain(argument.toJava()).await())

    /**
     * @see [getFindingIds].
     * @param detectorId ID of the GuardDuty detector.
     * @return A collection of values returned by getFindingIds.
     */
    public suspend fun getFindingIds(detectorId: String): GetFindingIdsResult {
        val argument = GetFindingIdsPlainArgs(
            detectorId = detectorId,
        )
        return getFindingIdsResultToKotlin(getFindingIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getFindingIds].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;guardduty&#46;kotlin&#46;inputs&#46;GetFindingIdsPlainArgs].
     * @return A collection of values returned by getFindingIds.
     */
    public suspend fun getFindingIds(argument: suspend GetFindingIdsPlainArgsBuilder.() -> Unit): GetFindingIdsResult {
        val builder = GetFindingIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFindingIdsResultToKotlin(getFindingIdsPlain(builtArgument.toJava()).await())
    }
}
