@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InviteAccepter].
 */
@PulumiTagMarker
public class InviteAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InviteAccepterArgs = InviteAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InviteAccepterArgsBuilder.() -> Unit) {
        val builder = InviteAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InviteAccepter {
        val builtJavaResource = com.pulumi.aws.guardduty.InviteAccepter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InviteAccepter(builtJavaResource)
    }
}

/**
 * Provides a resource to accept a pending GuardDuty invite on creation, ensure the detector has the correct primary account on read, and disassociate with the primary account upon removal.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const primary = new aws.guardduty.Detector("primary", {});
 * const memberDetector = new aws.guardduty.Detector("member", {});
 * const memberMember = new aws.guardduty.Member("member", {
 *     accountId: memberDetector.accountId,
 *     detectorId: primary.id,
 *     email: "required@example.com",
 *     invite: true,
 * });
 * const member = new aws.guardduty.InviteAccepter("member", {
 *     detectorId: memberDetector.id,
 *     masterAccountId: primary.accountId,
 * }, {
 *     dependsOn: [memberMember],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * primary = aws.guardduty.Detector("primary")
 * member_detector = aws.guardduty.Detector("member")
 * member_member = aws.guardduty.Member("member",
 *     account_id=member_detector.account_id,
 *     detector_id=primary.id,
 *     email="required@example.com",
 *     invite=True)
 * member = aws.guardduty.InviteAccepter("member",
 *     detector_id=member_detector.id,
 *     master_account_id=primary.account_id,
 *     opts = pulumi.ResourceOptions(depends_on=[member_member]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var primary = new Aws.GuardDuty.Detector("primary");
 *     var memberDetector = new Aws.GuardDuty.Detector("member");
 *     var memberMember = new Aws.GuardDuty.Member("member", new()
 *     {
 *         AccountId = memberDetector.AccountId,
 *         DetectorId = primary.Id,
 *         Email = "required@example.com",
 *         Invite = true,
 *     });
 *     var member = new Aws.GuardDuty.InviteAccepter("member", new()
 *     {
 *         DetectorId = memberDetector.Id,
 *         MasterAccountId = primary.AccountId,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             memberMember,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		primary, err := guardduty.NewDetector(ctx, "primary", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		memberDetector, err := guardduty.NewDetector(ctx, "member", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		memberMember, err := guardduty.NewMember(ctx, "member", &guardduty.MemberArgs{
 * 			AccountId:  memberDetector.AccountId,
 * 			DetectorId: primary.ID(),
 * 			Email:      pulumi.String("required@example.com"),
 * 			Invite:     pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = guardduty.NewInviteAccepter(ctx, "member", &guardduty.InviteAccepterArgs{
 * 			DetectorId:      memberDetector.ID(),
 * 			MasterAccountId: primary.AccountId,
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			memberMember,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.Member;
 * import com.pulumi.aws.guardduty.MemberArgs;
 * import com.pulumi.aws.guardduty.InviteAccepter;
 * import com.pulumi.aws.guardduty.InviteAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Detector("primary");
 *         var memberDetector = new Detector("memberDetector");
 *         var memberMember = new Member("memberMember", MemberArgs.builder()
 *             .accountId(memberDetector.accountId())
 *             .detectorId(primary.id())
 *             .email("required@example.com")
 *             .invite(true)
 *             .build());
 *         var member = new InviteAccepter("member", InviteAccepterArgs.builder()
 *             .detectorId(memberDetector.id())
 *             .masterAccountId(primary.accountId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(memberMember)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   member:
 *     type: aws:guardduty:InviteAccepter
 *     properties:
 *       detectorId: ${memberDetector.id}
 *       masterAccountId: ${primary.accountId}
 *     options:
 *       dependson:
 *         - ${memberMember}
 *   memberMember:
 *     type: aws:guardduty:Member
 *     name: member
 *     properties:
 *       accountId: ${memberDetector.accountId}
 *       detectorId: ${primary.id}
 *       email: required@example.com
 *       invite: true
 *   primary:
 *     type: aws:guardduty:Detector
 *   memberDetector:
 *     type: aws:guardduty:Detector
 *     name: member
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_guardduty_invite_accepter` using the member GuardDuty detector ID. For example:
 * ```sh
 * $ pulumi import aws:guardduty/inviteAccepter:InviteAccepter member 00b00fd5aecc0ab60a708659477e9617
 * ```
 */
public class InviteAccepter internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.InviteAccepter,
) : KotlinCustomResource(javaResource, InviteAccepterMapper) {
    /**
     * The detector ID of the member GuardDuty account.
     */
    public val detectorId: Output<String>
        get() = javaResource.detectorId().applyValue({ args0 -> args0 })

    /**
     * AWS account ID for primary account.
     */
    public val masterAccountId: Output<String>
        get() = javaResource.masterAccountId().applyValue({ args0 -> args0 })
}

public object InviteAccepterMapper : ResourceMapper<InviteAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.InviteAccepter::class == javaResource::class

    override fun map(javaResource: Resource): InviteAccepter = InviteAccepter(
        javaResource as
            com.pulumi.aws.guardduty.InviteAccepter,
    )
}

/**
 * @see [InviteAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InviteAccepter].
 */
public suspend fun inviteAccepter(
    name: String,
    block: suspend InviteAccepterResourceBuilder.() -> Unit,
): InviteAccepter {
    val builder = InviteAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InviteAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inviteAccepter(name: String): InviteAccepter {
    val builder = InviteAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
