@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.InviteAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to accept a pending GuardDuty invite on creation, ensure the detector has the correct primary account on read, and disassociate with the primary account upon removal.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const primary = new aws.guardduty.Detector("primary", {});
 * const memberDetector = new aws.guardduty.Detector("member", {});
 * const memberMember = new aws.guardduty.Member("member", {
 *     accountId: memberDetector.accountId,
 *     detectorId: primary.id,
 *     email: "required@example.com",
 *     invite: true,
 * });
 * const member = new aws.guardduty.InviteAccepter("member", {
 *     detectorId: memberDetector.id,
 *     masterAccountId: primary.accountId,
 * }, {
 *     dependsOn: [memberMember],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * primary = aws.guardduty.Detector("primary")
 * member_detector = aws.guardduty.Detector("member")
 * member_member = aws.guardduty.Member("member",
 *     account_id=member_detector.account_id,
 *     detector_id=primary.id,
 *     email="required@example.com",
 *     invite=True)
 * member = aws.guardduty.InviteAccepter("member",
 *     detector_id=member_detector.id,
 *     master_account_id=primary.account_id,
 *     opts = pulumi.ResourceOptions(depends_on=[member_member]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var primary = new Aws.GuardDuty.Detector("primary");
 *     var memberDetector = new Aws.GuardDuty.Detector("member");
 *     var memberMember = new Aws.GuardDuty.Member("member", new()
 *     {
 *         AccountId = memberDetector.AccountId,
 *         DetectorId = primary.Id,
 *         Email = "required@example.com",
 *         Invite = true,
 *     });
 *     var member = new Aws.GuardDuty.InviteAccepter("member", new()
 *     {
 *         DetectorId = memberDetector.Id,
 *         MasterAccountId = primary.AccountId,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             memberMember,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		primary, err := guardduty.NewDetector(ctx, "primary", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		memberDetector, err := guardduty.NewDetector(ctx, "member", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		memberMember, err := guardduty.NewMember(ctx, "member", &guardduty.MemberArgs{
 * 			AccountId:  memberDetector.AccountId,
 * 			DetectorId: primary.ID(),
 * 			Email:      pulumi.String("required@example.com"),
 * 			Invite:     pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = guardduty.NewInviteAccepter(ctx, "member", &guardduty.InviteAccepterArgs{
 * 			DetectorId:      memberDetector.ID(),
 * 			MasterAccountId: primary.AccountId,
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			memberMember,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.Member;
 * import com.pulumi.aws.guardduty.MemberArgs;
 * import com.pulumi.aws.guardduty.InviteAccepter;
 * import com.pulumi.aws.guardduty.InviteAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Detector("primary");
 *         var memberDetector = new Detector("memberDetector");
 *         var memberMember = new Member("memberMember", MemberArgs.builder()
 *             .accountId(memberDetector.accountId())
 *             .detectorId(primary.id())
 *             .email("required@example.com")
 *             .invite(true)
 *             .build());
 *         var member = new InviteAccepter("member", InviteAccepterArgs.builder()
 *             .detectorId(memberDetector.id())
 *             .masterAccountId(primary.accountId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(memberMember)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   member:
 *     type: aws:guardduty:InviteAccepter
 *     properties:
 *       detectorId: ${memberDetector.id}
 *       masterAccountId: ${primary.accountId}
 *     options:
 *       dependson:
 *         - ${memberMember}
 *   memberMember:
 *     type: aws:guardduty:Member
 *     name: member
 *     properties:
 *       accountId: ${memberDetector.accountId}
 *       detectorId: ${primary.id}
 *       email: required@example.com
 *       invite: true
 *   primary:
 *     type: aws:guardduty:Detector
 *   memberDetector:
 *     type: aws:guardduty:Detector
 *     name: member
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_guardduty_invite_accepter` using the member GuardDuty detector ID. For example:
 * ```sh
 * $ pulumi import aws:guardduty/inviteAccepter:InviteAccepter member 00b00fd5aecc0ab60a708659477e9617
 * ```
 * @property detectorId The detector ID of the member GuardDuty account.
 * @property masterAccountId AWS account ID for primary account.
 */
public data class InviteAccepterArgs(
    public val detectorId: Output<String>? = null,
    public val masterAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.InviteAccepterArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.InviteAccepterArgs =
        com.pulumi.aws.guardduty.InviteAccepterArgs.builder()
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .masterAccountId(masterAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InviteAccepterArgs].
 */
@PulumiTagMarker
public class InviteAccepterArgsBuilder internal constructor() {
    private var detectorId: Output<String>? = null

    private var masterAccountId: Output<String>? = null

    /**
     * @param value The detector ID of the member GuardDuty account.
     */
    @JvmName("gbrpytpaxpuaeesk")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value AWS account ID for primary account.
     */
    @JvmName("bcihtqcgonunksja")
    public suspend fun masterAccountId(`value`: Output<String>) {
        this.masterAccountId = value
    }

    /**
     * @param value The detector ID of the member GuardDuty account.
     */
    @JvmName("upxailffdqlgoart")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value AWS account ID for primary account.
     */
    @JvmName("tdrufofjrqtthmhd")
    public suspend fun masterAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterAccountId = mapped
    }

    internal fun build(): InviteAccepterArgs = InviteAccepterArgs(
        detectorId = detectorId,
        masterAccountId = masterAccountId,
    )
}
