@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.kotlin.outputs.MalwareProtectionPlanAction
import com.pulumi.aws.guardduty.kotlin.outputs.MalwareProtectionPlanProtectedResource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.guardduty.kotlin.outputs.MalwareProtectionPlanAction.Companion.toKotlin as malwareProtectionPlanActionToKotlin
import com.pulumi.aws.guardduty.kotlin.outputs.MalwareProtectionPlanProtectedResource.Companion.toKotlin as malwareProtectionPlanProtectedResourceToKotlin

/**
 * Builder for [MalwareProtectionPlan].
 */
@PulumiTagMarker
public class MalwareProtectionPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MalwareProtectionPlanArgs = MalwareProtectionPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MalwareProtectionPlanArgsBuilder.() -> Unit) {
        val builder = MalwareProtectionPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MalwareProtectionPlan {
        val builtJavaResource = com.pulumi.aws.guardduty.MalwareProtectionPlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MalwareProtectionPlan(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a GuardDuty malware protection plan.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.MalwareProtectionPlan;
 * import com.pulumi.aws.guardduty.MalwareProtectionPlanArgs;
 * import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceArgs;
 * import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceS3BucketArgs;
 * import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MalwareProtectionPlan("example", MalwareProtectionPlanArgs.builder()
 *             .role(exampleAwsIamRole.arn())
 *             .protectedResource(MalwareProtectionPlanProtectedResourceArgs.builder()
 *                 .s3Bucket(MalwareProtectionPlanProtectedResourceS3BucketArgs.builder()
 *                     .bucketName(exampleAwsS3Bucket.id())
 *                     .objectPrefixes(
 *                         "example1",
 *                         "example2")
 *                     .build())
 *                 .build())
 *             .actions(MalwareProtectionPlanActionArgs.builder()
 *                 .tagging(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:guardduty:MalwareProtectionPlan
 *     properties:
 *       role: ${exampleAwsIamRole.arn}
 *       protectedResource:
 *         s3Bucket:
 *           bucketName: ${exampleAwsS3Bucket.id}
 *           objectPrefixes:
 *             - example1
 *             - example2
 *       actions:
 *         - tagging:
 *             - status: ENABLED
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GuardDuty malware protection plans using their IDs. For example:
 * ```sh
 * $ pulumi import aws:guardduty/malwareProtectionPlan:MalwareProtectionPlan example 1234567890abcdef0123
 * ```
 */
public class MalwareProtectionPlan internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.MalwareProtectionPlan,
) : KotlinCustomResource(javaResource, MalwareProtectionPlanMapper) {
    /**
     * Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
     */
    public val actions: Output<List<MalwareProtectionPlanAction>>
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    malwareProtectionPlanActionToKotlin(args0)
                })
            })
        })

    /**
     * The ARN of the GuardDuty malware protection plan
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the Malware Protection plan resource was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
     */
    public val protectedResource: Output<MalwareProtectionPlanProtectedResource>?
        get() = javaResource.protectedResource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> malwareProtectionPlanProtectedResourceToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The GuardDuty malware protection plan status. Valid values are `ACTIVE`, `WARNING`, and `ERROR`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MalwareProtectionPlanMapper : ResourceMapper<MalwareProtectionPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.MalwareProtectionPlan::class == javaResource::class

    override fun map(javaResource: Resource): MalwareProtectionPlan =
        MalwareProtectionPlan(javaResource as com.pulumi.aws.guardduty.MalwareProtectionPlan)
}

/**
 * @see [MalwareProtectionPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MalwareProtectionPlan].
 */
public suspend fun malwareProtectionPlan(
    name: String,
    block: suspend MalwareProtectionPlanResourceBuilder.() -> Unit,
): MalwareProtectionPlan {
    val builder = MalwareProtectionPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MalwareProtectionPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun malwareProtectionPlan(name: String): MalwareProtectionPlan {
    val builder = MalwareProtectionPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
