@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.MalwareProtectionPlanArgs.builder
import com.pulumi.aws.guardduty.kotlin.inputs.MalwareProtectionPlanActionArgs
import com.pulumi.aws.guardduty.kotlin.inputs.MalwareProtectionPlanActionArgsBuilder
import com.pulumi.aws.guardduty.kotlin.inputs.MalwareProtectionPlanProtectedResourceArgs
import com.pulumi.aws.guardduty.kotlin.inputs.MalwareProtectionPlanProtectedResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a GuardDuty malware protection plan.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.MalwareProtectionPlan;
 * import com.pulumi.aws.guardduty.MalwareProtectionPlanArgs;
 * import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceArgs;
 * import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceS3BucketArgs;
 * import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MalwareProtectionPlan("example", MalwareProtectionPlanArgs.builder()
 *             .role(exampleAwsIamRole.arn())
 *             .protectedResource(MalwareProtectionPlanProtectedResourceArgs.builder()
 *                 .s3Bucket(MalwareProtectionPlanProtectedResourceS3BucketArgs.builder()
 *                     .bucketName(exampleAwsS3Bucket.id())
 *                     .objectPrefixes(
 *                         "example1",
 *                         "example2")
 *                     .build())
 *                 .build())
 *             .actions(MalwareProtectionPlanActionArgs.builder()
 *                 .tagging(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:guardduty:MalwareProtectionPlan
 *     properties:
 *       role: ${exampleAwsIamRole.arn}
 *       protectedResource:
 *         s3Bucket:
 *           bucketName: ${exampleAwsS3Bucket.id}
 *           objectPrefixes:
 *             - example1
 *             - example2
 *       actions:
 *         - tagging:
 *             - status: ENABLED
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GuardDuty malware protection plans using their IDs. For example:
 * ```sh
 * $ pulumi import aws:guardduty/malwareProtectionPlan:MalwareProtectionPlan example 1234567890abcdef0123
 * ```
 * @property actions Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
 * @property protectedResource Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
 * @property role ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class MalwareProtectionPlanArgs(
    public val actions: Output<List<MalwareProtectionPlanActionArgs>>? = null,
    public val protectedResource: Output<MalwareProtectionPlanProtectedResourceArgs>? = null,
    public val role: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.MalwareProtectionPlanArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.MalwareProtectionPlanArgs =
        com.pulumi.aws.guardduty.MalwareProtectionPlanArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protectedResource(protectedResource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .role(role?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MalwareProtectionPlanArgs].
 */
@PulumiTagMarker
public class MalwareProtectionPlanArgsBuilder internal constructor() {
    private var actions: Output<List<MalwareProtectionPlanActionArgs>>? = null

    private var protectedResource: Output<MalwareProtectionPlanProtectedResourceArgs>? = null

    private var role: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
     */
    @JvmName("dqovdhyosnwcdidf")
    public suspend fun actions(`value`: Output<List<MalwareProtectionPlanActionArgs>>) {
        this.actions = value
    }

    @JvmName("fnrucircdhrtrlac")
    public suspend fun actions(vararg values: Output<MalwareProtectionPlanActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
     */
    @JvmName("rbyuhrwdwnhauyeq")
    public suspend fun actions(values: List<Output<MalwareProtectionPlanActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
     */
    @JvmName("nbnxsqgxmtnkbnmv")
    public suspend fun protectedResource(`value`: Output<MalwareProtectionPlanProtectedResourceArgs>) {
        this.protectedResource = value
    }

    /**
     * @param value ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
     */
    @JvmName("oereaxrxfyphbxia")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rwuuswvufroqimpq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
     */
    @JvmName("tpivcjugjmwqwuky")
    public suspend fun actions(`value`: List<MalwareProtectionPlanActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
     */
    @JvmName("faspuxsfkcatruvn")
    public suspend fun actions(argument: List<suspend MalwareProtectionPlanActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MalwareProtectionPlanActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
     */
    @JvmName("inypbjjwyuomjxlf")
    public suspend fun actions(vararg argument: suspend MalwareProtectionPlanActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MalwareProtectionPlanActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
     */
    @JvmName("ndabxemjxndulbsr")
    public suspend fun actions(argument: suspend MalwareProtectionPlanActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MalwareProtectionPlanActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
     */
    @JvmName("coporjglpownwdlx")
    public suspend fun actions(vararg values: MalwareProtectionPlanActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
     */
    @JvmName("awnxcsuphkowimqp")
    public suspend fun protectedResource(`value`: MalwareProtectionPlanProtectedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedResource = mapped
    }

    /**
     * @param argument Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
     */
    @JvmName("ueixianuuyffvbvq")
    public suspend fun protectedResource(argument: suspend MalwareProtectionPlanProtectedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = MalwareProtectionPlanProtectedResourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.protectedResource = mapped
    }

    /**
     * @param value ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
     */
    @JvmName("rjpnqbvdfjvdbpgh")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rxxytivjjlmbthja")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("viidkockukbrkjtg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MalwareProtectionPlanArgs = MalwareProtectionPlanArgs(
        actions = actions,
        protectedResource = protectedResource,
        role = role,
        tags = tags,
    )
}
