@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.MemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a GuardDuty member. To accept invitations in member accounts, see the `aws.guardduty.InviteAccepter` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const primary = new aws.guardduty.Detector("primary", {enable: true});
 * const member = new aws.guardduty.Detector("member", {enable: true});
 * const memberMember = new aws.guardduty.Member("member", {
 *     accountId: member.accountId,
 *     detectorId: primary.id,
 *     email: "required@example.com",
 *     invite: true,
 *     invitationMessage: "please accept guardduty invitation",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * primary = aws.guardduty.Detector("primary", enable=True)
 * member = aws.guardduty.Detector("member", enable=True)
 * member_member = aws.guardduty.Member("member",
 *     account_id=member.account_id,
 *     detector_id=primary.id,
 *     email="required@example.com",
 *     invite=True,
 *     invitation_message="please accept guardduty invitation")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var primary = new Aws.GuardDuty.Detector("primary", new()
 *     {
 *         Enable = true,
 *     });
 *     var member = new Aws.GuardDuty.Detector("member", new()
 *     {
 *         Enable = true,
 *     });
 *     var memberMember = new Aws.GuardDuty.Member("member", new()
 *     {
 *         AccountId = member.AccountId,
 *         DetectorId = primary.Id,
 *         Email = "required@example.com",
 *         Invite = true,
 *         InvitationMessage = "please accept guardduty invitation",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		primary, err := guardduty.NewDetector(ctx, "primary", &guardduty.DetectorArgs{
 * 			Enable: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		member, err := guardduty.NewDetector(ctx, "member", &guardduty.DetectorArgs{
 * 			Enable: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = guardduty.NewMember(ctx, "member", &guardduty.MemberArgs{
 * 			AccountId:         member.AccountId,
 * 			DetectorId:        primary.ID(),
 * 			Email:             pulumi.String("required@example.com"),
 * 			Invite:            pulumi.Bool(true),
 * 			InvitationMessage: pulumi.String("please accept guardduty invitation"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.Member;
 * import com.pulumi.aws.guardduty.MemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Detector("primary", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var member = new Detector("member", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var memberMember = new Member("memberMember", MemberArgs.builder()
 *             .accountId(member.accountId())
 *             .detectorId(primary.id())
 *             .email("required@example.com")
 *             .invite(true)
 *             .invitationMessage("please accept guardduty invitation")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   primary:
 *     type: aws:guardduty:Detector
 *     properties:
 *       enable: true
 *   member:
 *     type: aws:guardduty:Detector
 *     properties:
 *       enable: true
 *   memberMember:
 *     type: aws:guardduty:Member
 *     name: member
 *     properties:
 *       accountId: ${member.accountId}
 *       detectorId: ${primary.id}
 *       email: required@example.com
 *       invite: true
 *       invitationMessage: please accept guardduty invitation
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GuardDuty members using the primary GuardDuty detector ID and member AWS account ID. For example:
 * ```sh
 * $ pulumi import aws:guardduty/member:Member MyMember 00b00fd5aecc0ab60a708659477e9617:123456789012
 * ```
 * @property accountId AWS account ID for member account.
 * @property detectorId The detector ID of the GuardDuty account where you want to create member accounts.
 * @property disableEmailNotification Boolean whether an email notification is sent to the accounts. Defaults to `false`.
 * @property email Email address for member account.
 * @property invitationMessage Message for invitation.
 * @property invite Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
 */
public data class MemberArgs(
    public val accountId: Output<String>? = null,
    public val detectorId: Output<String>? = null,
    public val disableEmailNotification: Output<Boolean>? = null,
    public val email: Output<String>? = null,
    public val invitationMessage: Output<String>? = null,
    public val invite: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.MemberArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.MemberArgs =
        com.pulumi.aws.guardduty.MemberArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .disableEmailNotification(disableEmailNotification?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .invitationMessage(invitationMessage?.applyValue({ args0 -> args0 }))
            .invite(invite?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MemberArgs].
 */
@PulumiTagMarker
public class MemberArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var detectorId: Output<String>? = null

    private var disableEmailNotification: Output<Boolean>? = null

    private var email: Output<String>? = null

    private var invitationMessage: Output<String>? = null

    private var invite: Output<Boolean>? = null

    /**
     * @param value AWS account ID for member account.
     */
    @JvmName("ifioxnmnbpamqlwm")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The detector ID of the GuardDuty account where you want to create member accounts.
     */
    @JvmName("tecglxkmwqkshnin")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value Boolean whether an email notification is sent to the accounts. Defaults to `false`.
     */
    @JvmName("jyuijgrbvbpvfoix")
    public suspend fun disableEmailNotification(`value`: Output<Boolean>) {
        this.disableEmailNotification = value
    }

    /**
     * @param value Email address for member account.
     */
    @JvmName("munkqkyxfolgnumh")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Message for invitation.
     */
    @JvmName("bbvektrhfnsusbwk")
    public suspend fun invitationMessage(`value`: Output<String>) {
        this.invitationMessage = value
    }

    /**
     * @param value Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
     */
    @JvmName("xayoytdevoctlnrd")
    public suspend fun invite(`value`: Output<Boolean>) {
        this.invite = value
    }

    /**
     * @param value AWS account ID for member account.
     */
    @JvmName("afgrjqhhjlupytcu")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The detector ID of the GuardDuty account where you want to create member accounts.
     */
    @JvmName("mjndluowhixoqutb")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value Boolean whether an email notification is sent to the accounts. Defaults to `false`.
     */
    @JvmName("qjluxiettwnaqaqw")
    public suspend fun disableEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableEmailNotification = mapped
    }

    /**
     * @param value Email address for member account.
     */
    @JvmName("umqbtvnheightefx")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Message for invitation.
     */
    @JvmName("oxbcwspyajstekrs")
    public suspend fun invitationMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invitationMessage = mapped
    }

    /**
     * @param value Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
     */
    @JvmName("dsmfvjuwtgurstea")
    public suspend fun invite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invite = mapped
    }

    internal fun build(): MemberArgs = MemberArgs(
        accountId = accountId,
        detectorId = detectorId,
        disableEmailNotification = disableEmailNotification,
        email = email,
        invitationMessage = invitationMessage,
        invite = invite,
    )
}
