@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationDatasources
import com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationDatasources.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationConfiguration].
 */
@PulumiTagMarker
public class OrganizationConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationConfigurationArgs = OrganizationConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationConfigurationArgsBuilder.() -> Unit) {
        val builder = OrganizationConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationConfiguration {
        val builtJavaResource =
            com.pulumi.aws.guardduty.OrganizationConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationConfiguration(builtJavaResource)
    }
}

/**
 * Manages the GuardDuty Organization Configuration in the current AWS Region. The AWS account utilizing this resource must have been assigned as a delegated Organization administrator account, e.g., via the `aws.guardduty.OrganizationAdminAccount` resource. More information about Organizations support in GuardDuty can be found in the [GuardDuty User Guide](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html).
 * > **NOTE:** This is an advanced resource. The provider will automatically assume management of the GuardDuty Organization Configuration without import and perform no actions on removal from the resource configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.guardduty.Detector("example", {enable: true});
 * const exampleOrganizationConfiguration = new aws.guardduty.OrganizationConfiguration("example", {
 *     autoEnableOrganizationMembers: "ALL",
 *     detectorId: example.id,
 *     datasources: {
 *         s3Logs: {
 *             autoEnable: true,
 *         },
 *         kubernetes: {
 *             auditLogs: {
 *                 enable: true,
 *             },
 *         },
 *         malwareProtection: {
 *             scanEc2InstanceWithFindings: {
 *                 ebsVolumes: {
 *                     autoEnable: true,
 *                 },
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.guardduty.Detector("example", enable=True)
 * example_organization_configuration = aws.guardduty.OrganizationConfiguration("example",
 *     auto_enable_organization_members="ALL",
 *     detector_id=example.id,
 *     datasources={
 *         "s3_logs": {
 *             "auto_enable": True,
 *         },
 *         "kubernetes": {
 *             "audit_logs": {
 *                 "enable": True,
 *             },
 *         },
 *         "malware_protection": {
 *             "scan_ec2_instance_with_findings": {
 *                 "ebs_volumes": {
 *                     "auto_enable": True,
 *                 },
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GuardDuty.Detector("example", new()
 *     {
 *         Enable = true,
 *     });
 *     var exampleOrganizationConfiguration = new Aws.GuardDuty.OrganizationConfiguration("example", new()
 *     {
 *         AutoEnableOrganizationMembers = "ALL",
 *         DetectorId = example.Id,
 *         Datasources = new Aws.GuardDuty.Inputs.OrganizationConfigurationDatasourcesArgs
 *         {
 *             S3Logs = new Aws.GuardDuty.Inputs.OrganizationConfigurationDatasourcesS3LogsArgs
 *             {
 *                 AutoEnable = true,
 *             },
 *             Kubernetes = new Aws.GuardDuty.Inputs.OrganizationConfigurationDatasourcesKubernetesArgs
 *             {
 *                 AuditLogs = new Aws.GuardDuty.Inputs.OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs
 *                 {
 *                     Enable = true,
 *                 },
 *             },
 *             MalwareProtection = new Aws.GuardDuty.Inputs.OrganizationConfigurationDatasourcesMalwareProtectionArgs
 *             {
 *                 ScanEc2InstanceWithFindings = new Aws.GuardDuty.Inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs
 *                 {
 *                     EbsVolumes = new Aws.GuardDuty.Inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs
 *                     {
 *                         AutoEnable = true,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := guardduty.NewDetector(ctx, "example", &guardduty.DetectorArgs{
 * 			Enable: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = guardduty.NewOrganizationConfiguration(ctx, "example", &guardduty.OrganizationConfigurationArgs{
 * 			AutoEnableOrganizationMembers: pulumi.String("ALL"),
 * 			DetectorId:                    example.ID(),
 * 			Datasources: &guardduty.OrganizationConfigurationDatasourcesArgs{
 * 				S3Logs: &guardduty.OrganizationConfigurationDatasourcesS3LogsArgs{
 * 					AutoEnable: pulumi.Bool(true),
 * 				},
 * 				Kubernetes: &guardduty.OrganizationConfigurationDatasourcesKubernetesArgs{
 * 					AuditLogs: &guardduty.OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs{
 * 						Enable: pulumi.Bool(true),
 * 					},
 * 				},
 * 				MalwareProtection: &guardduty.OrganizationConfigurationDatasourcesMalwareProtectionArgs{
 * 					ScanEc2InstanceWithFindings: &guardduty.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs{
 * 						EbsVolumes: &guardduty.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs{
 * 							AutoEnable: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.OrganizationConfiguration;
 * import com.pulumi.aws.guardduty.OrganizationConfigurationArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesS3LogsArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Detector("example", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var exampleOrganizationConfiguration = new OrganizationConfiguration("exampleOrganizationConfiguration", OrganizationConfigurationArgs.builder()
 *             .autoEnableOrganizationMembers("ALL")
 *             .detectorId(example.id())
 *             .datasources(OrganizationConfigurationDatasourcesArgs.builder()
 *                 .s3Logs(OrganizationConfigurationDatasourcesS3LogsArgs.builder()
 *                     .autoEnable(true)
 *                     .build())
 *                 .kubernetes(OrganizationConfigurationDatasourcesKubernetesArgs.builder()
 *                     .auditLogs(OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs.builder()
 *                         .enable(true)
 *                         .build())
 *                     .build())
 *                 .malwareProtection(OrganizationConfigurationDatasourcesMalwareProtectionArgs.builder()
 *                     .scanEc2InstanceWithFindings(OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs.builder()
 *                         .ebsVolumes(OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs.builder()
 *                             .autoEnable(true)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:guardduty:Detector
 *     properties:
 *       enable: true
 *   exampleOrganizationConfiguration:
 *     type: aws:guardduty:OrganizationConfiguration
 *     name: example
 *     properties:
 *       autoEnableOrganizationMembers: ALL
 *       detectorId: ${example.id}
 *       datasources:
 *         s3Logs:
 *           autoEnable: true
 *         kubernetes:
 *           auditLogs:
 *             enable: true
 *         malwareProtection:
 *           scanEc2InstanceWithFindings:
 *             ebsVolumes:
 *               autoEnable: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import GuardDuty Organization Configurations using the GuardDuty Detector ID. For example:
 * ```sh
 * $ pulumi import aws:guardduty/organizationConfiguration:OrganizationConfiguration example 00b00fd5aecc0ab60a708659477e9617
 * ```
 */
public class OrganizationConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.OrganizationConfiguration,
) : KotlinCustomResource(javaResource, OrganizationConfigurationMapper) {
    /**
     * *Deprecated:* Use `auto_enable_organization_members` instead. When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s GuardDuty delegated administrator and GuardDuty is enabled in that AWS Region.
     */
    @Deprecated(
        message = """
  Use auto_enable_organization_members instead
  """,
    )
    public val autoEnable: Output<Boolean>
        get() = javaResource.autoEnable().applyValue({ args0 -> args0 })

    /**
     * Indicates the auto-enablement configuration of GuardDuty for the member accounts in the organization. Valid values are `ALL`, `NEW`, `NONE`.
     */
    public val autoEnableOrganizationMembers: Output<String>
        get() = javaResource.autoEnableOrganizationMembers().applyValue({ args0 -> args0 })

    /**
     * Configuration for the collected datasources.
     */
    public val datasources: Output<OrganizationConfigurationDatasources>
        get() = javaResource.datasources().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The detector ID of the GuardDuty account.
     */
    public val detectorId: Output<String>
        get() = javaResource.detectorId().applyValue({ args0 -> args0 })
}

public object OrganizationConfigurationMapper : ResourceMapper<OrganizationConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.OrganizationConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationConfiguration =
        OrganizationConfiguration(javaResource as com.pulumi.aws.guardduty.OrganizationConfiguration)
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationConfiguration].
 */
public suspend fun organizationConfiguration(
    name: String,
    block: suspend OrganizationConfigurationResourceBuilder.() -> Unit,
): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationConfiguration(name: String): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
