@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationFeatureAdditionalConfiguration
import com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationFeatureAdditionalConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [OrganizationConfigurationFeature].
 */
@PulumiTagMarker
public class OrganizationConfigurationFeatureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationConfigurationFeatureArgs = OrganizationConfigurationFeatureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationConfigurationFeatureArgsBuilder.() -> Unit) {
        val builder = OrganizationConfigurationFeatureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationConfigurationFeature {
        val builtJavaResource =
            com.pulumi.aws.guardduty.OrganizationConfigurationFeature(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationConfigurationFeature(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a single Amazon GuardDuty [organization configuration feature](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-features-activation-model.html#guardduty-features).
 * > **NOTE:** Deleting this resource does not disable the organization configuration feature, the resource in simply removed from state instead.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.guardduty.Detector("example", {enable: true});
 * const eksRuntimeMonitoring = new aws.guardduty.OrganizationConfigurationFeature("eks_runtime_monitoring", {
 *     detectorId: example.id,
 *     name: "EKS_RUNTIME_MONITORING",
 *     autoEnable: "ALL",
 *     additionalConfigurations: [{
 *         name: "EKS_ADDON_MANAGEMENT",
 *         autoEnable: "NEW",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.guardduty.Detector("example", enable=True)
 * eks_runtime_monitoring = aws.guardduty.OrganizationConfigurationFeature("eks_runtime_monitoring",
 *     detector_id=example.id,
 *     name="EKS_RUNTIME_MONITORING",
 *     auto_enable="ALL",
 *     additional_configurations=[{
 *         "name": "EKS_ADDON_MANAGEMENT",
 *         "auto_enable": "NEW",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GuardDuty.Detector("example", new()
 *     {
 *         Enable = true,
 *     });
 *     var eksRuntimeMonitoring = new Aws.GuardDuty.OrganizationConfigurationFeature("eks_runtime_monitoring", new()
 *     {
 *         DetectorId = example.Id,
 *         Name = "EKS_RUNTIME_MONITORING",
 *         AutoEnable = "ALL",
 *         AdditionalConfigurations = new[]
 *         {
 *             new Aws.GuardDuty.Inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs
 *             {
 *                 Name = "EKS_ADDON_MANAGEMENT",
 *                 AutoEnable = "NEW",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := guardduty.NewDetector(ctx, "example", &guardduty.DetectorArgs{
 * 			Enable: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = guardduty.NewOrganizationConfigurationFeature(ctx, "eks_runtime_monitoring", &guardduty.OrganizationConfigurationFeatureArgs{
 * 			DetectorId: example.ID(),
 * 			Name:       pulumi.String("EKS_RUNTIME_MONITORING"),
 * 			AutoEnable: pulumi.String("ALL"),
 * 			AdditionalConfigurations: guardduty.OrganizationConfigurationFeatureAdditionalConfigurationArray{
 * 				&guardduty.OrganizationConfigurationFeatureAdditionalConfigurationArgs{
 * 					Name:       pulumi.String("EKS_ADDON_MANAGEMENT"),
 * 					AutoEnable: pulumi.String("NEW"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.OrganizationConfigurationFeature;
 * import com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Detector("example", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var eksRuntimeMonitoring = new OrganizationConfigurationFeature("eksRuntimeMonitoring", OrganizationConfigurationFeatureArgs.builder()
 *             .detectorId(example.id())
 *             .name("EKS_RUNTIME_MONITORING")
 *             .autoEnable("ALL")
 *             .additionalConfigurations(OrganizationConfigurationFeatureAdditionalConfigurationArgs.builder()
 *                 .name("EKS_ADDON_MANAGEMENT")
 *                 .autoEnable("NEW")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:guardduty:Detector
 *     properties:
 *       enable: true
 *   eksRuntimeMonitoring:
 *     type: aws:guardduty:OrganizationConfigurationFeature
 *     name: eks_runtime_monitoring
 *     properties:
 *       detectorId: ${example.id}
 *       name: EKS_RUNTIME_MONITORING
 *       autoEnable: ALL
 *       additionalConfigurations:
 *         - name: EKS_ADDON_MANAGEMENT
 *           autoEnable: NEW
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class OrganizationConfigurationFeature internal constructor(
    override val javaResource: com.pulumi.aws.guardduty.OrganizationConfigurationFeature,
) : KotlinCustomResource(javaResource, OrganizationConfigurationFeatureMapper) {
    /**
     * Additional feature configuration block for features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    public val additionalConfigurations:
        Output<List<OrganizationConfigurationFeatureAdditionalConfiguration>>?
        get() = javaResource.additionalConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The status of the feature that is configured for the member accounts within the organization. Valid values: `NEW`, `ALL`, `NONE`.
     */
    public val autoEnable: Output<String>
        get() = javaResource.autoEnable().applyValue({ args0 -> args0 })

    /**
     * The ID of the detector that configures the delegated administrator.
     */
    public val detectorId: Output<String>
        get() = javaResource.detectorId().applyValue({ args0 -> args0 })

    /**
     * The name of the feature that will be configured for the organization. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`, `RUNTIME_MONITORING`. Only one of two features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING` can be added, adding both features will cause an error. Refer to the [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html) for the current list of supported values.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object OrganizationConfigurationFeatureMapper :
    ResourceMapper<OrganizationConfigurationFeature> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.guardduty.OrganizationConfigurationFeature::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationConfigurationFeature =
        OrganizationConfigurationFeature(
            javaResource as
                com.pulumi.aws.guardduty.OrganizationConfigurationFeature,
        )
}

/**
 * @see [OrganizationConfigurationFeature].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationConfigurationFeature].
 */
public suspend fun organizationConfigurationFeature(
    name: String,
    block: suspend OrganizationConfigurationFeatureResourceBuilder.() -> Unit,
): OrganizationConfigurationFeature {
    val builder = OrganizationConfigurationFeatureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationConfigurationFeature].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationConfigurationFeature(name: String): OrganizationConfigurationFeature {
    val builder = OrganizationConfigurationFeatureResourceBuilder()
    builder.name(name)
    return builder.build()
}
