@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin

import com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs.builder
import com.pulumi.aws.guardduty.kotlin.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs
import com.pulumi.aws.guardduty.kotlin.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a single Amazon GuardDuty [organization configuration feature](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-features-activation-model.html#guardduty-features).
 * > **NOTE:** Deleting this resource does not disable the organization configuration feature, the resource in simply removed from state instead.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.guardduty.Detector("example", {enable: true});
 * const eksRuntimeMonitoring = new aws.guardduty.OrganizationConfigurationFeature("eks_runtime_monitoring", {
 *     detectorId: example.id,
 *     name: "EKS_RUNTIME_MONITORING",
 *     autoEnable: "ALL",
 *     additionalConfigurations: [{
 *         name: "EKS_ADDON_MANAGEMENT",
 *         autoEnable: "NEW",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.guardduty.Detector("example", enable=True)
 * eks_runtime_monitoring = aws.guardduty.OrganizationConfigurationFeature("eks_runtime_monitoring",
 *     detector_id=example.id,
 *     name="EKS_RUNTIME_MONITORING",
 *     auto_enable="ALL",
 *     additional_configurations=[{
 *         "name": "EKS_ADDON_MANAGEMENT",
 *         "auto_enable": "NEW",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.GuardDuty.Detector("example", new()
 *     {
 *         Enable = true,
 *     });
 *     var eksRuntimeMonitoring = new Aws.GuardDuty.OrganizationConfigurationFeature("eks_runtime_monitoring", new()
 *     {
 *         DetectorId = example.Id,
 *         Name = "EKS_RUNTIME_MONITORING",
 *         AutoEnable = "ALL",
 *         AdditionalConfigurations = new[]
 *         {
 *             new Aws.GuardDuty.Inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs
 *             {
 *                 Name = "EKS_ADDON_MANAGEMENT",
 *                 AutoEnable = "NEW",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/guardduty"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := guardduty.NewDetector(ctx, "example", &guardduty.DetectorArgs{
 * 			Enable: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = guardduty.NewOrganizationConfigurationFeature(ctx, "eks_runtime_monitoring", &guardduty.OrganizationConfigurationFeatureArgs{
 * 			DetectorId: example.ID(),
 * 			Name:       pulumi.String("EKS_RUNTIME_MONITORING"),
 * 			AutoEnable: pulumi.String("ALL"),
 * 			AdditionalConfigurations: guardduty.OrganizationConfigurationFeatureAdditionalConfigurationArray{
 * 				&guardduty.OrganizationConfigurationFeatureAdditionalConfigurationArgs{
 * 					Name:       pulumi.String("EKS_ADDON_MANAGEMENT"),
 * 					AutoEnable: pulumi.String("NEW"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.guardduty.Detector;
 * import com.pulumi.aws.guardduty.DetectorArgs;
 * import com.pulumi.aws.guardduty.OrganizationConfigurationFeature;
 * import com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs;
 * import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationFeatureAdditionalConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Detector("example", DetectorArgs.builder()
 *             .enable(true)
 *             .build());
 *         var eksRuntimeMonitoring = new OrganizationConfigurationFeature("eksRuntimeMonitoring", OrganizationConfigurationFeatureArgs.builder()
 *             .detectorId(example.id())
 *             .name("EKS_RUNTIME_MONITORING")
 *             .autoEnable("ALL")
 *             .additionalConfigurations(OrganizationConfigurationFeatureAdditionalConfigurationArgs.builder()
 *                 .name("EKS_ADDON_MANAGEMENT")
 *                 .autoEnable("NEW")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:guardduty:Detector
 *     properties:
 *       enable: true
 *   eksRuntimeMonitoring:
 *     type: aws:guardduty:OrganizationConfigurationFeature
 *     name: eks_runtime_monitoring
 *     properties:
 *       detectorId: ${example.id}
 *       name: EKS_RUNTIME_MONITORING
 *       autoEnable: ALL
 *       additionalConfigurations:
 *         - name: EKS_ADDON_MANAGEMENT
 *           autoEnable: NEW
 * ```
 * <!--End PulumiCodeChooser -->
 * @property additionalConfigurations Additional feature configuration block for features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
 * @property autoEnable The status of the feature that is configured for the member accounts within the organization. Valid values: `NEW`, `ALL`, `NONE`.
 * @property detectorId The ID of the detector that configures the delegated administrator.
 * @property name The name of the feature that will be configured for the organization. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`, `RUNTIME_MONITORING`. Only one of two features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING` can be added, adding both features will cause an error. Refer to the [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html) for the current list of supported values.
 */
public data class OrganizationConfigurationFeatureArgs(
    public val additionalConfigurations: Output<List<OrganizationConfigurationFeatureAdditionalConfigurationArgs>>? = null,
    public val autoEnable: Output<String>? = null,
    public val detectorId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs =
        com.pulumi.aws.guardduty.OrganizationConfigurationFeatureArgs.builder()
            .additionalConfigurations(
                additionalConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .autoEnable(autoEnable?.applyValue({ args0 -> args0 }))
            .detectorId(detectorId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationFeatureArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationFeatureArgsBuilder internal constructor() {
    private var additionalConfigurations:
        Output<List<OrganizationConfigurationFeatureAdditionalConfigurationArgs>>? = null

    private var autoEnable: Output<String>? = null

    private var detectorId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Additional feature configuration block for features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("pouyxdnriiuumarp")
    public suspend fun additionalConfigurations(`value`: Output<List<OrganizationConfigurationFeatureAdditionalConfigurationArgs>>) {
        this.additionalConfigurations = value
    }

    @JvmName("pdctuhsqwxlfddjt")
    public suspend fun additionalConfigurations(vararg values: Output<OrganizationConfigurationFeatureAdditionalConfigurationArgs>) {
        this.additionalConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Additional feature configuration block for features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("kpotdqcbaoisxcjb")
    public suspend fun additionalConfigurations(values: List<Output<OrganizationConfigurationFeatureAdditionalConfigurationArgs>>) {
        this.additionalConfigurations = Output.all(values)
    }

    /**
     * @param value The status of the feature that is configured for the member accounts within the organization. Valid values: `NEW`, `ALL`, `NONE`.
     */
    @JvmName("bvivxaouubvycnkf")
    public suspend fun autoEnable(`value`: Output<String>) {
        this.autoEnable = value
    }

    /**
     * @param value The ID of the detector that configures the delegated administrator.
     */
    @JvmName("yiarpankyxahfjfj")
    public suspend fun detectorId(`value`: Output<String>) {
        this.detectorId = value
    }

    /**
     * @param value The name of the feature that will be configured for the organization. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`, `RUNTIME_MONITORING`. Only one of two features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING` can be added, adding both features will cause an error. Refer to the [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html) for the current list of supported values.
     */
    @JvmName("motoshrxavcvxhyr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Additional feature configuration block for features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("kiajvuwadmvklqcj")
    public suspend fun additionalConfigurations(`value`: List<OrganizationConfigurationFeatureAdditionalConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument Additional feature configuration block for features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("navwfdcrlijktoew")
    public suspend fun additionalConfigurations(argument: List<suspend OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument Additional feature configuration block for features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("xkuqcxwtxqnxahsp")
    public suspend fun additionalConfigurations(vararg argument: suspend OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param argument Additional feature configuration block for features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("ffwrgxkeaynyceto")
    public suspend fun additionalConfigurations(argument: suspend OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                OrganizationConfigurationFeatureAdditionalConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.additionalConfigurations = mapped
    }

    /**
     * @param values Additional feature configuration block for features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING`. See below.
     */
    @JvmName("vvmncoaerbgrxumu")
    public suspend fun additionalConfigurations(vararg values: OrganizationConfigurationFeatureAdditionalConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalConfigurations = mapped
    }

    /**
     * @param value The status of the feature that is configured for the member accounts within the organization. Valid values: `NEW`, `ALL`, `NONE`.
     */
    @JvmName("bllowhfhhunsovky")
    public suspend fun autoEnable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnable = mapped
    }

    /**
     * @param value The ID of the detector that configures the delegated administrator.
     */
    @JvmName("xjcvyqlmtjotagya")
    public suspend fun detectorId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectorId = mapped
    }

    /**
     * @param value The name of the feature that will be configured for the organization. Valid values: `S3_DATA_EVENTS`, `EKS_AUDIT_LOGS`, `EBS_MALWARE_PROTECTION`, `RDS_LOGIN_EVENTS`, `EKS_RUNTIME_MONITORING`, `LAMBDA_NETWORK_LOGS`, `RUNTIME_MONITORING`. Only one of two features `EKS_RUNTIME_MONITORING` or `RUNTIME_MONITORING` can be added, adding both features will cause an error. Refer to the [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html) for the current list of supported values.
     */
    @JvmName("tiwuvdqgwynkltab")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): OrganizationConfigurationFeatureArgs = OrganizationConfigurationFeatureArgs(
        additionalConfigurations = additionalConfigurations,
        autoEnable = autoEnable,
        detectorId = detectorId,
        name = name,
    )
}
