@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property kubernetes Configures [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
 * See Kubernetes and Kubernetes Audit Logs below for more details.
 * @property malwareProtection Configures [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html).
 * See Malware Protection, Scan EC2 instance with findings and EBS volumes below for more details.
 * @property s3Logs Configures [S3 protection](https://docs.aws.amazon.com/guardduty/latest/ug/s3-protection.html).
 * See S3 Logs below for more details.
 */
public data class DetectorDatasourcesArgs(
    public val kubernetes: Output<DetectorDatasourcesKubernetesArgs>? = null,
    public val malwareProtection: Output<DetectorDatasourcesMalwareProtectionArgs>? = null,
    public val s3Logs: Output<DetectorDatasourcesS3LogsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.DetectorDatasourcesArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.DetectorDatasourcesArgs =
        com.pulumi.aws.guardduty.inputs.DetectorDatasourcesArgs.builder()
            .kubernetes(kubernetes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .malwareProtection(malwareProtection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3Logs(s3Logs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DetectorDatasourcesArgs].
 */
@PulumiTagMarker
public class DetectorDatasourcesArgsBuilder internal constructor() {
    private var kubernetes: Output<DetectorDatasourcesKubernetesArgs>? = null

    private var malwareProtection: Output<DetectorDatasourcesMalwareProtectionArgs>? = null

    private var s3Logs: Output<DetectorDatasourcesS3LogsArgs>? = null

    /**
     * @param value Configures [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * See Kubernetes and Kubernetes Audit Logs below for more details.
     */
    @JvmName("slyxmwaoxehyeiqv")
    public suspend fun kubernetes(`value`: Output<DetectorDatasourcesKubernetesArgs>) {
        this.kubernetes = value
    }

    /**
     * @param value Configures [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html).
     * See Malware Protection, Scan EC2 instance with findings and EBS volumes below for more details.
     */
    @JvmName("spuuvyuvmewpclys")
    public suspend fun malwareProtection(`value`: Output<DetectorDatasourcesMalwareProtectionArgs>) {
        this.malwareProtection = value
    }

    /**
     * @param value Configures [S3 protection](https://docs.aws.amazon.com/guardduty/latest/ug/s3-protection.html).
     * See S3 Logs below for more details.
     */
    @JvmName("poggsistmfwickok")
    public suspend fun s3Logs(`value`: Output<DetectorDatasourcesS3LogsArgs>) {
        this.s3Logs = value
    }

    /**
     * @param value Configures [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * See Kubernetes and Kubernetes Audit Logs below for more details.
     */
    @JvmName("nqwaymuaecgalksw")
    public suspend fun kubernetes(`value`: DetectorDatasourcesKubernetesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetes = mapped
    }

    /**
     * @param argument Configures [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * See Kubernetes and Kubernetes Audit Logs below for more details.
     */
    @JvmName("uvvnskjgsyxybvno")
    public suspend fun kubernetes(argument: suspend DetectorDatasourcesKubernetesArgsBuilder.() -> Unit) {
        val toBeMapped = DetectorDatasourcesKubernetesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kubernetes = mapped
    }

    /**
     * @param value Configures [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html).
     * See Malware Protection, Scan EC2 instance with findings and EBS volumes below for more details.
     */
    @JvmName("jaixhgwomemsjnai")
    public suspend fun malwareProtection(`value`: DetectorDatasourcesMalwareProtectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.malwareProtection = mapped
    }

    /**
     * @param argument Configures [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html).
     * See Malware Protection, Scan EC2 instance with findings and EBS volumes below for more details.
     */
    @JvmName("wkodqdxrsgfdqxey")
    public suspend fun malwareProtection(argument: suspend DetectorDatasourcesMalwareProtectionArgsBuilder.() -> Unit) {
        val toBeMapped = DetectorDatasourcesMalwareProtectionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.malwareProtection = mapped
    }

    /**
     * @param value Configures [S3 protection](https://docs.aws.amazon.com/guardduty/latest/ug/s3-protection.html).
     * See S3 Logs below for more details.
     */
    @JvmName("ljcvckimxfltiiav")
    public suspend fun s3Logs(`value`: DetectorDatasourcesS3LogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Logs = mapped
    }

    /**
     * @param argument Configures [S3 protection](https://docs.aws.amazon.com/guardduty/latest/ug/s3-protection.html).
     * See S3 Logs below for more details.
     */
    @JvmName("rtehrcuhyptvkrdc")
    public suspend fun s3Logs(argument: suspend DetectorDatasourcesS3LogsArgsBuilder.() -> Unit) {
        val toBeMapped = DetectorDatasourcesS3LogsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Logs = mapped
    }

    internal fun build(): DetectorDatasourcesArgs = DetectorDatasourcesArgs(
        kubernetes = kubernetes,
        malwareProtection = malwareProtection,
        s3Logs = s3Logs,
    )
}
