@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.DetectorDatasourcesKubernetesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property auditLogs Configures Kubernetes audit logs as a data source for [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
 * See Kubernetes Audit Logs below for more details.
 */
public data class DetectorDatasourcesKubernetesArgs(
    public val auditLogs: Output<DetectorDatasourcesKubernetesAuditLogsArgs>,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.DetectorDatasourcesKubernetesArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.DetectorDatasourcesKubernetesArgs =
        com.pulumi.aws.guardduty.inputs.DetectorDatasourcesKubernetesArgs.builder()
            .auditLogs(auditLogs.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DetectorDatasourcesKubernetesArgs].
 */
@PulumiTagMarker
public class DetectorDatasourcesKubernetesArgsBuilder internal constructor() {
    private var auditLogs: Output<DetectorDatasourcesKubernetesAuditLogsArgs>? = null

    /**
     * @param value Configures Kubernetes audit logs as a data source for [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * See Kubernetes Audit Logs below for more details.
     */
    @JvmName("okttjesnittjojdl")
    public suspend fun auditLogs(`value`: Output<DetectorDatasourcesKubernetesAuditLogsArgs>) {
        this.auditLogs = value
    }

    /**
     * @param value Configures Kubernetes audit logs as a data source for [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * See Kubernetes Audit Logs below for more details.
     */
    @JvmName("nokugqusdehqqtki")
    public suspend fun auditLogs(`value`: DetectorDatasourcesKubernetesAuditLogsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auditLogs = mapped
    }

    /**
     * @param argument Configures Kubernetes audit logs as a data source for [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * See Kubernetes Audit Logs below for more details.
     */
    @JvmName("ltvqxymttfomfsfu")
    public suspend fun auditLogs(argument: suspend DetectorDatasourcesKubernetesAuditLogsArgsBuilder.() -> Unit) {
        val toBeMapped = DetectorDatasourcesKubernetesAuditLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.auditLogs = mapped
    }

    internal fun build(): DetectorDatasourcesKubernetesArgs = DetectorDatasourcesKubernetesArgs(
        auditLogs = auditLogs ?: throw PulumiNullFieldException("auditLogs"),
    )
}
