@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaCriterionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property equals List of string values to be evaluated.
 * @property field The name of the field to be evaluated. The full list of field names can be found in [AWS documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria).
 * @property greaterThan A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property greaterThanOrEqual A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property lessThan A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property lessThanOrEqual A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property notEquals List of string values to be evaluated.
 */
public data class FilterFindingCriteriaCriterionArgs(
    public val equals: Output<List<String>>? = null,
    public val `field`: Output<String>,
    public val greaterThan: Output<String>? = null,
    public val greaterThanOrEqual: Output<String>? = null,
    public val lessThan: Output<String>? = null,
    public val lessThanOrEqual: Output<String>? = null,
    public val notEquals: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaCriterionArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaCriterionArgs =
        com.pulumi.aws.guardduty.inputs.FilterFindingCriteriaCriterionArgs.builder()
            .equals_(equals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`field`(`field`.applyValue({ args0 -> args0 }))
            .greaterThan(greaterThan?.applyValue({ args0 -> args0 }))
            .greaterThanOrEqual(greaterThanOrEqual?.applyValue({ args0 -> args0 }))
            .lessThan(lessThan?.applyValue({ args0 -> args0 }))
            .lessThanOrEqual(lessThanOrEqual?.applyValue({ args0 -> args0 }))
            .notEquals(notEquals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FilterFindingCriteriaCriterionArgs].
 */
@PulumiTagMarker
public class FilterFindingCriteriaCriterionArgsBuilder internal constructor() {
    private var equals: Output<List<String>>? = null

    private var `field`: Output<String>? = null

    private var greaterThan: Output<String>? = null

    private var greaterThanOrEqual: Output<String>? = null

    private var lessThan: Output<String>? = null

    private var lessThanOrEqual: Output<String>? = null

    private var notEquals: Output<List<String>>? = null

    /**
     * @param value List of string values to be evaluated.
     */
    @JvmName("chfqjxpqsgaclose")
    public suspend fun equals(`value`: Output<List<String>>) {
        this.equals = value
    }

    @JvmName("xffqaxeysdvvcmvm")
    public suspend fun equals(vararg values: Output<String>) {
        this.equals = Output.all(values.asList())
    }

    /**
     * @param values List of string values to be evaluated.
     */
    @JvmName("nihvtbbwdifcpksi")
    public suspend fun equals(values: List<Output<String>>) {
        this.equals = Output.all(values)
    }

    /**
     * @param value The name of the field to be evaluated. The full list of field names can be found in [AWS documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria).
     */
    @JvmName("xwpiasmwlyloaugk")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("huopemmfqscklrwq")
    public suspend fun greaterThan(`value`: Output<String>) {
        this.greaterThan = value
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("rjxywoqxbldqmrsb")
    public suspend fun greaterThanOrEqual(`value`: Output<String>) {
        this.greaterThanOrEqual = value
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("wrtptxnolwbcenoh")
    public suspend fun lessThan(`value`: Output<String>) {
        this.lessThan = value
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("eugbnwwsigsojlsl")
    public suspend fun lessThanOrEqual(`value`: Output<String>) {
        this.lessThanOrEqual = value
    }

    /**
     * @param value List of string values to be evaluated.
     */
    @JvmName("cgqbvesrqxncdvli")
    public suspend fun notEquals(`value`: Output<List<String>>) {
        this.notEquals = value
    }

    @JvmName("iqtuatjccxybgavu")
    public suspend fun notEquals(vararg values: Output<String>) {
        this.notEquals = Output.all(values.asList())
    }

    /**
     * @param values List of string values to be evaluated.
     */
    @JvmName("ldytytatledhsidi")
    public suspend fun notEquals(values: List<Output<String>>) {
        this.notEquals = Output.all(values)
    }

    /**
     * @param value List of string values to be evaluated.
     */
    @JvmName("kmcrksekaufpvipi")
    public suspend fun equals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.equals = mapped
    }

    /**
     * @param values List of string values to be evaluated.
     */
    @JvmName("wpeecclmlqawnyyu")
    public suspend fun equals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.equals = mapped
    }

    /**
     * @param value The name of the field to be evaluated. The full list of field names can be found in [AWS documentation](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria).
     */
    @JvmName("sbguiapqhubdjrem")
    public suspend fun `field`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("ymluxpqbtdpyjtru")
    public suspend fun greaterThan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.greaterThan = mapped
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("sviixfjhuecpuwld")
    public suspend fun greaterThanOrEqual(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.greaterThanOrEqual = mapped
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("guciqcpbtdiurqex")
    public suspend fun lessThan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lessThan = mapped
    }

    /**
     * @param value A value to be evaluated. Accepts either an integer or a date in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("bmhohgpkeortqkhk")
    public suspend fun lessThanOrEqual(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lessThanOrEqual = mapped
    }

    /**
     * @param value List of string values to be evaluated.
     */
    @JvmName("tuuokxtmskkhaaxs")
    public suspend fun notEquals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notEquals = mapped
    }

    /**
     * @param values List of string values to be evaluated.
     */
    @JvmName("qwbgjsfybupucjkg")
    public suspend fun notEquals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notEquals = mapped
    }

    internal fun build(): FilterFindingCriteriaCriterionArgs = FilterFindingCriteriaCriterionArgs(
        equals = equals,
        `field` = `field` ?: throw PulumiNullFieldException("field"),
        greaterThan = greaterThan,
        greaterThanOrEqual = greaterThanOrEqual,
        lessThan = lessThan,
        lessThanOrEqual = lessThanOrEqual,
        notEquals = notEquals,
    )
}
