@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property taggings Indicates whether the scanned S3 object will have tags about the scan result. See `tagging` below.
 */
public data class MalwareProtectionPlanActionArgs(
    public val taggings: Output<List<MalwareProtectionPlanActionTaggingArgs>>,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionArgs =
        com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionArgs.builder()
            .taggings(
                taggings.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MalwareProtectionPlanActionArgs].
 */
@PulumiTagMarker
public class MalwareProtectionPlanActionArgsBuilder internal constructor() {
    private var taggings: Output<List<MalwareProtectionPlanActionTaggingArgs>>? = null

    /**
     * @param value Indicates whether the scanned S3 object will have tags about the scan result. See `tagging` below.
     */
    @JvmName("ainqhadblsvxlbdl")
    public suspend fun taggings(`value`: Output<List<MalwareProtectionPlanActionTaggingArgs>>) {
        this.taggings = value
    }

    @JvmName("prdedayjxfkifnbp")
    public suspend fun taggings(vararg values: Output<MalwareProtectionPlanActionTaggingArgs>) {
        this.taggings = Output.all(values.asList())
    }

    /**
     * @param values Indicates whether the scanned S3 object will have tags about the scan result. See `tagging` below.
     */
    @JvmName("uwogdnpndsxmsprn")
    public suspend fun taggings(values: List<Output<MalwareProtectionPlanActionTaggingArgs>>) {
        this.taggings = Output.all(values)
    }

    /**
     * @param value Indicates whether the scanned S3 object will have tags about the scan result. See `tagging` below.
     */
    @JvmName("navnvybnyjffpgru")
    public suspend fun taggings(`value`: List<MalwareProtectionPlanActionTaggingArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taggings = mapped
    }

    /**
     * @param argument Indicates whether the scanned S3 object will have tags about the scan result. See `tagging` below.
     */
    @JvmName("yyuudlrfasxstiig")
    public suspend fun taggings(argument: List<suspend MalwareProtectionPlanActionTaggingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MalwareProtectionPlanActionTaggingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.taggings = mapped
    }

    /**
     * @param argument Indicates whether the scanned S3 object will have tags about the scan result. See `tagging` below.
     */
    @JvmName("rxmlcqhjdcculnot")
    public suspend fun taggings(vararg argument: suspend MalwareProtectionPlanActionTaggingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MalwareProtectionPlanActionTaggingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.taggings = mapped
    }

    /**
     * @param argument Indicates whether the scanned S3 object will have tags about the scan result. See `tagging` below.
     */
    @JvmName("psiokcraopmmknei")
    public suspend fun taggings(argument: suspend MalwareProtectionPlanActionTaggingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MalwareProtectionPlanActionTaggingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.taggings = mapped
    }

    /**
     * @param values Indicates whether the scanned S3 object will have tags about the scan result. See `tagging` below.
     */
    @JvmName("djodumthtyddomqo")
    public suspend fun taggings(vararg values: MalwareProtectionPlanActionTaggingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taggings = mapped
    }

    internal fun build(): MalwareProtectionPlanActionArgs = MalwareProtectionPlanActionArgs(
        taggings = taggings ?: throw PulumiNullFieldException("taggings"),
    )
}
