@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionTaggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Indicates whether or not the tags will added. Valid values are `DISABLED` and `ENABLED`. Defaults to `DISABLED`
 */
public data class MalwareProtectionPlanActionTaggingArgs(
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionTaggingArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionTaggingArgs =
        com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanActionTaggingArgs.builder()
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MalwareProtectionPlanActionTaggingArgs].
 */
@PulumiTagMarker
public class MalwareProtectionPlanActionTaggingArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Indicates whether or not the tags will added. Valid values are `DISABLED` and `ENABLED`. Defaults to `DISABLED`
     */
    @JvmName("vsiregmarvawobxf")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Indicates whether or not the tags will added. Valid values are `DISABLED` and `ENABLED`. Defaults to `DISABLED`
     */
    @JvmName("xyjucmewvaxlsduj")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): MalwareProtectionPlanActionTaggingArgs =
        MalwareProtectionPlanActionTaggingArgs(
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
