@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Bucket Information about the protected S3 bucket resource. See `s3_bucket` below.
 */
public data class MalwareProtectionPlanProtectedResourceArgs(
    public val s3Bucket: Output<MalwareProtectionPlanProtectedResourceS3BucketArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceArgs = com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceArgs.builder()
        .s3Bucket(s3Bucket?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MalwareProtectionPlanProtectedResourceArgs].
 */
@PulumiTagMarker
public class MalwareProtectionPlanProtectedResourceArgsBuilder internal constructor() {
    private var s3Bucket: Output<MalwareProtectionPlanProtectedResourceS3BucketArgs>? = null

    /**
     * @param value Information about the protected S3 bucket resource. See `s3_bucket` below.
     */
    @JvmName("kieqbryhbptiqepg")
    public suspend fun s3Bucket(`value`: Output<MalwareProtectionPlanProtectedResourceS3BucketArgs>) {
        this.s3Bucket = value
    }

    /**
     * @param value Information about the protected S3 bucket resource. See `s3_bucket` below.
     */
    @JvmName("jacxucjejidkdceb")
    public suspend fun s3Bucket(`value`: MalwareProtectionPlanProtectedResourceS3BucketArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param argument Information about the protected S3 bucket resource. See `s3_bucket` below.
     */
    @JvmName("kdrlngpajnnufvea")
    public suspend fun s3Bucket(argument: suspend MalwareProtectionPlanProtectedResourceS3BucketArgsBuilder.() -> Unit) {
        val toBeMapped = MalwareProtectionPlanProtectedResourceS3BucketArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Bucket = mapped
    }

    internal fun build(): MalwareProtectionPlanProtectedResourceArgs =
        MalwareProtectionPlanProtectedResourceArgs(
            s3Bucket = s3Bucket,
        )
}
