@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceS3BucketArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Name of the S3 bucket.
 * @property objectPrefixes The list of object prefixes that specify the S3 objects that will be scanned.
 */
public data class MalwareProtectionPlanProtectedResourceS3BucketArgs(
    public val bucketName: Output<String>,
    public val objectPrefixes: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceS3BucketArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceS3BucketArgs =
        com.pulumi.aws.guardduty.inputs.MalwareProtectionPlanProtectedResourceS3BucketArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .objectPrefixes(objectPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [MalwareProtectionPlanProtectedResourceS3BucketArgs].
 */
@PulumiTagMarker
public class MalwareProtectionPlanProtectedResourceS3BucketArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var objectPrefixes: Output<List<String>>? = null

    /**
     * @param value Name of the S3 bucket.
     */
    @JvmName("yqhkcnabtamtdjqv")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The list of object prefixes that specify the S3 objects that will be scanned.
     */
    @JvmName("elihkyrwqsrwsygq")
    public suspend fun objectPrefixes(`value`: Output<List<String>>) {
        this.objectPrefixes = value
    }

    @JvmName("rtpjfbugcjhxjvaj")
    public suspend fun objectPrefixes(vararg values: Output<String>) {
        this.objectPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The list of object prefixes that specify the S3 objects that will be scanned.
     */
    @JvmName("idtydmikdsdnfynx")
    public suspend fun objectPrefixes(values: List<Output<String>>) {
        this.objectPrefixes = Output.all(values)
    }

    /**
     * @param value Name of the S3 bucket.
     */
    @JvmName("ijnkvlaldldtdume")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The list of object prefixes that specify the S3 objects that will be scanned.
     */
    @JvmName("qkhcqlhkoikbthta")
    public suspend fun objectPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectPrefixes = mapped
    }

    /**
     * @param values The list of object prefixes that specify the S3 objects that will be scanned.
     */
    @JvmName("gnafcgfhtgxltpue")
    public suspend fun objectPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectPrefixes = mapped
    }

    internal fun build(): MalwareProtectionPlanProtectedResourceS3BucketArgs =
        MalwareProtectionPlanProtectedResourceS3BucketArgs(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            objectPrefixes = objectPrefixes,
        )
}
