@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property kubernetes Enable Kubernetes Audit Logs Monitoring automatically for new member accounts.
 * @property malwareProtection Enable Malware Protection automatically for new member accounts.
 * @property s3Logs Enable S3 Protection automatically for new member accounts.
 */
public data class OrganizationConfigurationDatasourcesArgs(
    public val kubernetes: Output<OrganizationConfigurationDatasourcesKubernetesArgs>? = null,
    public val malwareProtection: Output<OrganizationConfigurationDatasourcesMalwareProtectionArgs>? =
        null,
    public val s3Logs: Output<OrganizationConfigurationDatasourcesS3LogsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesArgs =
        com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesArgs.builder()
            .kubernetes(kubernetes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .malwareProtection(malwareProtection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3Logs(s3Logs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OrganizationConfigurationDatasourcesArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationDatasourcesArgsBuilder internal constructor() {
    private var kubernetes: Output<OrganizationConfigurationDatasourcesKubernetesArgs>? = null

    private var malwareProtection: Output<OrganizationConfigurationDatasourcesMalwareProtectionArgs>? =
        null

    private var s3Logs: Output<OrganizationConfigurationDatasourcesS3LogsArgs>? = null

    /**
     * @param value Enable Kubernetes Audit Logs Monitoring automatically for new member accounts.
     */
    @JvmName("osiahncttbmdthpy")
    public suspend fun kubernetes(`value`: Output<OrganizationConfigurationDatasourcesKubernetesArgs>) {
        this.kubernetes = value
    }

    /**
     * @param value Enable Malware Protection automatically for new member accounts.
     */
    @JvmName("dtxrcghkprwdvick")
    public suspend fun malwareProtection(`value`: Output<OrganizationConfigurationDatasourcesMalwareProtectionArgs>) {
        this.malwareProtection = value
    }

    /**
     * @param value Enable S3 Protection automatically for new member accounts.
     */
    @JvmName("afnykdtcbecwneix")
    public suspend fun s3Logs(`value`: Output<OrganizationConfigurationDatasourcesS3LogsArgs>) {
        this.s3Logs = value
    }

    /**
     * @param value Enable Kubernetes Audit Logs Monitoring automatically for new member accounts.
     */
    @JvmName("yemclerxtvobcxvh")
    public suspend fun kubernetes(`value`: OrganizationConfigurationDatasourcesKubernetesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetes = mapped
    }

    /**
     * @param argument Enable Kubernetes Audit Logs Monitoring automatically for new member accounts.
     */
    @JvmName("hcemtltwnmmhmoqa")
    public suspend fun kubernetes(argument: suspend OrganizationConfigurationDatasourcesKubernetesArgsBuilder.() -> Unit) {
        val toBeMapped = OrganizationConfigurationDatasourcesKubernetesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kubernetes = mapped
    }

    /**
     * @param value Enable Malware Protection automatically for new member accounts.
     */
    @JvmName("tosusdlatubkiriy")
    public suspend fun malwareProtection(`value`: OrganizationConfigurationDatasourcesMalwareProtectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.malwareProtection = mapped
    }

    /**
     * @param argument Enable Malware Protection automatically for new member accounts.
     */
    @JvmName("pfypihrnqyrqksii")
    public suspend fun malwareProtection(argument: suspend OrganizationConfigurationDatasourcesMalwareProtectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            OrganizationConfigurationDatasourcesMalwareProtectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.malwareProtection = mapped
    }

    /**
     * @param value Enable S3 Protection automatically for new member accounts.
     */
    @JvmName("olgrfcytvtxfiipt")
    public suspend fun s3Logs(`value`: OrganizationConfigurationDatasourcesS3LogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Logs = mapped
    }

    /**
     * @param argument Enable S3 Protection automatically for new member accounts.
     */
    @JvmName("gcvkgivuyikrxgjy")
    public suspend fun s3Logs(argument: suspend OrganizationConfigurationDatasourcesS3LogsArgsBuilder.() -> Unit) {
        val toBeMapped = OrganizationConfigurationDatasourcesS3LogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Logs = mapped
    }

    internal fun build(): OrganizationConfigurationDatasourcesArgs =
        OrganizationConfigurationDatasourcesArgs(
            kubernetes = kubernetes,
            malwareProtection = malwareProtection,
            s3Logs = s3Logs,
        )
}
