@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enable If true, enables Kubernetes audit logs as a data source for [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
 * Defaults to `true`.
 */
public data class OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs(
    public val enable: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs =
        com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs.builder()
            .enable(enable.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationDatasourcesKubernetesAuditLogsArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    /**
     * @param value If true, enables Kubernetes audit logs as a data source for [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * Defaults to `true`.
     */
    @JvmName("iqylvxscleskhceo")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value If true, enables Kubernetes audit logs as a data source for [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
     * Defaults to `true`.
     */
    @JvmName("lthyxnlmksafdovj")
    public suspend fun enable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    internal fun build(): OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs =
        OrganizationConfigurationDatasourcesKubernetesAuditLogsArgs(
            enable = enable ?: throw PulumiNullFieldException("enable"),
        )
}
