@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property scanEc2InstanceWithFindings Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) for EC2 instances with findings should be auto-enabled for new members joining the organization.
 * See Scan EC2 instance with findings below for more details.
 */
public data class OrganizationConfigurationDatasourcesMalwareProtectionArgs(
    public val scanEc2InstanceWithFindings: Output<OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionArgs =
        com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionArgs.builder()
            .scanEc2InstanceWithFindings(
                scanEc2InstanceWithFindings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [OrganizationConfigurationDatasourcesMalwareProtectionArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationDatasourcesMalwareProtectionArgsBuilder internal constructor() {
    private var scanEc2InstanceWithFindings:
        Output<OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs>? =
        null

    /**
     * @param value Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) for EC2 instances with findings should be auto-enabled for new members joining the organization.
     * See Scan EC2 instance with findings below for more details.
     */
    @JvmName("jlfqbjurlipntbws")
    public suspend fun scanEc2InstanceWithFindings(`value`: Output<OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs>) {
        this.scanEc2InstanceWithFindings = value
    }

    /**
     * @param value Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) for EC2 instances with findings should be auto-enabled for new members joining the organization.
     * See Scan EC2 instance with findings below for more details.
     */
    @JvmName("ijmqxpfkqrxlvtnl")
    public suspend fun scanEc2InstanceWithFindings(`value`: OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanEc2InstanceWithFindings = mapped
    }

    /**
     * @param argument Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) for EC2 instances with findings should be auto-enabled for new members joining the organization.
     * See Scan EC2 instance with findings below for more details.
     */
    @JvmName("tewqtmrqmuiuawra")
    public suspend fun scanEc2InstanceWithFindings(argument: suspend OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scanEc2InstanceWithFindings = mapped
    }

    internal fun build(): OrganizationConfigurationDatasourcesMalwareProtectionArgs =
        OrganizationConfigurationDatasourcesMalwareProtectionArgs(
            scanEc2InstanceWithFindings = scanEc2InstanceWithFindings ?: throw
                PulumiNullFieldException("scanEc2InstanceWithFindings"),
        )
}
