@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ebsVolumes Configure whether scanning EBS volumes should be auto-enabled for new members joining the organization
 * See EBS volumes below for more details.
 */
public data class
OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs(
    public val ebsVolumes: Output<OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs =
        com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs.builder()
            .ebsVolumes(ebsVolumes.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs].
 */
@PulumiTagMarker
public class
OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgsBuilder
internal constructor() {
    private var ebsVolumes:
        Output<OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs>? =
        null

    /**
     * @param value Configure whether scanning EBS volumes should be auto-enabled for new members joining the organization
     * See EBS volumes below for more details.
     */
    @JvmName("rlbovxmgckvvmqwo")
    public suspend fun ebsVolumes(`value`: Output<OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs>) {
        this.ebsVolumes = value
    }

    /**
     * @param value Configure whether scanning EBS volumes should be auto-enabled for new members joining the organization
     * See EBS volumes below for more details.
     */
    @JvmName("yjpevguqmurcrbgv")
    public suspend fun ebsVolumes(`value`: OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsVolumes = mapped
    }

    /**
     * @param argument Configure whether scanning EBS volumes should be auto-enabled for new members joining the organization
     * See EBS volumes below for more details.
     */
    @JvmName("esvouonhmnpqgnbv")
    public suspend fun ebsVolumes(argument: suspend OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgsBuilder.() -> Unit) {
        val toBeMapped =
            OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ebsVolumes = mapped
    }

    internal fun build(): OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs =
        OrganizationConfigurationDatasourcesMalwareProtectionScanEc2InstanceWithFindingsArgs(
            ebsVolumes = ebsVolumes ?: throw PulumiNullFieldException("ebsVolumes"),
        )
}
