@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.inputs

import com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesS3LogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoEnable Set to `true` if you want S3 data event logs to be automatically enabled for new members of the organization. Default: `false`
 */
public data class OrganizationConfigurationDatasourcesS3LogsArgs(
    public val autoEnable: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesS3LogsArgs> {
    override fun toJava(): com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesS3LogsArgs =
        com.pulumi.aws.guardduty.inputs.OrganizationConfigurationDatasourcesS3LogsArgs.builder()
            .autoEnable(autoEnable.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationDatasourcesS3LogsArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationDatasourcesS3LogsArgsBuilder internal constructor() {
    private var autoEnable: Output<Boolean>? = null

    /**
     * @param value Set to `true` if you want S3 data event logs to be automatically enabled for new members of the organization. Default: `false`
     */
    @JvmName("edoteftclmmjttmg")
    public suspend fun autoEnable(`value`: Output<Boolean>) {
        this.autoEnable = value
    }

    /**
     * @param value Set to `true` if you want S3 data event logs to be automatically enabled for new members of the organization. Default: `false`
     */
    @JvmName("rrqphaignahpkmxh")
    public suspend fun autoEnable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoEnable = mapped
    }

    internal fun build(): OrganizationConfigurationDatasourcesS3LogsArgs =
        OrganizationConfigurationDatasourcesS3LogsArgs(
            autoEnable = autoEnable ?: throw PulumiNullFieldException("autoEnable"),
        )
}
