@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property auditLogs Configures Kubernetes audit logs as a data source for [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
 * See Kubernetes Audit Logs below for more details.
 */
public data class DetectorDatasourcesKubernetes(
    public val auditLogs: DetectorDatasourcesKubernetesAuditLogs,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.DetectorDatasourcesKubernetes): DetectorDatasourcesKubernetes = DetectorDatasourcesKubernetes(
            auditLogs = javaType.auditLogs().let({ args0 ->
                com.pulumi.aws.guardduty.kotlin.outputs.DetectorDatasourcesKubernetesAuditLogs.Companion.toKotlin(args0)
            }),
        )
    }
}
