@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enable If true, enables Kubernetes audit logs as a data source for [Kubernetes protection](https://docs.aws.amazon.com/guardduty/latest/ug/kubernetes-protection.html).
 * Defaults to `true`.
 */
public data class DetectorDatasourcesKubernetesAuditLogs(
    public val enable: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.DetectorDatasourcesKubernetesAuditLogs): DetectorDatasourcesKubernetesAuditLogs = DetectorDatasourcesKubernetesAuditLogs(
            enable = javaType.enable(),
        )
    }
}
