@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property scanEc2InstanceWithFindings Configure whether [Malware Protection](https://docs.aws.amazon.com/guardduty/latest/ug/malware-protection.html) is enabled as data source for EC2 instances with findings for the detector.
 * See Scan EC2 instance with findings below for more details.
 */
public data class DetectorDatasourcesMalwareProtection(
    public val scanEc2InstanceWithFindings: DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindings,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.DetectorDatasourcesMalwareProtection): DetectorDatasourcesMalwareProtection = DetectorDatasourcesMalwareProtection(
            scanEc2InstanceWithFindings = javaType.scanEc2InstanceWithFindings().let({ args0 ->
                com.pulumi.aws.guardduty.kotlin.outputs.DetectorDatasourcesMalwareProtectionScanEc2InstanceWithFindings.Companion.toKotlin(args0)
            }),
        )
    }
}
