@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDetector.
 * @property features Current configuration of the detector features.
 * @property findingPublishingFrequency The frequency of notifications sent about subsequent finding occurrences.
 * @property id
 * @property serviceRoleArn Service-linked role that grants GuardDuty access to the resources in the AWS account.
 * @property status Current status of the detector.
 */
public data class GetDetectorResult(
    public val features: List<GetDetectorFeature>,
    public val findingPublishingFrequency: String,
    public val id: String,
    public val serviceRoleArn: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.GetDetectorResult): GetDetectorResult = GetDetectorResult(
            features = javaType.features().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.GetDetectorFeature.Companion.toKotlin(args0)
                })
            }),
            findingPublishingFrequency = javaType.findingPublishingFrequency(),
            id = javaType.id(),
            serviceRoleArn = javaType.serviceRoleArn(),
            status = javaType.status(),
        )
    }
}
