@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getFindingIds.
 * @property detectorId
 * @property findingIds A list of finding IDs for the specified detector.
 * @property hasFindings Indicates whether findings are present for the specified detector.
 * @property id
 */
public data class GetFindingIdsResult(
    public val detectorId: String,
    public val findingIds: List<String>,
    public val hasFindings: Boolean,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.GetFindingIdsResult): GetFindingIdsResult = GetFindingIdsResult(
            detectorId = javaType.detectorId(),
            findingIds = javaType.findingIds().map({ args0 -> args0 }),
            hasFindings = javaType.hasFindings(),
            id = javaType.id(),
        )
    }
}
