@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property taggings Indicates whether the scanned S3 object will have tags about the scan result. See `tagging` below.
 */
public data class MalwareProtectionPlanAction(
    public val taggings: List<MalwareProtectionPlanActionTagging>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.MalwareProtectionPlanAction): MalwareProtectionPlanAction = MalwareProtectionPlanAction(
            taggings = javaType.taggings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.MalwareProtectionPlanActionTagging.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
