@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bucketName Name of the S3 bucket.
 * @property objectPrefixes The list of object prefixes that specify the S3 objects that will be scanned.
 */
public data class MalwareProtectionPlanProtectedResourceS3Bucket(
    public val bucketName: String,
    public val objectPrefixes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.MalwareProtectionPlanProtectedResourceS3Bucket): MalwareProtectionPlanProtectedResourceS3Bucket =
            MalwareProtectionPlanProtectedResourceS3Bucket(
                bucketName = javaType.bucketName(),
                objectPrefixes = javaType.objectPrefixes().map({ args0 -> args0 }),
            )
    }
}
