@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property kubernetes Enable Kubernetes Audit Logs Monitoring automatically for new member accounts.
 * @property malwareProtection Enable Malware Protection automatically for new member accounts.
 * @property s3Logs Enable S3 Protection automatically for new member accounts.
 */
public data class OrganizationConfigurationDatasources(
    public val kubernetes: OrganizationConfigurationDatasourcesKubernetes? = null,
    public val malwareProtection: OrganizationConfigurationDatasourcesMalwareProtection? = null,
    public val s3Logs: OrganizationConfigurationDatasourcesS3Logs? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.OrganizationConfigurationDatasources): OrganizationConfigurationDatasources = OrganizationConfigurationDatasources(
            kubernetes = javaType.kubernetes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationDatasourcesKubernetes.Companion.toKotlin(args0)
                })
            }).orElse(null),
            malwareProtection = javaType.malwareProtection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationDatasourcesMalwareProtection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3Logs = javaType.s3Logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.guardduty.kotlin.outputs.OrganizationConfigurationDatasourcesS3Logs.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
