@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.guardduty.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoEnable The status of the additional configuration that will be configured for the organization. Valid values: `NEW`, `ALL`, `NONE`.
 * @property name The name of the additional configuration for a feature that will be configured for the organization. Valid values: `EKS_ADDON_MANAGEMENT`, `ECS_FARGATE_AGENT_MANAGEMENT`, `EC2_AGENT_MANAGEMENT`. Refer to the [AWS Documentation](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorAdditionalConfiguration.html) for the current list of supported values.
 */
public data class OrganizationConfigurationFeatureAdditionalConfiguration(
    public val autoEnable: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.guardduty.outputs.OrganizationConfigurationFeatureAdditionalConfiguration): OrganizationConfigurationFeatureAdditionalConfiguration =
            OrganizationConfigurationFeatureAdditionalConfiguration(
                autoEnable = javaType.autoEnable(),
                name = javaType.name(),
            )
    }
}
