@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.AccessKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM access key. This is a set of credentials that allow API requests to be made as an IAM user.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const lbUser = new aws.iam.User("lb", {
 *     name: "loadbalancer",
 *     path: "/system/",
 * });
 * const lb = new aws.iam.AccessKey("lb", {
 *     user: lbUser.name,
 *     pgpKey: "keybase:some_person_that_exists",
 * });
 * const lbRo = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["ec2:Describe*"],
 *         resources: ["*"],
 *     }],
 * });
 * const lbRoUserPolicy = new aws.iam.UserPolicy("lb_ro", {
 *     name: "test",
 *     user: lbUser.name,
 *     policy: lbRo.then(lbRo => lbRo.json),
 * });
 * export const secret = lb.encryptedSecret;
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * lb_user = aws.iam.User("lb",
 *     name="loadbalancer",
 *     path="/system/")
 * lb = aws.iam.AccessKey("lb",
 *     user=lb_user.name,
 *     pgp_key="keybase:some_person_that_exists")
 * lb_ro = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "actions": ["ec2:Describe*"],
 *     "resources": ["*"],
 * }])
 * lb_ro_user_policy = aws.iam.UserPolicy("lb_ro",
 *     name="test",
 *     user=lb_user.name,
 *     policy=lb_ro.json)
 * pulumi.export("secret", lb.encrypted_secret)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lbUser = new Aws.Iam.User("lb", new()
 *     {
 *         Name = "loadbalancer",
 *         Path = "/system/",
 *     });
 *     var lb = new Aws.Iam.AccessKey("lb", new()
 *     {
 *         User = lbUser.Name,
 *         PgpKey = "keybase:some_person_that_exists",
 *     });
 *     var lbRo = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:Describe*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var lbRoUserPolicy = new Aws.Iam.UserPolicy("lb_ro", new()
 *     {
 *         Name = "test",
 *         User = lbUser.Name,
 *         Policy = lbRo.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     return new Dictionary<string, object?>
 *     {
 *         ["secret"] = lb.EncryptedSecret,
 *     };
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		lbUser, err := iam.NewUser(ctx, "lb", &iam.UserArgs{
 * 			Name: pulumi.String("loadbalancer"),
 * 			Path: pulumi.String("/system/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lb, err := iam.NewAccessKey(ctx, "lb", &iam.AccessKeyArgs{
 * 			User:   lbUser.Name,
 * 			PgpKey: pulumi.String("keybase:some_person_that_exists"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lbRo, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"ec2:Describe*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewUserPolicy(ctx, "lb_ro", &iam.UserPolicyArgs{
 * 			Name:   pulumi.String("test"),
 * 			User:   lbUser.Name,
 * 			Policy: pulumi.String(lbRo.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ctx.Export("secret", lb.EncryptedSecret)
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.AccessKey;
 * import com.pulumi.aws.iam.AccessKeyArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.UserPolicy;
 * import com.pulumi.aws.iam.UserPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lbUser = new User("lbUser", UserArgs.builder()
 *             .name("loadbalancer")
 *             .path("/system/")
 *             .build());
 *         var lb = new AccessKey("lb", AccessKeyArgs.builder()
 *             .user(lbUser.name())
 *             .pgpKey("keybase:some_person_that_exists")
 *             .build());
 *         final var lbRo = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var lbRoUserPolicy = new UserPolicy("lbRoUserPolicy", UserPolicyArgs.builder()
 *             .name("test")
 *             .user(lbUser.name())
 *             .policy(lbRo.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         ctx.export("secret", lb.encryptedSecret());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lb:
 *     type: aws:iam:AccessKey
 *     properties:
 *       user: ${lbUser.name}
 *       pgpKey: keybase:some_person_that_exists
 *   lbUser:
 *     type: aws:iam:User
 *     name: lb
 *     properties:
 *       name: loadbalancer
 *       path: /system/
 *   lbRoUserPolicy:
 *     type: aws:iam:UserPolicy
 *     name: lb_ro
 *     properties:
 *       name: test
 *       user: ${lbUser.name}
 *       policy: ${lbRo.json}
 * variables:
 *   lbRo:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - ec2:Describe*
 *             resources:
 *               - '*'
 * outputs:
 *   secret: ${lb.encryptedSecret}
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.iam.User("test", {
 *     name: "test",
 *     path: "/test/",
 * });
 * const testAccessKey = new aws.iam.AccessKey("test", {user: test.name});
 * export const awsIamSmtpPasswordV4 = testAccessKey.sesSmtpPasswordV4;
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.iam.User("test",
 *     name="test",
 *     path="/test/")
 * test_access_key = aws.iam.AccessKey("test", user=test.name)
 * pulumi.export("awsIamSmtpPasswordV4", test_access_key.ses_smtp_password_v4)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Iam.User("test", new()
 *     {
 *         Name = "test",
 *         Path = "/test/",
 *     });
 *     var testAccessKey = new Aws.Iam.AccessKey("test", new()
 *     {
 *         User = test.Name,
 *     });
 *     return new Dictionary<string, object?>
 *     {
 *         ["awsIamSmtpPasswordV4"] = testAccessKey.SesSmtpPasswordV4,
 *     };
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := iam.NewUser(ctx, "test", &iam.UserArgs{
 * 			Name: pulumi.String("test"),
 * 			Path: pulumi.String("/test/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testAccessKey, err := iam.NewAccessKey(ctx, "test", &iam.AccessKeyArgs{
 * 			User: test.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ctx.Export("awsIamSmtpPasswordV4", testAccessKey.SesSmtpPasswordV4)
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.AccessKey;
 * import com.pulumi.aws.iam.AccessKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new User("test", UserArgs.builder()
 *             .name("test")
 *             .path("/test/")
 *             .build());
 *         var testAccessKey = new AccessKey("testAccessKey", AccessKeyArgs.builder()
 *             .user(test.name())
 *             .build());
 *         ctx.export("awsIamSmtpPasswordV4", testAccessKey.sesSmtpPasswordV4());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:iam:User
 *     properties:
 *       name: test
 *       path: /test/
 *   testAccessKey:
 *     type: aws:iam:AccessKey
 *     name: test
 *     properties:
 *       user: ${test.name}
 * outputs:
 *   awsIamSmtpPasswordV4: ${testAccessKey.sesSmtpPasswordV4}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM Access Keys using the identifier. For example:
 * ```sh
 * $ pulumi import aws:iam/accessKey:AccessKey example AKIA1234567890
 * ```
 * Resource attributes such as `encrypted_secret`, `key_fingerprint`, `pgp_key`, `secret`, `ses_smtp_password_v4`, and `encrypted_ses_smtp_password_v4` are not available for imported resources as this information cannot be read from the IAM API.
 * @property pgpKey Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`, for use in the `encrypted_secret` output attribute. If providing a base-64 encoded PGP public key, make sure to provide the "raw" version and not the "armored" one (e.g. avoid passing the `-a` option to `gpg --export`).
 * @property status Access key status to apply. Defaults to `Active`. Valid values are `Active` and `Inactive`.
 * @property user IAM user to associate with this access key.
 */
public data class AccessKeyArgs(
    public val pgpKey: Output<String>? = null,
    public val status: Output<String>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.AccessKeyArgs> {
    override fun toJava(): com.pulumi.aws.iam.AccessKeyArgs =
        com.pulumi.aws.iam.AccessKeyArgs.builder()
            .pgpKey(pgpKey?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessKeyArgs].
 */
@PulumiTagMarker
public class AccessKeyArgsBuilder internal constructor() {
    private var pgpKey: Output<String>? = null

    private var status: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`, for use in the `encrypted_secret` output attribute. If providing a base-64 encoded PGP public key, make sure to provide the "raw" version and not the "armored" one (e.g. avoid passing the `-a` option to `gpg --export`).
     */
    @JvmName("idfebgnykjqivugf")
    public suspend fun pgpKey(`value`: Output<String>) {
        this.pgpKey = value
    }

    /**
     * @param value Access key status to apply. Defaults to `Active`. Valid values are `Active` and `Inactive`.
     */
    @JvmName("ubdtrdirgjjhtsua")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value IAM user to associate with this access key.
     */
    @JvmName("cxxbarpwxpheeqgf")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:some_person_that_exists`, for use in the `encrypted_secret` output attribute. If providing a base-64 encoded PGP public key, make sure to provide the "raw" version and not the "armored" one (e.g. avoid passing the `-a` option to `gpg --export`).
     */
    @JvmName("wxwirjdxlcbytmwg")
    public suspend fun pgpKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pgpKey = mapped
    }

    /**
     * @param value Access key status to apply. Defaults to `Active`. Valid values are `Active` and `Inactive`.
     */
    @JvmName("jcegcdrpfinwtyhy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value IAM user to associate with this access key.
     */
    @JvmName("wfxnixenduxkmyba")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): AccessKeyArgs = AccessKeyArgs(
        pgpKey = pgpKey,
        status = status,
        user = user,
    )
}
