@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountAlias].
 */
@PulumiTagMarker
public class AccountAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountAliasArgs = AccountAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountAliasArgsBuilder.() -> Unit) {
        val builder = AccountAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccountAlias {
        val builtJavaResource = com.pulumi.aws.iam.AccountAlias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountAlias(builtJavaResource)
    }
}

/**
 * > **Note:** There is only a single account alias per AWS account.
 * Manages the account alias for the AWS Account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const alias = new aws.iam.AccountAlias("alias", {accountAlias: "my-account-alias"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * alias = aws.iam.AccountAlias("alias", account_alias="my-account-alias")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @alias = new Aws.Iam.AccountAlias("alias", new()
 *     {
 *         Alias = "my-account-alias",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewAccountAlias(ctx, "alias", &iam.AccountAliasArgs{
 * 			AccountAlias: pulumi.String("my-account-alias"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.AccountAlias;
 * import com.pulumi.aws.iam.AccountAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alias = new AccountAlias("alias", AccountAliasArgs.builder()
 *             .accountAlias("my-account-alias")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   alias:
 *     type: aws:iam:AccountAlias
 *     properties:
 *       accountAlias: my-account-alias
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the current Account Alias using the `account_alias`. For example:
 * ```sh
 * $ pulumi import aws:iam/accountAlias:AccountAlias alias my-account-alias
 * ```
 */
public class AccountAlias internal constructor(
    override val javaResource: com.pulumi.aws.iam.AccountAlias,
) : KotlinCustomResource(javaResource, AccountAliasMapper) {
    /**
     * The account alias
     */
    public val accountAlias: Output<String>
        get() = javaResource.accountAlias().applyValue({ args0 -> args0 })
}

public object AccountAliasMapper : ResourceMapper<AccountAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.AccountAlias::class == javaResource::class

    override fun map(javaResource: Resource): AccountAlias = AccountAlias(
        javaResource as
            com.pulumi.aws.iam.AccountAlias,
    )
}

/**
 * @see [AccountAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountAlias].
 */
public suspend fun accountAlias(
    name: String,
    block: suspend AccountAliasResourceBuilder.() -> Unit,
): AccountAlias {
    val builder = AccountAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountAlias(name: String): AccountAlias {
    val builder = AccountAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
