@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM group.
 * > **NOTE on user management:** Using `aws.iam.GroupMembership` or `aws.iam.UserGroupMembership` resources in addition to manually managing user/group membership using the console may lead to configuration drift or conflicts. For this reason, it's recommended to either manage membership entirely with the provider or entirely within the AWS console.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const developers = new aws.iam.Group("developers", {
 *     name: "developers",
 *     path: "/users/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * developers = aws.iam.Group("developers",
 *     name="developers",
 *     path="/users/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var developers = new Aws.Iam.Group("developers", new()
 *     {
 *         Name = "developers",
 *         Path = "/users/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewGroup(ctx, "developers", &iam.GroupArgs{
 * 			Name: pulumi.String("developers"),
 * 			Path: pulumi.String("/users/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var developers = new Group("developers", GroupArgs.builder()
 *             .name("developers")
 *             .path("/users/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   developers:
 *     type: aws:iam:Group
 *     properties:
 *       name: developers
 *       path: /users/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:iam/group:Group developers developers
 * ```
 * @property name The group's name. The name must consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: `=,.@-_.`. Group names are not distinguished by case. For example, you cannot create groups named both "ADMINS" and "admins".
 * @property path Path in which to create the group.
 */
public data class GroupArgs(
    public val name: Output<String>? = null,
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.GroupArgs> {
    override fun toJava(): com.pulumi.aws.iam.GroupArgs = com.pulumi.aws.iam.GroupArgs.builder()
        .name(name?.applyValue({ args0 -> args0 }))
        .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value The group's name. The name must consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: `=,.@-_.`. Group names are not distinguished by case. For example, you cannot create groups named both "ADMINS" and "admins".
     */
    @JvmName("kcdhoqqoyakvdoxf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Path in which to create the group.
     */
    @JvmName("cfsyjjdcaafgknkk")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The group's name. The name must consist of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: `=,.@-_.`. Group names are not distinguished by case. For example, you cannot create groups named both "ADMINS" and "admins".
     */
    @JvmName("rpxpkxsuyphbgeqd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Path in which to create the group.
     */
    @JvmName("rstmyednaxxiahsb")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        name = name,
        path = path,
    )
}
