@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.IamFunctions.getAccessKeysPlain
import com.pulumi.aws.iam.IamFunctions.getAccountAliasPlain
import com.pulumi.aws.iam.IamFunctions.getGroupPlain
import com.pulumi.aws.iam.IamFunctions.getInstanceProfilePlain
import com.pulumi.aws.iam.IamFunctions.getInstanceProfilesPlain
import com.pulumi.aws.iam.IamFunctions.getOpenIdConnectProviderPlain
import com.pulumi.aws.iam.IamFunctions.getPolicyDocumentPlain
import com.pulumi.aws.iam.IamFunctions.getPolicyPlain
import com.pulumi.aws.iam.IamFunctions.getPrincipalPolicySimulationPlain
import com.pulumi.aws.iam.IamFunctions.getRolePlain
import com.pulumi.aws.iam.IamFunctions.getRolesPlain
import com.pulumi.aws.iam.IamFunctions.getSamlProviderPlain
import com.pulumi.aws.iam.IamFunctions.getServerCertificatePlain
import com.pulumi.aws.iam.IamFunctions.getSessionContextPlain
import com.pulumi.aws.iam.IamFunctions.getUserPlain
import com.pulumi.aws.iam.IamFunctions.getUserSshKeyPlain
import com.pulumi.aws.iam.IamFunctions.getUsersPlain
import com.pulumi.aws.iam.kotlin.inputs.GetAccessKeysPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetAccessKeysPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetGroupPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetGroupPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetInstanceProfilePlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetInstanceProfilePlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetInstanceProfilesPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetInstanceProfilesPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetOpenIdConnectProviderPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetOpenIdConnectProviderPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyDocumentPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyDocumentPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyDocumentStatement
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetPolicyPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetPrincipalPolicySimulationContext
import com.pulumi.aws.iam.kotlin.inputs.GetPrincipalPolicySimulationPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetPrincipalPolicySimulationPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetRolePlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetRolePlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetRolesPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetRolesPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetSamlProviderPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetSamlProviderPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetServerCertificatePlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetServerCertificatePlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetSessionContextPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetSessionContextPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetUserPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetUserSshKeyPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetUserSshKeyPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.inputs.GetUsersPlainArgs
import com.pulumi.aws.iam.kotlin.inputs.GetUsersPlainArgsBuilder
import com.pulumi.aws.iam.kotlin.outputs.GetAccessKeysResult
import com.pulumi.aws.iam.kotlin.outputs.GetAccountAliasResult
import com.pulumi.aws.iam.kotlin.outputs.GetGroupResult
import com.pulumi.aws.iam.kotlin.outputs.GetInstanceProfileResult
import com.pulumi.aws.iam.kotlin.outputs.GetInstanceProfilesResult
import com.pulumi.aws.iam.kotlin.outputs.GetOpenIdConnectProviderResult
import com.pulumi.aws.iam.kotlin.outputs.GetPolicyDocumentResult
import com.pulumi.aws.iam.kotlin.outputs.GetPolicyResult
import com.pulumi.aws.iam.kotlin.outputs.GetPrincipalPolicySimulationInvokeResult
import com.pulumi.aws.iam.kotlin.outputs.GetRoleResult
import com.pulumi.aws.iam.kotlin.outputs.GetRolesResult
import com.pulumi.aws.iam.kotlin.outputs.GetSamlProviderResult
import com.pulumi.aws.iam.kotlin.outputs.GetServerCertificateResult
import com.pulumi.aws.iam.kotlin.outputs.GetSessionContextResult
import com.pulumi.aws.iam.kotlin.outputs.GetUserResult
import com.pulumi.aws.iam.kotlin.outputs.GetUserSshKeyResult
import com.pulumi.aws.iam.kotlin.outputs.GetUsersResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.iam.kotlin.outputs.GetAccessKeysResult.Companion.toKotlin as getAccessKeysResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetAccountAliasResult.Companion.toKotlin as getAccountAliasResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetGroupResult.Companion.toKotlin as getGroupResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetInstanceProfileResult.Companion.toKotlin as getInstanceProfileResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetInstanceProfilesResult.Companion.toKotlin as getInstanceProfilesResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetOpenIdConnectProviderResult.Companion.toKotlin as getOpenIdConnectProviderResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetPolicyDocumentResult.Companion.toKotlin as getPolicyDocumentResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetPolicyResult.Companion.toKotlin as getPolicyResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetPrincipalPolicySimulationInvokeResult.Companion.toKotlin as getPrincipalPolicySimulationInvokeResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetRoleResult.Companion.toKotlin as getRoleResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetRolesResult.Companion.toKotlin as getRolesResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetSamlProviderResult.Companion.toKotlin as getSamlProviderResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetServerCertificateResult.Companion.toKotlin as getServerCertificateResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetSessionContextResult.Companion.toKotlin as getSessionContextResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetUserSshKeyResult.Companion.toKotlin as getUserSshKeyResultToKotlin
import com.pulumi.aws.iam.kotlin.outputs.GetUsersResult.Companion.toKotlin as getUsersResultToKotlin

public object IamFunctions {
    /**
     * This data source can be used to fetch information about IAM access keys of a
     * specific IAM user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getAccessKeys({
     *     user: "an_example_user_name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_access_keys(user="an_example_user_name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetAccessKeys.Invoke(new()
     *     {
     *         User = "an_example_user_name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetAccessKeys(ctx, &iam.GetAccessKeysArgs{
     * 			User: "an_example_user_name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetAccessKeysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getAccessKeys(GetAccessKeysArgs.builder()
     *             .user("an_example_user_name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getAccessKeys
     *       Arguments:
     *         user: an_example_user_name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccessKeys.
     * @return A collection of values returned by getAccessKeys.
     */
    public suspend fun getAccessKeys(argument: GetAccessKeysPlainArgs): GetAccessKeysResult =
        getAccessKeysResultToKotlin(getAccessKeysPlain(argument.toJava()).await())

    /**
     * @see [getAccessKeys].
     * @param user Name of the IAM user associated with the access keys.
     * @return A collection of values returned by getAccessKeys.
     */
    public suspend fun getAccessKeys(user: String): GetAccessKeysResult {
        val argument = GetAccessKeysPlainArgs(
            user = user,
        )
        return getAccessKeysResultToKotlin(getAccessKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessKeys].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetAccessKeysPlainArgs].
     * @return A collection of values returned by getAccessKeys.
     */
    public suspend fun getAccessKeys(argument: suspend GetAccessKeysPlainArgsBuilder.() -> Unit): GetAccessKeysResult {
        val builder = GetAccessKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessKeysResultToKotlin(getAccessKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * The IAM Account Alias data source allows access to the account alias
     * for the effective account in which this provider is working.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.iam.getAccountAlias({});
     * export const accountAlias = current.then(current => current.accountAlias);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.iam.get_account_alias()
     * pulumi.export("accountAlias", current.account_alias)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.Iam.GetAccountAlias.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["accountAlias"] = current.Apply(getAccountAliasResult => getAccountAliasResult.AccountAlias),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := iam.LookupAccountAlias(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("accountAlias", current.AccountAlias)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = IamFunctions.getAccountAlias();
     *         ctx.export("accountAlias", current.applyValue(getAccountAliasResult -> getAccountAliasResult.accountAlias()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:iam:getAccountAlias
     *       Arguments: {}
     * outputs:
     *   accountAlias: ${current.accountAlias}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument The IAM Account Alias data source allows access to the account alias
     * for the effective account in which this provider is working.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.iam.getAccountAlias({});
     * export const accountAlias = current.then(current => current.accountAlias);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.iam.get_account_alias()
     * pulumi.export("accountAlias", current.account_alias)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.Iam.GetAccountAlias.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["accountAlias"] = current.Apply(getAccountAliasResult => getAccountAliasResult.AccountAlias),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := iam.LookupAccountAlias(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("accountAlias", current.AccountAlias)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = IamFunctions.getAccountAlias();
     *         ctx.export("accountAlias", current.applyValue(getAccountAliasResult -> getAccountAliasResult.accountAlias()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:iam:getAccountAlias
     *       Arguments: {}
     * outputs:
     *   accountAlias: ${current.accountAlias}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getAccountAlias.
     */
    public suspend fun getAccountAlias(): GetAccountAliasResult =
        getAccountAliasResultToKotlin(getAccountAliasPlain().await())

    /**
     * This data source can be used to fetch information about a specific
     * IAM group. By using this data source, you can reference IAM group
     * properties without having to hard code ARNs as input.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getGroup({
     *     groupName: "an_example_group_name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_group(group_name="an_example_group_name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetGroup.Invoke(new()
     *     {
     *         GroupName = "an_example_group_name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.LookupGroup(ctx, &iam.LookupGroupArgs{
     * 			GroupName: "an_example_group_name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getGroup(GetGroupArgs.builder()
     *             .groupName("an_example_group_name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getGroup
     *       Arguments:
     *         groupName: an_example_group_name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroup.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: GetGroupPlainArgs): GetGroupResult =
        getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())

    /**
     * @see [getGroup].
     * @param groupName Friendly IAM group name to match.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(groupName: String): GetGroupResult {
        val argument = GetGroupPlainArgs(
            groupName = groupName,
        )
        return getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetGroupPlainArgs].
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: suspend GetGroupPlainArgsBuilder.() -> Unit): GetGroupResult {
        val builder = GetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupResultToKotlin(getGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM instance profile. By using this data source, you can reference IAM
     * instance profile properties without having to hard code ARNs as input.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getInstanceProfile({
     *     name: "an_example_instance_profile_name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_instance_profile(name="an_example_instance_profile_name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetInstanceProfile.Invoke(new()
     *     {
     *         Name = "an_example_instance_profile_name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.LookupInstanceProfile(ctx, &iam.LookupInstanceProfileArgs{
     * 			Name: "an_example_instance_profile_name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetInstanceProfileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getInstanceProfile(GetInstanceProfileArgs.builder()
     *             .name("an_example_instance_profile_name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getInstanceProfile
     *       Arguments:
     *         name: an_example_instance_profile_name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceProfile.
     * @return A collection of values returned by getInstanceProfile.
     */
    public suspend fun getInstanceProfile(argument: GetInstanceProfilePlainArgs): GetInstanceProfileResult =
        getInstanceProfileResultToKotlin(getInstanceProfilePlain(argument.toJava()).await())

    /**
     * @see [getInstanceProfile].
     * @param name Friendly IAM instance profile name to match.
     * @return A collection of values returned by getInstanceProfile.
     */
    public suspend fun getInstanceProfile(name: String): GetInstanceProfileResult {
        val argument = GetInstanceProfilePlainArgs(
            name = name,
        )
        return getInstanceProfileResultToKotlin(getInstanceProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceProfile].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetInstanceProfilePlainArgs].
     * @return A collection of values returned by getInstanceProfile.
     */
    public suspend fun getInstanceProfile(argument: suspend GetInstanceProfilePlainArgsBuilder.() -> Unit): GetInstanceProfileResult {
        val builder = GetInstanceProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceProfileResultToKotlin(getInstanceProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about all
     * IAM instance profiles under a role. By using this data source, you can reference IAM
     * instance profile properties without having to hard code ARNs as input.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getInstanceProfiles({
     *     roleName: "an_example_iam_role_name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_instance_profiles(role_name="an_example_iam_role_name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetInstanceProfiles.Invoke(new()
     *     {
     *         RoleName = "an_example_iam_role_name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetInstanceProfiles(ctx, &iam.GetInstanceProfilesArgs{
     * 			RoleName: "an_example_iam_role_name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetInstanceProfilesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getInstanceProfiles(GetInstanceProfilesArgs.builder()
     *             .roleName("an_example_iam_role_name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getInstanceProfiles
     *       Arguments:
     *         roleName: an_example_iam_role_name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceProfiles.
     * @return A collection of values returned by getInstanceProfiles.
     */
    public suspend fun getInstanceProfiles(argument: GetInstanceProfilesPlainArgs): GetInstanceProfilesResult =
        getInstanceProfilesResultToKotlin(getInstanceProfilesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceProfiles].
     * @param roleName IAM role name.
     * @return A collection of values returned by getInstanceProfiles.
     */
    public suspend fun getInstanceProfiles(roleName: String): GetInstanceProfilesResult {
        val argument = GetInstanceProfilesPlainArgs(
            roleName = roleName,
        )
        return getInstanceProfilesResultToKotlin(getInstanceProfilesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceProfiles].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetInstanceProfilesPlainArgs].
     * @return A collection of values returned by getInstanceProfiles.
     */
    public suspend fun getInstanceProfiles(argument: suspend GetInstanceProfilesPlainArgsBuilder.() -> Unit): GetInstanceProfilesResult {
        val builder = GetInstanceProfilesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceProfilesResultToKotlin(getInstanceProfilesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM OpenID Connect provider. By using this data source, you can retrieve the
     * the resource information by either its `arn` or `url`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getOpenIdConnectProvider({
     *     arn: "arn:aws:iam::123456789012:oidc-provider/accounts.google.com",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_open_id_connect_provider(arn="arn:aws:iam::123456789012:oidc-provider/accounts.google.com")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetOpenIdConnectProvider.Invoke(new()
     *     {
     *         Arn = "arn:aws:iam::123456789012:oidc-provider/accounts.google.com",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.LookupOpenIdConnectProvider(ctx, &iam.LookupOpenIdConnectProviderArgs{
     * 			Arn: pulumi.StringRef("arn:aws:iam::123456789012:oidc-provider/accounts.google.com"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetOpenIdConnectProviderArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getOpenIdConnectProvider(GetOpenIdConnectProviderArgs.builder()
     *             .arn("arn:aws:iam::123456789012:oidc-provider/accounts.google.com")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getOpenIdConnectProvider
     *       Arguments:
     *         arn: arn:aws:iam::123456789012:oidc-provider/accounts.google.com
     * ```
     * <!--End PulumiCodeChooser -->
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getOpenIdConnectProvider({
     *     url: "https://accounts.google.com",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_open_id_connect_provider(url="https://accounts.google.com")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetOpenIdConnectProvider.Invoke(new()
     *     {
     *         Url = "https://accounts.google.com",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.LookupOpenIdConnectProvider(ctx, &iam.LookupOpenIdConnectProviderArgs{
     * 			Url: pulumi.StringRef("https://accounts.google.com"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetOpenIdConnectProviderArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getOpenIdConnectProvider(GetOpenIdConnectProviderArgs.builder()
     *             .url("https://accounts.google.com")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getOpenIdConnectProvider
     *       Arguments:
     *         url: https://accounts.google.com
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOpenIdConnectProvider.
     * @return A collection of values returned by getOpenIdConnectProvider.
     */
    public suspend fun getOpenIdConnectProvider(argument: GetOpenIdConnectProviderPlainArgs): GetOpenIdConnectProviderResult =
        getOpenIdConnectProviderResultToKotlin(getOpenIdConnectProviderPlain(argument.toJava()).await())

    /**
     * @see [getOpenIdConnectProvider].
     * @param arn ARN of the OpenID Connect provider.
     * @param tags Map of resource tags for the IAM OIDC provider.
     * @param url URL of the OpenID Connect provider.
     * @return A collection of values returned by getOpenIdConnectProvider.
     */
    public suspend fun getOpenIdConnectProvider(
        arn: String? = null,
        tags: Map<String, String>? = null,
        url: String? = null,
    ): GetOpenIdConnectProviderResult {
        val argument = GetOpenIdConnectProviderPlainArgs(
            arn = arn,
            tags = tags,
            url = url,
        )
        return getOpenIdConnectProviderResultToKotlin(getOpenIdConnectProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenIdConnectProvider].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetOpenIdConnectProviderPlainArgs].
     * @return A collection of values returned by getOpenIdConnectProvider.
     */
    public suspend fun getOpenIdConnectProvider(argument: suspend GetOpenIdConnectProviderPlainArgsBuilder.() -> Unit): GetOpenIdConnectProviderResult {
        val builder = GetOpenIdConnectProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenIdConnectProviderResultToKotlin(getOpenIdConnectProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM policy.
     * ## Example Usage
     * ### By ARN
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getPolicy({
     *     arn: "arn:aws:iam::123456789012:policy/UsersManageOwnCredentials",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_policy(arn="arn:aws:iam::123456789012:policy/UsersManageOwnCredentials")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetPolicy.Invoke(new()
     *     {
     *         Arn = "arn:aws:iam::123456789012:policy/UsersManageOwnCredentials",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.LookupPolicy(ctx, &iam.LookupPolicyArgs{
     * 			Arn: pulumi.StringRef("arn:aws:iam::123456789012:policy/UsersManageOwnCredentials"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getPolicy(GetPolicyArgs.builder()
     *             .arn("arn:aws:iam::123456789012:policy/UsersManageOwnCredentials")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getPolicy
     *       Arguments:
     *         arn: arn:aws:iam::123456789012:policy/UsersManageOwnCredentials
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getPolicy({
     *     name: "test_policy",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_policy(name="test_policy")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetPolicy.Invoke(new()
     *     {
     *         Name = "test_policy",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.LookupPolicy(ctx, &iam.LookupPolicyArgs{
     * 			Name: pulumi.StringRef("test_policy"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getPolicy(GetPolicyArgs.builder()
     *             .name("test_policy")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getPolicy
     *       Arguments:
     *         name: test_policy
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPolicy.
     * @return A collection of values returned by getPolicy.
     */
    public suspend fun getPolicy(argument: GetPolicyPlainArgs): GetPolicyResult =
        getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())

    /**
     * @see [getPolicy].
     * @param arn ARN of the IAM policy.
     * Conflicts with `name` and `path_prefix`.
     * @param name Name of the IAM policy.
     * Conflicts with `arn`.
     * @param pathPrefix Prefix of the path to the IAM policy.
     * Defaults to a slash (`/`).
     * Conflicts with `arn`.
     * @param tags Key-value mapping of tags for the IAM Policy.
     * @return A collection of values returned by getPolicy.
     */
    public suspend fun getPolicy(
        arn: String? = null,
        name: String? = null,
        pathPrefix: String? = null,
        tags: Map<String, String>? = null,
    ): GetPolicyResult {
        val argument = GetPolicyPlainArgs(
            arn = arn,
            name = name,
            pathPrefix = pathPrefix,
            tags = tags,
        )
        return getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetPolicyPlainArgs].
     * @return A collection of values returned by getPolicy.
     */
    public suspend fun getPolicy(argument: suspend GetPolicyPlainArgsBuilder.() -> Unit): GetPolicyResult {
        val builder = GetPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyResultToKotlin(getPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Generates an IAM policy document in JSON format for use with resources that expect policy documents such as `aws.iam.Policy`.
     * Using this data source to generate policy documents is *optional*. It is also valid to use literal JSON strings in your configuration or to use the `file` interpolation function to read a raw JSON policy document from a file.
     * ## Example Usage
     * ### Basic Example
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getPolicyDocument({
     *     statements: [
     *         {
     *             sid: "1",
     *             actions: [
     *                 "s3:ListAllMyBuckets",
     *                 "s3:GetBucketLocation",
     *             ],
     *             resources: ["arn:aws:s3:::*"],
     *         },
     *         {
     *             actions: ["s3:ListBucket"],
     *             resources: [`arn:aws:s3:::${s3BucketName}`],
     *             conditions: [{
     *                 test: "StringLike",
     *                 variable: "s3:prefix",
     *                 values: [
     *                     "",
     *                     "home/",
     *                     "home/&{aws:username}/",
     *                 ],
     *             }],
     *         },
     *         {
     *             actions: ["s3:*"],
     *             resources: [
     *                 `arn:aws:s3:::${s3BucketName}/home/&{aws:username}`,
     *                 `arn:aws:s3:::${s3BucketName}/home/&{aws:username}/*`,
     *             ],
     *         },
     *     ],
     * });
     * const examplePolicy = new aws.iam.Policy("example", {
     *     name: "example_policy",
     *     path: "/",
     *     policy: example.then(example => example.json),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_policy_document(statements=[
     *     {
     *         "sid": "1",
     *         "actions": [
     *             "s3:ListAllMyBuckets",
     *             "s3:GetBucketLocation",
     *         ],
     *         "resources": ["arn:aws:s3:::*"],
     *     },
     *     {
     *         "actions": ["s3:ListBucket"],
     *         "resources": [f"arn:aws:s3:::{s3_bucket_name}"],
     *         "conditions": [{
     *             "test": "StringLike",
     *             "variable": "s3:prefix",
     *             "values": [
     *                 "",
     *                 "home/",
     *                 "home/&{aws:username}/",
     *             ],
     *         }],
     *     },
     *     {
     *         "actions": ["s3:*"],
     *         "resources": [
     *             f"arn:aws:s3:::{s3_bucket_name}/home/&{{aws:username}}",
     *             f"arn:aws:s3:::{s3_bucket_name}/home/&{{aws:username}}/*",
     *         ],
     *     },
     * ])
     * example_policy = aws.iam.Policy("example",
     *     name="example_policy",
     *     path="/",
     *     policy=example.json)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "1",
     *                 Actions = new[]
     *                 {
     *                     "s3:ListAllMyBuckets",
     *                     "s3:GetBucketLocation",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "arn:aws:s3:::*",
     *                 },
     *             },
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Actions = new[]
     *                 {
     *                     "s3:ListBucket",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     $"arn:aws:s3:::{s3BucketName}",
     *                 },
     *                 Conditions = new[]
     *                 {
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
     *                     {
     *                         Test = "StringLike",
     *                         Variable = "s3:prefix",
     *                         Values = new[]
     *                         {
     *                             "",
     *                             "home/",
     *                             "home/&{aws:username}/",
     *                         },
     *                     },
     *                 },
     *             },
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Actions = new[]
     *                 {
     *                     "s3:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     $"arn:aws:s3:::{s3BucketName}/home/&{{aws:username}}",
     *                     $"arn:aws:s3:::{s3BucketName}/home/&{{aws:username}}/*",
     *                 },
     *             },
     *         },
     *     });
     *     var examplePolicy = new Aws.Iam.Policy("example", new()
     *     {
     *         Name = "example_policy",
     *         Path = "/",
     *         PolicyDocument = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * 			Statements: []iam.GetPolicyDocumentStatement{
     * 				{
     * 					Sid: pulumi.StringRef("1"),
     * 					Actions: []string{
     * 						"s3:ListAllMyBuckets",
     * 						"s3:GetBucketLocation",
     * 					},
     * 					Resources: []string{
     * 						"arn:aws:s3:::*",
     * 					},
     * 				},
     * 				{
     * 					Actions: []string{
     * 						"s3:ListBucket",
     * 					},
     * 					Resources: []string{
     * 						fmt.Sprintf("arn:aws:s3:::%v", s3BucketName),
     * 					},
     * 					Conditions: []iam.GetPolicyDocumentStatementCondition{
     * 						{
     * 							Test:     "StringLike",
     * 							Variable: "s3:prefix",
     * 							Values: []string{
     * 								"",
     * 								"home/",
     * 								"home/&{aws:username}/",
     * 							},
     * 						},
     * 					},
     * 				},
     * 				{
     * 					Actions: []string{
     * 						"s3:*",
     * 					},
     * 					Resources: []string{
     * 						fmt.Sprintf("arn:aws:s3:::%v/home/&{aws:username}", s3BucketName),
     * 						fmt.Sprintf("arn:aws:s3:::%v/home/&{aws:username}/*", s3BucketName),
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = iam.NewPolicy(ctx, "example", &iam.PolicyArgs{
     * 			Name:   pulumi.String("example_policy"),
     * 			Path:   pulumi.String("/"),
     * 			Policy: pulumi.String(example.Json),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.iam.Policy;
     * import com.pulumi.aws.iam.PolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("1")
     *                     .actions(
     *                         "s3:ListAllMyBuckets",
     *                         "s3:GetBucketLocation")
     *                     .resources("arn:aws:s3:::*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("s3:ListBucket")
     *                     .resources(String.format("arn:aws:s3:::%s", s3BucketName))
     *                     .conditions(GetPolicyDocumentStatementConditionArgs.builder()
     *                         .test("StringLike")
     *                         .variable("s3:prefix")
     *                         .values(
     *                             "",
     *                             "home/",
     *                             "home/&{aws:username}/")
     *                         .build())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("s3:*")
     *                     .resources(
     *                         String.format("arn:aws:s3:::%s/home/&{{aws:username}}", s3BucketName),
     *                         String.format("arn:aws:s3:::%s/home/&{{aws:username}}/*", s3BucketName))
     *                     .build())
     *             .build());
     *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
     *             .name("example_policy")
     *             .path("/")
     *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   examplePolicy:
     *     type: aws:iam:Policy
     *     name: example
     *     properties:
     *       name: example_policy
     *       path: /
     *       policy: ${example.json}
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - sid: '1'
     *             actions:
     *               - s3:ListAllMyBuckets
     *               - s3:GetBucketLocation
     *             resources:
     *               - arn:aws:s3:::*
     *           - actions:
     *               - s3:ListBucket
     *             resources:
     *               - arn:aws:s3:::${s3BucketName}
     *             conditions:
     *               - test: StringLike
     *                 variable: s3:prefix
     *                 values:
     *                   -
     *                   - home/
     *                   - home/&{aws:username}/
     *           - actions:
     *               - s3:*
     *             resources:
     *               - arn:aws:s3:::${s3BucketName}/home/&{aws:username}
     *               - arn:aws:s3:::${s3BucketName}/home/&{aws:username}/*
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Example Multiple Condition Keys and Values
     * You can specify a [condition with multiple keys and values](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_multi-value-conditions.html) by supplying multiple `condition` blocks with the same `test` value, but differing `variable` and `values` values.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const exampleMultipleConditionKeysAndValues = aws.iam.getPolicyDocument({
     *     statements: [{
     *         actions: [
     *             "kms:Decrypt",
     *             "kms:GenerateDataKey",
     *         ],
     *         resources: ["*"],
     *         conditions: [
     *             {
     *                 test: "ForAnyValue:StringEquals",
     *                 variable: "kms:EncryptionContext:service",
     *                 values: ["pi"],
     *             },
     *             {
     *                 test: "ForAnyValue:StringEquals",
     *                 variable: "kms:EncryptionContext:aws:pi:service",
     *                 values: ["rds"],
     *             },
     *             {
     *                 test: "ForAnyValue:StringEquals",
     *                 variable: "kms:EncryptionContext:aws:rds:db-id",
     *                 values: [
     *                     "db-AAAAABBBBBCCCCCDDDDDEEEEE",
     *                     "db-EEEEEDDDDDCCCCCBBBBBAAAAA",
     *                 ],
     *             },
     *         ],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example_multiple_condition_keys_and_values = aws.iam.get_policy_document(statements=[{
     *     "actions": [
     *         "kms:Decrypt",
     *         "kms:GenerateDataKey",
     *     ],
     *     "resources": ["*"],
     *     "conditions": [
     *         {
     *             "test": "ForAnyValue:StringEquals",
     *             "variable": "kms:EncryptionContext:service",
     *             "values": ["pi"],
     *         },
     *         {
     *             "test": "ForAnyValue:StringEquals",
     *             "variable": "kms:EncryptionContext:aws:pi:service",
     *             "values": ["rds"],
     *         },
     *         {
     *             "test": "ForAnyValue:StringEquals",
     *             "variable": "kms:EncryptionContext:aws:rds:db-id",
     *             "values": [
     *                 "db-AAAAABBBBBCCCCCDDDDDEEEEE",
     *                 "db-EEEEEDDDDDCCCCCBBBBBAAAAA",
     *             ],
     *         },
     *     ],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var exampleMultipleConditionKeysAndValues = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Actions = new[]
     *                 {
     *                     "kms:Decrypt",
     *                     "kms:GenerateDataKey",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *                 Conditions = new[]
     *                 {
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
     *                     {
     *                         Test = "ForAnyValue:StringEquals",
     *                         Variable = "kms:EncryptionContext:service",
     *                         Values = new[]
     *                         {
     *                             "pi",
     *                         },
     *                     },
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
     *                     {
     *                         Test = "ForAnyValue:StringEquals",
     *                         Variable = "kms:EncryptionContext:aws:pi:service",
     *                         Values = new[]
     *                         {
     *                             "rds",
     *                         },
     *                     },
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
     *                     {
     *                         Test = "ForAnyValue:StringEquals",
     *                         Variable = "kms:EncryptionContext:aws:rds:db-id",
     *                         Values = new[]
     *                         {
     *                             "db-AAAAABBBBBCCCCCDDDDDEEEEE",
     *                             "db-EEEEEDDDDDCCCCCBBBBBAAAAA",
     *                         },
     *                     },
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * 			Statements: []iam.GetPolicyDocumentStatement{
     * 				{
     * 					Actions: []string{
     * 						"kms:Decrypt",
     * 						"kms:GenerateDataKey",
     * 					},
     * 					Resources: []string{
     * 						"*",
     * 					},
     * 					Conditions: []iam.GetPolicyDocumentStatementCondition{
     * 						{
     * 							Test:     "ForAnyValue:StringEquals",
     * 							Variable: "kms:EncryptionContext:service",
     * 							Values: []string{
     * 								"pi",
     * 							},
     * 						},
     * 						{
     * 							Test:     "ForAnyValue:StringEquals",
     * 							Variable: "kms:EncryptionContext:aws:pi:service",
     * 							Values: []string{
     * 								"rds",
     * 							},
     * 						},
     * 						{
     * 							Test:     "ForAnyValue:StringEquals",
     * 							Variable: "kms:EncryptionContext:aws:rds:db-id",
     * 							Values: []string{
     * 								"db-AAAAABBBBBCCCCCDDDDDEEEEE",
     * 								"db-EEEEEDDDDDCCCCCBBBBBAAAAA",
     * 							},
     * 						},
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleMultipleConditionKeysAndValues = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions(
     *                     "kms:Decrypt",
     *                     "kms:GenerateDataKey")
     *                 .resources("*")
     *                 .conditions(
     *                     GetPolicyDocumentStatementConditionArgs.builder()
     *                         .test("ForAnyValue:StringEquals")
     *                         .variable("kms:EncryptionContext:service")
     *                         .values("pi")
     *                         .build(),
     *                     GetPolicyDocumentStatementConditionArgs.builder()
     *                         .test("ForAnyValue:StringEquals")
     *                         .variable("kms:EncryptionContext:aws:pi:service")
     *                         .values("rds")
     *                         .build(),
     *                     GetPolicyDocumentStatementConditionArgs.builder()
     *                         .test("ForAnyValue:StringEquals")
     *                         .variable("kms:EncryptionContext:aws:rds:db-id")
     *                         .values(
     *                             "db-AAAAABBBBBCCCCCDDDDDEEEEE",
     *                             "db-EEEEEDDDDDCCCCCBBBBBAAAAA")
     *                         .build())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   exampleMultipleConditionKeysAndValues:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - actions:
     *               - kms:Decrypt
     *               - kms:GenerateDataKey
     *             resources:
     *               - '*'
     *             conditions:
     *               - test: ForAnyValue:StringEquals
     *                 variable: kms:EncryptionContext:service
     *                 values:
     *                   - pi
     *               - test: ForAnyValue:StringEquals
     *                 variable: kms:EncryptionContext:aws:pi:service
     *                 values:
     *                   - rds
     *               - test: ForAnyValue:StringEquals
     *                 variable: kms:EncryptionContext:aws:rds:db-id
     *                 values:
     *                   - db-AAAAABBBBBCCCCCDDDDDEEEEE
     *                   - db-EEEEEDDDDDCCCCCBBBBBAAAAA
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.aws_iam_policy_document.example_multiple_condition_keys_and_values.json` will evaluate to:
     * ```json
     * {
     *   "Version": "2012-10-17",
     *   "Statement": [
     *     {
     *       "Sid": "",
     *       "Effect": "Allow",
     *       "Action": [
     *         "kms:GenerateDataKey",
     *         "kms:Decrypt"
     *       ],
     *       "Resource": "*",
     *       "Condition": {
     *         "ForAnyValue:StringEquals": {
     *           "kms:EncryptionContext:aws:pi:service": "rds",
     *           "kms:EncryptionContext:aws:rds:db-id": [
     *             "db-AAAAABBBBBCCCCCDDDDDEEEEE",
     *             "db-EEEEEDDDDDCCCCCBBBBBAAAAA"
     *           ],
     *           "kms:EncryptionContext:service": "pi"
     *         }
     *       }
     *     }
     *   ]
     * }
     * ```
     * ### Example Assume-Role Policy with Multiple Principals
     * You can specify multiple principal blocks with different types. You can also use this data source to generate an assume-role policy.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const eventStreamBucketRoleAssumeRolePolicy = aws.iam.getPolicyDocument({
     *     statements: [{
     *         actions: ["sts:AssumeRole"],
     *         principals: [
     *             {
     *                 type: "Service",
     *                 identifiers: ["firehose&#46;amazonaws&#46;com"],
     *             },
     *             {
     *                 type: "AWS",
     *                 identifiers: [trustedRoleArn],
     *             },
     *             {
     *                 type: "Federated",
     *                 identifiers: [
     *                     `arn:aws:iam::${accountId}:saml-provider/${providerName}`,
     *                     "cognito-identity.amazonaws.com",
     *                 ],
     *             },
     *         ],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * event_stream_bucket_role_assume_role_policy = aws.iam.get_policy_document(statements=[{
     *     "actions": ["sts:AssumeRole"],
     *     "principals": [
     *         {
     *             "type": "Service",
     *             "identifiers": ["firehose&#46;amazonaws&#46;com"],
     *         },
     *         {
     *             "type": "AWS",
     *             "identifiers": [trusted_role_arn],
     *         },
     *         {
     *             "type": "Federated",
     *             "identifiers": [
     *                 f"arn:aws:iam::{account_id}:saml-provider/{provider_name}",
     *                 "cognito-identity.amazonaws.com",
     *             ],
     *         },
     *     ],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var eventStreamBucketRoleAssumeRolePolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Actions = new[]
     *                 {
     *                     "sts:AssumeRole",
     *                 },
     *                 Principals = new[]
     *                 {
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Type = "Service",
     *                         Identifiers = new[]
     *                         {
     *                             "firehose.amazonaws.com",
     *                         },
     *                     },
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Type = "AWS",
     *                         Identifiers = new[]
     *                         {
     *                             trustedRoleArn,
     *                         },
     *                     },
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Type = "Federated",
     *                         Identifiers = new[]
     *                         {
     *                             $"arn:aws:iam::{accountId}:saml-provider/{providerName}",
     *                             "cognito-identity.amazonaws.com",
     *                         },
     *                     },
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Actions: []string{
     * "sts:AssumeRole",
     * },
     * Principals: []iam.GetPolicyDocumentStatementPrincipal{
     * {
     * Type: "Service",
     * Identifiers: []string{
     * "firehose.amazonaws.com",
     * },
     * },
     * {
     * Type: "AWS",
     * Identifiers: interface{}{
     * trustedRoleArn,
     * },
     * },
     * {
     * Type: "Federated",
     * Identifiers: []string{
     * fmt.Sprintf("arn:aws:iam::%v:saml-provider/%v", accountId, providerName),
     * "cognito-identity.amazonaws.com",
     * },
     * },
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var eventStreamBucketRoleAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .actions("sts:AssumeRole")
     *                 .principals(
     *                     GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("Service")
     *                         .identifiers("firehose.amazonaws.com")
     *                         .build(),
     *                     GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(trustedRoleArn)
     *                         .build(),
     *                     GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("Federated")
     *                         .identifiers(
     *                             String.format("arn:aws:iam::%s:saml-provider/%s", accountId,providerName),
     *                             "cognito-identity.amazonaws.com")
     *                         .build())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   eventStreamBucketRoleAssumeRolePolicy:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - actions:
     *               - sts:AssumeRole
     *             principals:
     *               - type: Service
     *                 identifiers:
     *                   - firehose.amazonaws.com
     *               - type: AWS
     *                 identifiers:
     *                   - ${trustedRoleArn}
     *               - type: Federated
     *                 identifiers:
     *                   - arn:aws:iam::${accountId}:saml-provider/${providerName}
     *                   - cognito-identity.amazonaws.com
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Example Using A Source Document
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const source = aws.iam.getPolicyDocument({
     *     statements: [
     *         {
     *             actions: ["ec2:*"],
     *             resources: ["*"],
     *         },
     *         {
     *             sid: "SidToOverride",
     *             actions: ["s3:*"],
     *             resources: ["*"],
     *         },
     *     ],
     * });
     * const sourceDocumentExample = source.then(source => aws.iam.getPolicyDocument({
     *     sourcePolicyDocuments: [source&#46;json],
     *     statements: [{
     *         sid: "SidToOverride",
     *         actions: ["s3:*"],
     *         resources: [
     *             "arn:aws:s3:::somebucket",
     *             "arn:aws:s3:::somebucket/*",
     *         ],
     *     }],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * source = aws.iam.get_policy_document(statements=[
     *     {
     *         "actions": ["ec2:*"],
     *         "resources": ["*"],
     *     },
     *     {
     *         "sid": "SidToOverride",
     *         "actions": ["s3:*"],
     *         "resources": ["*"],
     *     },
     * ])
     * source_document_example = aws.iam.get_policy_document(source_policy_documents=[source&#46;json],
     *     statements=[{
     *         "sid": "SidToOverride",
     *         "actions": ["s3:*"],
     *         "resources": [
     *             "arn:aws:s3:::somebucket",
     *             "arn:aws:s3:::somebucket/*",
     *         ],
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var source = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Actions = new[]
     *                 {
     *                     "ec2:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "SidToOverride",
     *                 Actions = new[]
     *                 {
     *                     "s3:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     *     var sourceDocumentExample = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         SourcePolicyDocuments = new[]
     *         {
     *             source.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *         },
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "SidToOverride",
     *                 Actions = new[]
     *                 {
     *                     "s3:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "arn:aws:s3:::somebucket",
     *                     "arn:aws:s3:::somebucket/*",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * source, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Actions: []string{
     * "ec2:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * {
     * Sid: pulumi.StringRef("SidToOverride"),
     * Actions: []string{
     * "s3:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * _, err = iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * SourcePolicyDocuments: interface{}{
     * source.Json,
     * },
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Sid: pulumi.StringRef("SidToOverride"),
     * Actions: []string{
     * "s3:*",
     * },
     * Resources: []string{
     * "arn:aws:s3:::somebucket",
     * "arn:aws:s3:::somebucket/*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var source = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("ec2:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("SidToOverride")
     *                     .actions("s3:*")
     *                     .resources("*")
     *                     .build())
     *             .build());
     *         final var sourceDocumentExample = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .sourcePolicyDocuments(source.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("SidToOverride")
     *                 .actions("s3:*")
     *                 .resources(
     *                     "arn:aws:s3:::somebucket",
     *                     "arn:aws:s3:::somebucket/*")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   source:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - actions:
     *               - ec2:*
     *             resources:
     *               - '*'
     *           - sid: SidToOverride
     *             actions:
     *               - s3:*
     *             resources:
     *               - '*'
     *   sourceDocumentExample:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         sourcePolicyDocuments:
     *           - ${source.json}
     *         statements:
     *           - sid: SidToOverride
     *             actions:
     *               - s3:*
     *             resources:
     *               - arn:aws:s3:::somebucket
     *               - arn:aws:s3:::somebucket/*
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.aws_iam_policy_document.source_document_example.json` will evaluate to:
     * ```json
     * {
     *   "Version": "2012-10-17",
     *   "Statement": [
     *     {
     *       "Sid": "",
     *       "Effect": "Allow",
     *       "Action": "ec2:*",
     *       "Resource": "*"
     *     },
     *     {
     *       "Sid": "SidToOverride",
     *       "Effect": "Allow",
     *       "Action": "s3:*",
     *       "Resource": [
     *         "arn:aws:s3:::somebucket/*",
     *         "arn:aws:s3:::somebucket"
     *       ]
     *     }
     *   ]
     * }
     * ```
     * ### Example Using An Override Document
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const override = aws.iam.getPolicyDocument({
     *     statements: [{
     *         sid: "SidToOverride",
     *         actions: ["s3:*"],
     *         resources: ["*"],
     *     }],
     * });
     * const overridePolicyDocumentExample = override.then(override => aws.iam.getPolicyDocument({
     *     overridePolicyDocuments: [override&#46;json],
     *     statements: [
     *         {
     *             actions: ["ec2:*"],
     *             resources: ["*"],
     *         },
     *         {
     *             sid: "SidToOverride",
     *             actions: ["s3:*"],
     *             resources: [
     *                 "arn:aws:s3:::somebucket",
     *                 "arn:aws:s3:::somebucket/*",
     *             ],
     *         },
     *     ],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * override = aws.iam.get_policy_document(statements=[{
     *     "sid": "SidToOverride",
     *     "actions": ["s3:*"],
     *     "resources": ["*"],
     * }])
     * override_policy_document_example = aws.iam.get_policy_document(override_policy_documents=[override&#46;json],
     *     statements=[
     *         {
     *             "actions": ["ec2:*"],
     *             "resources": ["*"],
     *         },
     *         {
     *             "sid": "SidToOverride",
     *             "actions": ["s3:*"],
     *             "resources": [
     *                 "arn:aws:s3:::somebucket",
     *                 "arn:aws:s3:::somebucket/*",
     *             ],
     *         },
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @override = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "SidToOverride",
     *                 Actions = new[]
     *                 {
     *                     "s3:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     *     var overridePolicyDocumentExample = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         OverridePolicyDocuments = new[]
     *         {
     *             @override.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *         },
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Actions = new[]
     *                 {
     *                     "ec2:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "SidToOverride",
     *                 Actions = new[]
     *                 {
     *                     "s3:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "arn:aws:s3:::somebucket",
     *                     "arn:aws:s3:::somebucket/*",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * override, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Sid: pulumi.StringRef("SidToOverride"),
     * Actions: []string{
     * "s3:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * _, err = iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * OverridePolicyDocuments: interface{}{
     * override.Json,
     * },
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Actions: []string{
     * "ec2:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * {
     * Sid: pulumi.StringRef("SidToOverride"),
     * Actions: []string{
     * "s3:*",
     * },
     * Resources: []string{
     * "arn:aws:s3:::somebucket",
     * "arn:aws:s3:::somebucket/*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var override = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("SidToOverride")
     *                 .actions("s3:*")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var overridePolicyDocumentExample = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .overridePolicyDocuments(override.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("ec2:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("SidToOverride")
     *                     .actions("s3:*")
     *                     .resources(
     *                         "arn:aws:s3:::somebucket",
     *                         "arn:aws:s3:::somebucket/*")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   override:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - sid: SidToOverride
     *             actions:
     *               - s3:*
     *             resources:
     *               - '*'
     *   overridePolicyDocumentExample:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         overridePolicyDocuments:
     *           - ${override.json}
     *         statements:
     *           - actions:
     *               - ec2:*
     *             resources:
     *               - '*'
     *           - sid: SidToOverride
     *             actions:
     *               - s3:*
     *             resources:
     *               - arn:aws:s3:::somebucket
     *               - arn:aws:s3:::somebucket/*
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.aws_iam_policy_document.override_policy_document_example.json` will evaluate to:
     * ```json
     * {
     *   "Version": "2012-10-17",
     *   "Statement": [
     *     {
     *       "Sid": "",
     *       "Effect": "Allow",
     *       "Action": "ec2:*",
     *       "Resource": "*"
     *     },
     *     {
     *       "Sid": "SidToOverride",
     *       "Effect": "Allow",
     *       "Action": "s3:*",
     *       "Resource": "*"
     *     }
     *   ]
     * }
     * ```
     * ### Example with Both Source and Override Documents
     * You can also combine `source_policy_documents` and `override_policy_documents` in the same document.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const source = aws.iam.getPolicyDocument({
     *     statements: [{
     *         sid: "OverridePlaceholder",
     *         actions: ["ec2:DescribeAccountAttributes"],
     *         resources: ["*"],
     *     }],
     * });
     * const override = aws.iam.getPolicyDocument({
     *     statements: [{
     *         sid: "OverridePlaceholder",
     *         actions: ["s3:GetObject"],
     *         resources: ["*"],
     *     }],
     * });
     * const politik = Promise.all([source, override])&#46;then(([source, override]) => aws.iam.getPolicyDocument({
     *     sourcePolicyDocuments: [source&#46;json],
     *     overridePolicyDocuments: [override&#46;json],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * source = aws.iam.get_policy_document(statements=[{
     *     "sid": "OverridePlaceholder",
     *     "actions": ["ec2:DescribeAccountAttributes"],
     *     "resources": ["*"],
     * }])
     * override = aws.iam.get_policy_document(statements=[{
     *     "sid": "OverridePlaceholder",
     *     "actions": ["s3:GetObject"],
     *     "resources": ["*"],
     * }])
     * politik = aws.iam.get_policy_document(source_policy_documents=[source&#46;json],
     *     override_policy_documents=[override&#46;json])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var source = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "OverridePlaceholder",
     *                 Actions = new[]
     *                 {
     *                     "ec2:DescribeAccountAttributes",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     *     var @override = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "OverridePlaceholder",
     *                 Actions = new[]
     *                 {
     *                     "s3:GetObject",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     *     var politik = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         SourcePolicyDocuments = new[]
     *         {
     *             source.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *         },
     *         OverridePolicyDocuments = new[]
     *         {
     *             @override.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * source, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Sid: pulumi.StringRef("OverridePlaceholder"),
     * Actions: []string{
     * "ec2:DescribeAccountAttributes",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * override, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Sid: pulumi.StringRef("OverridePlaceholder"),
     * Actions: []string{
     * "s3:GetObject",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * _, err = iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * SourcePolicyDocuments: interface{}{
     * source.Json,
     * },
     * OverridePolicyDocuments: interface{}{
     * override.Json,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var source = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceholder")
     *                 .actions("ec2:DescribeAccountAttributes")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var override = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceholder")
     *                 .actions("s3:GetObject")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var politik = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .sourcePolicyDocuments(source.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .overridePolicyDocuments(override.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   source:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - sid: OverridePlaceholder
     *             actions:
     *               - ec2:DescribeAccountAttributes
     *             resources:
     *               - '*'
     *   override:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - sid: OverridePlaceholder
     *             actions:
     *               - s3:GetObject
     *             resources:
     *               - '*'
     *   politik:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         sourcePolicyDocuments:
     *           - ${source.json}
     *         overridePolicyDocuments:
     *           - ${override.json}
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.aws_iam_policy_document.politik.json` will evaluate to:
     * ```json
     * {
     *   "Version": "2012-10-17",
     *   "Statement": [
     *     {
     *       "Sid": "OverridePlaceholder",
     *       "Effect": "Allow",
     *       "Action": "s3:GetObject",
     *       "Resource": "*"
     *     }
     *   ]
     * }
     * ```
     * ### Example of Merging Source Documents
     * Multiple documents can be combined using the `source_policy_documents` or `override_policy_documents` attributes. `source_policy_documents` requires that all documents have unique Sids, while `override_policy_documents` will iteratively override matching Sids.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const sourceOne = aws.iam.getPolicyDocument({
     *     statements: [
     *         {
     *             actions: ["ec2:*"],
     *             resources: ["*"],
     *         },
     *         {
     *             sid: "UniqueSidOne",
     *             actions: ["s3:*"],
     *             resources: ["*"],
     *         },
     *     ],
     * });
     * const sourceTwo = aws.iam.getPolicyDocument({
     *     statements: [
     *         {
     *             sid: "UniqueSidTwo",
     *             actions: ["iam:*"],
     *             resources: ["*"],
     *         },
     *         {
     *             actions: ["lambda:*"],
     *             resources: ["*"],
     *         },
     *     ],
     * });
     * const combined = Promise.all([sourceOne, sourceTwo])&#46;then(([sourceOne, sourceTwo]) => aws.iam.getPolicyDocument({
     *     sourcePolicyDocuments: [
     *         sourceOne.json,
     *         sourceTwo.json,
     *     ],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * source_one = aws.iam.get_policy_document(statements=[
     *     {
     *         "actions": ["ec2:*"],
     *         "resources": ["*"],
     *     },
     *     {
     *         "sid": "UniqueSidOne",
     *         "actions": ["s3:*"],
     *         "resources": ["*"],
     *     },
     * ])
     * source_two = aws.iam.get_policy_document(statements=[
     *     {
     *         "sid": "UniqueSidTwo",
     *         "actions": ["iam:*"],
     *         "resources": ["*"],
     *     },
     *     {
     *         "actions": ["lambda:*"],
     *         "resources": ["*"],
     *     },
     * ])
     * combined = aws.iam.get_policy_document(source_policy_documents=[
     *     source_one.json,
     *     source_two.json,
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var sourceOne = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Actions = new[]
     *                 {
     *                     "ec2:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "UniqueSidOne",
     *                 Actions = new[]
     *                 {
     *                     "s3:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     *     var sourceTwo = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "UniqueSidTwo",
     *                 Actions = new[]
     *                 {
     *                     "iam:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Actions = new[]
     *                 {
     *                     "lambda:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     *     var combined = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         SourcePolicyDocuments = new[]
     *         {
     *             sourceOne.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *             sourceTwo.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * sourceOne, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Actions: []string{
     * "ec2:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * {
     * Sid: pulumi.StringRef("UniqueSidOne"),
     * Actions: []string{
     * "s3:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * sourceTwo, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Sid: pulumi.StringRef("UniqueSidTwo"),
     * Actions: []string{
     * "iam:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * {
     * Actions: []string{
     * "lambda:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * _, err = iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * SourcePolicyDocuments: interface{}{
     * sourceOne.Json,
     * sourceTwo.Json,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var sourceOne = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("ec2:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("UniqueSidOne")
     *                     .actions("s3:*")
     *                     .resources("*")
     *                     .build())
     *             .build());
     *         final var sourceTwo = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("UniqueSidTwo")
     *                     .actions("iam:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .actions("lambda:*")
     *                     .resources("*")
     *                     .build())
     *             .build());
     *         final var combined = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .sourcePolicyDocuments(
     *                 sourceOne.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()),
     *                 sourceTwo.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   sourceOne:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - actions:
     *               - ec2:*
     *             resources:
     *               - '*'
     *           - sid: UniqueSidOne
     *             actions:
     *               - s3:*
     *             resources:
     *               - '*'
     *   sourceTwo:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - sid: UniqueSidTwo
     *             actions:
     *               - iam:*
     *             resources:
     *               - '*'
     *           - actions:
     *               - lambda:*
     *             resources:
     *               - '*'
     *   combined:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         sourcePolicyDocuments:
     *           - ${sourceOne.json}
     *           - ${sourceTwo.json}
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.aws_iam_policy_document.combined.json` will evaluate to:
     * ```json
     * {
     *   "Version": "2012-10-17",
     *   "Statement": [
     *     {
     *       "Sid": "",
     *       "Effect": "Allow",
     *       "Action": "ec2:*",
     *       "Resource": "*"
     *     },
     *     {
     *       "Sid": "UniqueSidOne",
     *       "Effect": "Allow",
     *       "Action": "s3:*",
     *       "Resource": "*"
     *     },
     *     {
     *       "Sid": "UniqueSidTwo",
     *       "Effect": "Allow",
     *       "Action": "iam:*",
     *       "Resource": "*"
     *     },
     *     {
     *       "Sid": "",
     *       "Effect": "Allow",
     *       "Action": "lambda:*",
     *       "Resource": "*"
     *     }
     *   ]
     * }
     * ```
     * ### Example of Merging Override Documents
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const policyOne = aws.iam.getPolicyDocument({
     *     statements: [{
     *         sid: "OverridePlaceHolderOne",
     *         effect: "Allow",
     *         actions: ["s3:*"],
     *         resources: ["*"],
     *     }],
     * });
     * const policyTwo = aws.iam.getPolicyDocument({
     *     statements: [
     *         {
     *             effect: "Allow",
     *             actions: ["ec2:*"],
     *             resources: ["*"],
     *         },
     *         {
     *             sid: "OverridePlaceHolderTwo",
     *             effect: "Allow",
     *             actions: ["iam:*"],
     *             resources: ["*"],
     *         },
     *     ],
     * });
     * const policyThree = aws.iam.getPolicyDocument({
     *     statements: [{
     *         sid: "OverridePlaceHolderOne",
     *         effect: "Deny",
     *         actions: ["logs:*"],
     *         resources: ["*"],
     *     }],
     * });
     * const combined = Promise.all([policyOne, policyTwo, policyThree])&#46;then(([policyOne, policyTwo, policyThree]) => aws.iam.getPolicyDocument({
     *     overridePolicyDocuments: [
     *         policyOne.json,
     *         policyTwo.json,
     *         policyThree.json,
     *     ],
     *     statements: [{
     *         sid: "OverridePlaceHolderTwo",
     *         effect: "Deny",
     *         actions: ["*"],
     *         resources: ["*"],
     *     }],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * policy_one = aws.iam.get_policy_document(statements=[{
     *     "sid": "OverridePlaceHolderOne",
     *     "effect": "Allow",
     *     "actions": ["s3:*"],
     *     "resources": ["*"],
     * }])
     * policy_two = aws.iam.get_policy_document(statements=[
     *     {
     *         "effect": "Allow",
     *         "actions": ["ec2:*"],
     *         "resources": ["*"],
     *     },
     *     {
     *         "sid": "OverridePlaceHolderTwo",
     *         "effect": "Allow",
     *         "actions": ["iam:*"],
     *         "resources": ["*"],
     *     },
     * ])
     * policy_three = aws.iam.get_policy_document(statements=[{
     *     "sid": "OverridePlaceHolderOne",
     *     "effect": "Deny",
     *     "actions": ["logs:*"],
     *     "resources": ["*"],
     * }])
     * combined = aws.iam.get_policy_document(override_policy_documents=[
     *         policy_one.json,
     *         policy_two.json,
     *         policy_three.json,
     *     ],
     *     statements=[{
     *         "sid": "OverridePlaceHolderTwo",
     *         "effect": "Deny",
     *         "actions": ["*"],
     *         "resources": ["*"],
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var policyOne = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "OverridePlaceHolderOne",
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "s3:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     *     var policyTwo = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "ec2:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "OverridePlaceHolderTwo",
     *                 Effect = "Allow",
     *                 Actions = new[]
     *                 {
     *                     "iam:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     *     var policyThree = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "OverridePlaceHolderOne",
     *                 Effect = "Deny",
     *                 Actions = new[]
     *                 {
     *                     "logs:*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     *     var combined = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         OverridePolicyDocuments = new[]
     *         {
     *             policyOne.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *             policyTwo.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *             policyThree.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *         },
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "OverridePlaceHolderTwo",
     *                 Effect = "Deny",
     *                 Actions = new[]
     *                 {
     *                     "*",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * policyOne, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Sid: pulumi.StringRef("OverridePlaceHolderOne"),
     * Effect: pulumi.StringRef("Allow"),
     * Actions: []string{
     * "s3:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * policyTwo, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Effect: pulumi.StringRef("Allow"),
     * Actions: []string{
     * "ec2:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * {
     * Sid: pulumi.StringRef("OverridePlaceHolderTwo"),
     * Effect: pulumi.StringRef("Allow"),
     * Actions: []string{
     * "iam:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * policyThree, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Sid: pulumi.StringRef("OverridePlaceHolderOne"),
     * Effect: pulumi.StringRef("Deny"),
     * Actions: []string{
     * "logs:*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * _, err = iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * OverridePolicyDocuments: interface{}{
     * policyOne.Json,
     * policyTwo.Json,
     * policyThree.Json,
     * },
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Sid: pulumi.StringRef("OverridePlaceHolderTwo"),
     * Effect: pulumi.StringRef("Deny"),
     * Actions: []string{
     * "*",
     * },
     * Resources: []string{
     * "*",
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var policyOne = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceHolderOne")
     *                 .effect("Allow")
     *                 .actions("s3:*")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var policyTwo = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect("Allow")
     *                     .actions("ec2:*")
     *                     .resources("*")
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .sid("OverridePlaceHolderTwo")
     *                     .effect("Allow")
     *                     .actions("iam:*")
     *                     .resources("*")
     *                     .build())
     *             .build());
     *         final var policyThree = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceHolderOne")
     *                 .effect("Deny")
     *                 .actions("logs:*")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *         final var combined = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .overridePolicyDocuments(
     *                 policyOne.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()),
     *                 policyTwo.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()),
     *                 policyThree.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("OverridePlaceHolderTwo")
     *                 .effect("Deny")
     *                 .actions("*")
     *                 .resources("*")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   policyOne:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - sid: OverridePlaceHolderOne
     *             effect: Allow
     *             actions:
     *               - s3:*
     *             resources:
     *               - '*'
     *   policyTwo:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - effect: Allow
     *             actions:
     *               - ec2:*
     *             resources:
     *               - '*'
     *           - sid: OverridePlaceHolderTwo
     *             effect: Allow
     *             actions:
     *               - iam:*
     *             resources:
     *               - '*'
     *   policyThree:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - sid: OverridePlaceHolderOne
     *             effect: Deny
     *             actions:
     *               - logs:*
     *             resources:
     *               - '*'
     *   combined:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         overridePolicyDocuments:
     *           - ${policyOne.json}
     *           - ${policyTwo.json}
     *           - ${policyThree.json}
     *         statements:
     *           - sid: OverridePlaceHolderTwo
     *             effect: Deny
     *             actions:
     *               - '*'
     *             resources:
     *               - '*'
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.aws_iam_policy_document.combined.json` will evaluate to:
     * ```json
     * {
     *   "Version": "2012-10-17",
     *   "Statement": [
     *     {
     *       "Sid": "OverridePlaceholderTwo",
     *       "Effect": "Allow",
     *       "Action": "iam:*",
     *       "Resource": "*"
     *     },
     *     {
     *       "Sid": "OverridePlaceholderOne",
     *       "Effect": "Deny",
     *       "Action": "logs:*",
     *       "Resource": "*"
     *     },
     *     {
     *       "Sid": "",
     *       "Effect": "Allow",
     *       "Action": "ec2:*",
     *       "Resource": "*"
     *     },
     *   ]
     * }
     * ```
     * @param argument A collection of arguments for invoking getPolicyDocument.
     * @return A collection of values returned by getPolicyDocument.
     * */*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/
     */
    public suspend fun getPolicyDocument(argument: GetPolicyDocumentPlainArgs): GetPolicyDocumentResult =
        getPolicyDocumentResultToKotlin(getPolicyDocumentPlain(argument.toJava()).await())

    /**
     * @see [getPolicyDocument].
     * @param overrideJson
     * @param overridePolicyDocuments List of IAM policy documents that are merged together into the exported document. In merging, statements with non-blank `sid`s will override statements with the same `sid` from earlier documents in the list. Statements with non-blank `sid`s will also override statements with the same `sid` from `source_policy_documents`.  Non-overriding statements will be added to the exported document.
     * @param policyId ID for the policy document.
     * @param sourceJson
     * @param sourcePolicyDocuments List of IAM policy documents that are merged together into the exported document. Statements defined in `source_policy_documents` must have unique `sid`s. Statements with the same `sid` from `override_policy_documents` will override source statements.
     * @param statements Configuration block for a policy statement. Detailed below.
     * @param version IAM policy document version. Valid values are `2008-10-17` and `2012-10-17`. Defaults to `2012-10-17`. For more information, see the [AWS IAM User Guide](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_version.html).
     * @return A collection of values returned by getPolicyDocument.
     */
    public suspend fun getPolicyDocument(
        overrideJson: String? = null,
        overridePolicyDocuments: List<String>? = null,
        policyId: String? = null,
        sourceJson: String? = null,
        sourcePolicyDocuments: List<String>? = null,
        statements: List<GetPolicyDocumentStatement>? = null,
        version: String? = null,
    ): GetPolicyDocumentResult {
        val argument = GetPolicyDocumentPlainArgs(
            overrideJson = overrideJson,
            overridePolicyDocuments = overridePolicyDocuments,
            policyId = policyId,
            sourceJson = sourceJson,
            sourcePolicyDocuments = sourcePolicyDocuments,
            statements = statements,
            version = version,
        )
        return getPolicyDocumentResultToKotlin(getPolicyDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicyDocument].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetPolicyDocumentPlainArgs].
     * @return A collection of values returned by getPolicyDocument.
     */
    public suspend fun getPolicyDocument(argument: suspend GetPolicyDocumentPlainArgsBuilder.() -> Unit): GetPolicyDocumentResult {
        val builder = GetPolicyDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyDocumentResultToKotlin(getPolicyDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * Runs a simulation of the IAM policies of a particular principal against a given hypothetical request.
     * You can use this data source in conjunction with
     * Preconditions and Postconditions so that your configuration can test either whether it should have sufficient access to do its own work, or whether policies your configuration declares itself are sufficient for their intended use elsewhere.
     * > **Note:** Correctly using this data source requires familiarity with various details of AWS Identity and Access Management, and how various AWS services integrate with it. For general information on the AWS IAM policy simulator, see [Testing IAM policies with the IAM policy simulator](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html). This data source wraps the `iam:SimulatePrincipalPolicy` API action described on that page.
     * ## Example Usage
     * ### Self Access-checking Example
     * The following example raises an error if the credentials passed to the AWS provider do not have access to perform the three actions `s3:GetObject`, `s3:PutObject`, and `s3:DeleteObject` on the S3 bucket with the given ARN.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getCallerIdentity({});
     * const s3ObjectAccess = current.then(current => aws.iam.getPrincipalPolicySimulation({
     *     actionNames: [
     *         "s3:GetObject",
     *         "s3:PutObject",
     *         "s3:DeleteObject",
     *     ],
     *     policySourceArn: current.arn,
     *     resourceArns: ["arn:aws:s3:::my-test-bucket"],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_caller_identity()
     * s3_object_access = aws.iam.get_principal_policy_simulation(action_names=[
     *         "s3:GetObject",
     *         "s3:PutObject",
     *         "s3:DeleteObject",
     *     ],
     *     policy_source_arn=current.arn,
     *     resource_arns=["arn:aws:s3:::my-test-bucket"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetCallerIdentity.Invoke();
     *     var s3ObjectAccess = Aws.Iam.GetPrincipalPolicySimulation.Invoke(new()
     *     {
     *         ActionNames = new[]
     *         {
     *             "s3:GetObject",
     *             "s3:PutObject",
     *             "s3:DeleteObject",
     *         },
     *         PolicySourceArn = current.Apply(getCallerIdentityResult => getCallerIdentityResult.Arn),
     *         ResourceArns = new[]
     *         {
     *             "arn:aws:s3:::my-test-bucket",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = iam.LookupPrincipalPolicySimulation(ctx, &iam.LookupPrincipalPolicySimulationArgs{
     * 			ActionNames: []string{
     * 				"s3:GetObject",
     * 				"s3:PutObject",
     * 				"s3:DeleteObject",
     * 			},
     * 			PolicySourceArn: current.Arn,
     * 			ResourceArns: []string{
     * 				"arn:aws:s3:::my-test-bucket",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPrincipalPolicySimulationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         final var s3ObjectAccess = IamFunctions.getPrincipalPolicySimulation(GetPrincipalPolicySimulationArgs.builder()
     *             .actionNames(
     *                 "s3:GetObject",
     *                 "s3:PutObject",
     *                 "s3:DeleteObject")
     *             .policySourceArn(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()))
     *             .resourceArns("arn:aws:s3:::my-test-bucket")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getCallerIdentity
     *       Arguments: {}
     *   s3ObjectAccess:
     *     fn::invoke:
     *       Function: aws:iam:getPrincipalPolicySimulation
     *       Arguments:
     *         actionNames:
     *           - s3:GetObject
     *           - s3:PutObject
     *           - s3:DeleteObject
     *         policySourceArn: ${current.arn}
     *         resourceArns:
     *           - arn:aws:s3:::my-test-bucket
     * ```
     * <!--End PulumiCodeChooser -->
     * If you intend to use this data source to quickly raise an error when the given credentials are insufficient then you must use `depends_on` inside any resource which would require those credentials, to ensure that the policy check will run first:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = new aws.s3.BucketObject("example", {bucket: "my-test-bucket"}, {
     *     dependsOn: [s3ObjectAccess],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.s3.BucketObject("example", bucket="my-test-bucket",
     * opts = pulumi.ResourceOptions(depends_on=[s3_object_access]))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = new Aws.S3.BucketObject("example", new()
     *     {
     *         Bucket = "my-test-bucket",
     *     }, new CustomResourceOptions
     *     {
     *         DependsOn =
     *         {
     *             s3ObjectAccess,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := s3.NewBucketObject(ctx, "example", &s3.BucketObjectArgs{
     * 			Bucket: pulumi.Any("my-test-bucket"),
     * 		}, pulumi.DependsOn([]pulumi.Resource{
     * 			s3ObjectAccess,
     * 		}))
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.s3.BucketObject;
     * import com.pulumi.aws.s3.BucketObjectArgs;
     * import com.pulumi.resources.CustomResourceOptions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var example = new BucketObject("example", BucketObjectArgs.builder()
     *             .bucket("my-test-bucket")
     *             .build(), CustomResourceOptions.builder()
     *                 .dependsOn(s3ObjectAccess)
     *                 .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:s3:BucketObject
     *     properties:
     *       bucket: my-test-bucket
     *     options:
     *       dependson:
     *         - ${s3ObjectAccess}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Testing the Effect of a Declared Policy
     * The following example declares an S3 bucket and a user that should have access to the bucket, and then uses `aws.iam.getPrincipalPolicySimulation` to verify that the user does indeed have access to perform needed operations against the bucket.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getCallerIdentity({});
     * const example = new aws.iam.User("example", {name: "example"});
     * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "my-test-bucket"});
     * const s3Access = new aws.iam.UserPolicy("s3_access", {
     *     name: "example_s3_access",
     *     user: example.name,
     *     policy: pulumi.jsonStringify({
     *         Version: "2012-10-17",
     *         Statement: [{
     *             Action: "s3:GetObject",
     *             Effect: "Allow",
     *             Resource: exampleBucketV2.arn,
     *         }],
     *     }),
     * });
     * const accountAccess = new aws.s3.BucketPolicy("account_access", {
     *     bucket: exampleBucketV2.bucket,
     *     policy: pulumi.jsonStringify({
     *         Version: "2012-10-17",
     *         Statement: [{
     *             Action: "s3:*",
     *             Effect: "Allow",
     *             Principal: {
     *                 AWS: current.then(current => current.accountId),
     *             },
     *             Resource: [
     *                 exampleBucketV2.arn,
     *                 pulumi.interpolate`${exampleBucketV2.arn}/*`,
     *             ],
     *         }],
     *     }),
     * });
     * const s3ObjectAccess = aws.iam.getPrincipalPolicySimulationOutput({
     *     actionNames: ["s3:GetObject"],
     *     policySourceArn: example.arn,
     *     resourceArns: [exampleBucketV2&#46;arn],
     *     resourcePolicyJson: accountAccess.policy,
     * });
     * ```
     * ```python
     * import pulumi
     * import json
     * import pulumi_aws as aws
     * current = aws.get_caller_identity()
     * example = aws.iam.User("example", name="example")
     * example_bucket_v2 = aws.s3.BucketV2("example", bucket="my-test-bucket")
     * s3_access = aws.iam.UserPolicy("s3_access",
     *     name="example_s3_access",
     *     user=example.name,
     *     policy=pulumi.Output.json_dumps({
     *         "Version": "2012-10-17",
     *         "Statement": [{
     *             "Action": "s3:GetObject",
     *             "Effect": "Allow",
     *             "Resource": example_bucket_v2.arn,
     *         }],
     *     }))
     * account_access = aws.s3.BucketPolicy("account_access",
     *     bucket=example_bucket_v2.bucket,
     *     policy=pulumi.Output.json_dumps({
     *         "Version": "2012-10-17",
     *         "Statement": [{
     *             "Action": "s3:*",
     *             "Effect": "Allow",
     *             "Principal": {
     *                 "AWS": current.account_id,
     *             },
     *             "Resource": [
     *                 example_bucket_v2.arn,
     *                 example_bucket_v2.arn.apply(lambda arn: f"{arn}/*"),
     *             ],
     *         }],
     *     }))
     * s3_object_access = aws.iam.get_principal_policy_simulation_output(action_names=["s3:GetObject"],
     *     policy_source_arn=example.arn,
     *     resource_arns=[example_bucket_v2&#46;arn],
     *     resource_policy_json=account_access.policy)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using System.Text.Json;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetCallerIdentity.Invoke();
     *     var example = new Aws.Iam.User("example", new()
     *     {
     *         Name = "example",
     *     });
     *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
     *     {
     *         Bucket = "my-test-bucket",
     *     });
     *     var s3Access = new Aws.Iam.UserPolicy("s3_access", new()
     *     {
     *         Name = "example_s3_access",
     *         User = example.Name,
     *         Policy = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
     *         {
     *             ["Version"] = "2012-10-17",
     *             ["Statement"] = new[]
     *             {
     *                 new Dictionary<string, object?>
     *                 {
     *                     ["Action"] = "s3:GetObject",
     *                     ["Effect"] = "Allow",
     *                     ["Resource"] = exampleBucketV2.Arn,
     *                 },
     *             },
     *         })),
     *     });
     *     var accountAccess = new Aws.S3.BucketPolicy("account_access", new()
     *     {
     *         Bucket = exampleBucketV2.Bucket,
     *         Policy = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
     *         {
     *             ["Version"] = "2012-10-17",
     *             ["Statement"] = new[]
     *             {
     *                 new Dictionary<string, object?>
     *                 {
     *                     ["Action"] = "s3:*",
     *                     ["Effect"] = "Allow",
     *                     ["Principal"] = new Dictionary<string, object?>
     *                     {
     *                         ["AWS"] = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
     *                     },
     *                     ["Resource"] = new[]
     *                     {
     *                         exampleBucketV2.Arn,
     *                         exampleBucketV2.Arn.Apply(arn => $"{arn}/*"),
     *                     },
     *                 },
     *             },
     *         })),
     *     });
     *     var s3ObjectAccess = Aws.Iam.GetPrincipalPolicySimulation.Invoke(new()
     *     {
     *         ActionNames = new[]
     *         {
     *             "s3:GetObject",
     *         },
     *         PolicySourceArn = example.Arn,
     *         ResourceArns = new[]
     *         {
     *             exampleBucketV2.Arn,
     *         },
     *         ResourcePolicyJson = accountAccess.Policy,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"encoding/json"
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		example, err := iam.NewUser(ctx, "example", &iam.UserArgs{
     * 			Name: pulumi.String("example"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
     * 			Bucket: pulumi.String("my-test-bucket"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = iam.NewUserPolicy(ctx, "s3_access", &iam.UserPolicyArgs{
     * 			Name: pulumi.String("example_s3_access"),
     * 			User: example.Name,
     * 			Policy: exampleBucketV2.Arn.ApplyT(func(arn string) (pulumi.String, error) {
     * 				var _zero pulumi.String
     * 				tmpJSON0, err := json.Marshal(map[string]interface{}{
     * 					"Version": "2012-10-17",
     * 					"Statement": []map[string]interface{}{
     * 						map[string]interface{}{
     * 							"Action":   "s3:GetObject",
     * 							"Effect":   "Allow",
     * 							"Resource": arn,
     * 						},
     * 					},
     * 				})
     * 				if err != nil {
     * 					return _zero, err
     * 				}
     * 				json0 := string(tmpJSON0)
     * 				return pulumi.String(json0), nil
     * 			}).(pulumi.StringOutput),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		accountAccess, err := s3.NewBucketPolicy(ctx, "account_access", &s3.BucketPolicyArgs{
     * 			Bucket: exampleBucketV2.Bucket,
     * 			Policy: pulumi.All(exampleBucketV2.Arn, exampleBucketV2.Arn).ApplyT(func(_args []interface{}) (string, error) {
     * 				exampleBucketV2Arn := _args[0].(string)
     * 				exampleBucketV2Arn1 := _args[1].(string)
     * 				var _zero string
     * 				tmpJSON1, err := json.Marshal(map[string]interface{}{
     * 					"Version": "2012-10-17",
     * 					"Statement": []map[string]interface{}{
     * 						map[string]interface{}{
     * 							"Action": "s3:*",
     * 							"Effect": "Allow",
     * 							"Principal": map[string]interface{}{
     * 								"AWS": current.AccountId,
     * 							},
     * 							"Resource": []string{
     * 								exampleBucketV2Arn,
     * 								fmt.Sprintf("%v/*", exampleBucketV2Arn1),
     * 							},
     * 						},
     * 					},
     * 				})
     * 				if err != nil {
     * 					return _zero, err
     * 				}
     * 				json1 := string(tmpJSON1)
     * 				return json1, nil
     * 			}).(pulumi.StringOutput),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = iam.LookupPrincipalPolicySimulationOutput(ctx, iam.GetPrincipalPolicySimulationOutputArgs{
     * 			ActionNames: pulumi.StringArray{
     * 				pulumi.String("s3:GetObject"),
     * 			},
     * 			PolicySourceArn: example.Arn,
     * 			ResourceArns: pulumi.StringArray{
     * 				exampleBucketV2.Arn,
     * 			},
     * 			ResourcePolicyJson: accountAccess.Policy,
     * 		}, nil)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import com.pulumi.aws.iam.User;
     * import com.pulumi.aws.iam.UserArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketV2Args;
     * import com.pulumi.aws.iam.UserPolicy;
     * import com.pulumi.aws.iam.UserPolicyArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPrincipalPolicySimulationArgs;
     * import static com.pulumi.codegen.internal.Serialization.*;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         var example = new User("example", UserArgs.builder()
     *             .name("example")
     *             .build());
     *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
     *             .bucket("my-test-bucket")
     *             .build());
     *         var s3Access = new UserPolicy("s3Access", UserPolicyArgs.builder()
     *             .name("example_s3_access")
     *             .user(example.name())
     *             .policy(exampleBucketV2.arn().applyValue(arn -> serializeJson(
     *                 jsonObject(
     *                     jsonProperty("Version", "2012-10-17"),
     *                     jsonProperty("Statement", jsonArray(jsonObject(
     *                         jsonProperty("Action", "s3:GetObject"),
     *                         jsonProperty("Effect", "Allow"),
     *                         jsonProperty("Resource", arn)
     *                     )))
     *                 ))))
     *             .build());
     *         var accountAccess = new BucketPolicy("accountAccess", BucketPolicyArgs.builder()
     *             .bucket(exampleBucketV2.bucket())
     *             .policy(Output.tuple(exampleBucketV2.arn(), exampleBucketV2.arn()).applyValue(values -> {
     *                 var exampleBucketV2Arn = values.t1;
     *                 var exampleBucketV2Arn1 = values.t2;
     *                 return serializeJson(
     *                     jsonObject(
     *                         jsonProperty("Version", "2012-10-17"),
     *                         jsonProperty("Statement", jsonArray(jsonObject(
     *                             jsonProperty("Action", "s3:*"),
     *                             jsonProperty("Effect", "Allow"),
     *                             jsonProperty("Principal", jsonObject(
     *                                 jsonProperty("AWS", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
     *                             )),
     *                             jsonProperty("Resource", jsonArray(
     *                                 exampleBucketV2Arn,
     *                                 String.format("%s/*", exampleBucketV2Arn1)
     *                             ))
     *                         )))
     *                     ));
     *             }))
     *             .build());
     *         final var s3ObjectAccess = IamFunctions.getPrincipalPolicySimulation(GetPrincipalPolicySimulationArgs.builder()
     *             .actionNames("s3:GetObject")
     *             .policySourceArn(example.arn())
     *             .resourceArns(exampleBucketV2.arn())
     *             .resourcePolicyJson(accountAccess.policy())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:iam:User
     *     properties:
     *       name: example
     *   exampleBucketV2:
     *     type: aws:s3:BucketV2
     *     name: example
     *     properties:
     *       bucket: my-test-bucket
     *   s3Access:
     *     type: aws:iam:UserPolicy
     *     name: s3_access
     *     properties:
     *       name: example_s3_access
     *       user: ${example.name}
     *       policy:
     *         fn::toJSON:
     *           Version: 2012-10-17
     *           Statement:
     *             - Action: s3:GetObject
     *               Effect: Allow
     *               Resource: ${exampleBucketV2.arn}
     *   accountAccess:
     *     type: aws:s3:BucketPolicy
     *     name: account_access
     *     properties:
     *       bucket: ${exampleBucketV2.bucket}
     *       policy:
     *         fn::toJSON:
     *           Version: 2012-10-17
     *           Statement:
     *             - Action: s3:*
     *               Effect: Allow
     *               Principal:
     *                 AWS: ${current.accountId}
     *               Resource:
     *                 - ${exampleBucketV2.arn}
     *                 - ${exampleBucketV2.arn}/*
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getCallerIdentity
     *       Arguments: {}
     *   s3ObjectAccess:
     *     fn::invoke:
     *       Function: aws:iam:getPrincipalPolicySimulation
     *       Arguments:
     *         actionNames:
     *           - s3:GetObject
     *         policySourceArn: ${example.arn}
     *         resourceArns:
     *           - ${exampleBucketV2.arn}
     *         resourcePolicyJson: ${accountAccess.policy}
     * ```
     * <!--End PulumiCodeChooser -->
     * When using `aws.iam.getPrincipalPolicySimulation` to test the effect of a policy declared elsewhere in the same configuration, it's important to use `depends_on` to make sure that the needed policy has been fully created or updated before running the simulation.
     * @param argument A collection of arguments for invoking getPrincipalPolicySimulation.
     * @return A collection of values returned by getPrincipalPolicySimulation.
     * */*/*/*/*/*/
     */
    public suspend fun getPrincipalPolicySimulation(argument: GetPrincipalPolicySimulationPlainArgs): GetPrincipalPolicySimulationInvokeResult =
        getPrincipalPolicySimulationInvokeResultToKotlin(getPrincipalPolicySimulationPlain(argument.toJava()).await())

    /**
     * @see [getPrincipalPolicySimulation].
     * @param actionNames A set of IAM action names to run simulations for. Each entry in this set adds an additional hypothetical request to the simulation.
     * Action names consist of a service prefix and an action verb separated by a colon, such as `s3:GetObject`. Refer to [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to see the full set of possible IAM action names across all AWS services.
     * @param additionalPoliciesJsons A set of additional principal policy documents to include in the simulation. The simulator will behave as if each of these policies were associated with the object specified in `policy_source_arn`, allowing you to test the effect of hypothetical policies not yet created.
     * @param callerArn The ARN of an user that will appear as the "caller" of the simulated requests. If you do not specify `caller_arn` then the simulation will use the `policy_source_arn` instead, if it contains a user ARN.
     * @param contexts Each `context` block defines an entry in the table of additional context keys in the simulated request.
     * IAM uses context keys for both custom conditions and for interpolating dynamic request-specific values into policy values. If you use policies that include those features then you will need to provide suitable example values for those keys to achieve a realistic simulation.
     * @param permissionsBoundaryPoliciesJsons A set of [permissions boundary policy documents](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) to include in the simulation.
     * @param policySourceArn The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the IAM user, group, or role whose policies will be included in the simulation.
     * You must closely match the form of the real service request you are simulating in order to achieve a realistic result. You can use the following additional arguments to specify other characteristics of the simulated requests:
     * @param resourceArns A set of ARNs of resources to include in the simulation.
     * This argument is important for actions that have either required or optional resource types listed in [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html), and you must provide ARNs that identify AWS objects of the appropriate types for the chosen actions.
     * The policy simulator only automatically loads policies associated with the `policy_source_arn`, so if your given resources have their own resource-level policy then you'll also need to provide that explicitly using the `resource_policy_json` argument to achieve a realistic simulation.
     * @param resourceHandlingOption Specifies a special simulation type to run. Some EC2 actions require special simulation behaviors and a particular set of resource ARNs to achieve a realistic result.
     * For more details, see the `ResourceHandlingOption` request parameter for [the underlying `iam:SimulatePrincipalPolicy` action](https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html).
     * @param resourceOwnerAccountId An AWS account ID to use for any resource ARN in `resource_arns` that doesn't include its own AWS account ID. If unspecified, the simulator will use the account ID from the `caller_arn` argument as a placeholder.
     * @param resourcePolicyJson An IAM policy document representing the resource-level policy of all of the resources specified in `resource_arns`.
     * The policy simulator cannot automatically load policies that are associated with individual resources, as described in the documentation for `resource_arns` above.
     * @return A collection of values returned by getPrincipalPolicySimulation.
     */
    public suspend fun getPrincipalPolicySimulation(
        actionNames: List<String>,
        additionalPoliciesJsons: List<String>? = null,
        callerArn: String? = null,
        contexts: List<GetPrincipalPolicySimulationContext>? = null,
        permissionsBoundaryPoliciesJsons: List<String>? = null,
        policySourceArn: String,
        resourceArns: List<String>? = null,
        resourceHandlingOption: String? = null,
        resourceOwnerAccountId: String? = null,
        resourcePolicyJson: String? = null,
    ): GetPrincipalPolicySimulationInvokeResult {
        val argument = GetPrincipalPolicySimulationPlainArgs(
            actionNames = actionNames,
            additionalPoliciesJsons = additionalPoliciesJsons,
            callerArn = callerArn,
            contexts = contexts,
            permissionsBoundaryPoliciesJsons = permissionsBoundaryPoliciesJsons,
            policySourceArn = policySourceArn,
            resourceArns = resourceArns,
            resourceHandlingOption = resourceHandlingOption,
            resourceOwnerAccountId = resourceOwnerAccountId,
            resourcePolicyJson = resourcePolicyJson,
        )
        return getPrincipalPolicySimulationInvokeResultToKotlin(getPrincipalPolicySimulationPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrincipalPolicySimulation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetPrincipalPolicySimulationPlainArgs].
     * @return A collection of values returned by getPrincipalPolicySimulation.
     */
    public suspend fun getPrincipalPolicySimulation(argument: suspend GetPrincipalPolicySimulationPlainArgsBuilder.() -> Unit): GetPrincipalPolicySimulationInvokeResult {
        val builder = GetPrincipalPolicySimulationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrincipalPolicySimulationInvokeResultToKotlin(getPrincipalPolicySimulationPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM role. By using this data source, you can reference IAM role
     * properties without having to hard code ARNs as input.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getRole({
     *     name: "an_example_role_name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_role(name="an_example_role_name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetRole.Invoke(new()
     *     {
     *         Name = "an_example_role_name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.LookupRole(ctx, &iam.LookupRoleArgs{
     * 			Name: "an_example_role_name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRoleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getRole(GetRoleArgs.builder()
     *             .name("an_example_role_name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getRole
     *       Arguments:
     *         name: an_example_role_name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRole.
     * @return A collection of values returned by getRole.
     */
    public suspend fun getRole(argument: GetRolePlainArgs): GetRoleResult =
        getRoleResultToKotlin(getRolePlain(argument.toJava()).await())

    /**
     * @see [getRole].
     * @param name Friendly IAM role name to match.
     * @param tags Tags attached to the role.
     * @return A collection of values returned by getRole.
     */
    public suspend fun getRole(name: String, tags: Map<String, String>? = null): GetRoleResult {
        val argument = GetRolePlainArgs(
            name = name,
            tags = tags,
        )
        return getRoleResultToKotlin(getRolePlain(argument.toJava()).await())
    }

    /**
     * @see [getRole].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetRolePlainArgs].
     * @return A collection of values returned by getRole.
     */
    public suspend fun getRole(argument: suspend GetRolePlainArgsBuilder.() -> Unit): GetRoleResult {
        val builder = GetRolePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoleResultToKotlin(getRolePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and Names of IAM Roles.
     * ## Example Usage
     * ### All roles in an account
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const roles = aws.iam.getRoles({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * roles = aws.iam.get_roles()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var roles = Aws.Iam.GetRoles.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetRoles(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var roles = IamFunctions.getRoles();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   roles:
     *     fn::invoke:
     *       Function: aws:iam:getRoles
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Roles filtered by name regex
     * Roles whose role-name contains `project`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const roles = aws.iam.getRoles({
     *     nameRegex: ".*project.*",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * roles = aws.iam.get_roles(name_regex=".*project.*")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var roles = Aws.Iam.GetRoles.Invoke(new()
     *     {
     *         NameRegex = ".*project.*",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetRoles(ctx, &iam.GetRolesArgs{
     * 			NameRegex: pulumi.StringRef(".*project.*"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var roles = IamFunctions.getRoles(GetRolesArgs.builder()
     *             .nameRegex(".*project.*")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   roles:
     *     fn::invoke:
     *       Function: aws:iam:getRoles
     *       Arguments:
     *         nameRegex: .*project.*
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Roles filtered by path prefix
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const roles = aws.iam.getRoles({
     *     pathPrefix: "/custom-path",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * roles = aws.iam.get_roles(path_prefix="/custom-path")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var roles = Aws.Iam.GetRoles.Invoke(new()
     *     {
     *         PathPrefix = "/custom-path",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetRoles(ctx, &iam.GetRolesArgs{
     * 			PathPrefix: pulumi.StringRef("/custom-path"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var roles = IamFunctions.getRoles(GetRolesArgs.builder()
     *             .pathPrefix("/custom-path")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   roles:
     *     fn::invoke:
     *       Function: aws:iam:getRoles
     *       Arguments:
     *         pathPrefix: /custom-path
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Roles provisioned by AWS SSO
     * Roles in the account filtered by path prefix
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const roles = aws.iam.getRoles({
     *     pathPrefix: "/aws-reserved/sso.amazonaws.com/",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * roles = aws.iam.get_roles(path_prefix="/aws-reserved/sso.amazonaws.com/")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var roles = Aws.Iam.GetRoles.Invoke(new()
     *     {
     *         PathPrefix = "/aws-reserved/sso.amazonaws.com/",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetRoles(ctx, &iam.GetRolesArgs{
     * 			PathPrefix: pulumi.StringRef("/aws-reserved/sso.amazonaws.com/"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var roles = IamFunctions.getRoles(GetRolesArgs.builder()
     *             .pathPrefix("/aws-reserved/sso.amazonaws.com/")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   roles:
     *     fn::invoke:
     *       Function: aws:iam:getRoles
     *       Arguments:
     *         pathPrefix: /aws-reserved/sso.amazonaws.com/
     * ```
     * <!--End PulumiCodeChooser -->
     * Specific role in the account filtered by name regex and path prefix
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const roles = aws.iam.getRoles({
     *     nameRegex: "AWSReservedSSO_permission_set_name_.*",
     *     pathPrefix: "/aws-reserved/sso.amazonaws.com/",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * roles = aws.iam.get_roles(name_regex="AWSReservedSSO_permission_set_name_.*",
     *     path_prefix="/aws-reserved/sso.amazonaws.com/")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var roles = Aws.Iam.GetRoles.Invoke(new()
     *     {
     *         NameRegex = "AWSReservedSSO_permission_set_name_.*",
     *         PathPrefix = "/aws-reserved/sso.amazonaws.com/",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetRoles(ctx, &iam.GetRolesArgs{
     * 			NameRegex:  pulumi.StringRef("AWSReservedSSO_permission_set_name_.*"),
     * 			PathPrefix: pulumi.StringRef("/aws-reserved/sso.amazonaws.com/"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetRolesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var roles = IamFunctions.getRoles(GetRolesArgs.builder()
     *             .nameRegex("AWSReservedSSO_permission_set_name_.*")
     *             .pathPrefix("/aws-reserved/sso.amazonaws.com/")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   roles:
     *     fn::invoke:
     *       Function: aws:iam:getRoles
     *       Arguments:
     *         nameRegex: AWSReservedSSO_permission_set_name_.*
     *         pathPrefix: /aws-reserved/sso.amazonaws.com/
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRoles.
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(argument: GetRolesPlainArgs): GetRolesResult =
        getRolesResultToKotlin(getRolesPlain(argument.toJava()).await())

    /**
     * @see [getRoles].
     * @param nameRegex Regex string to apply to the IAM roles list returned by AWS. This allows more advanced filtering not supported from the AWS API. This filtering is done locally on what AWS returns, and could have a performance impact if the result is large. Combine this with other options to narrow down the list AWS returns.
     * @param pathPrefix Path prefix for filtering the results. For example, the prefix `/application_abc/component_xyz/` gets all roles whose path starts with `/application_abc/component_xyz/`. If it is not included, it defaults to a slash (`/`), listing all roles. For more details, check out [list-roles in the AWS CLI reference][1].
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(nameRegex: String? = null, pathPrefix: String? = null): GetRolesResult {
        val argument = GetRolesPlainArgs(
            nameRegex = nameRegex,
            pathPrefix = pathPrefix,
        )
        return getRolesResultToKotlin(getRolesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRoles].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetRolesPlainArgs].
     * @return A collection of values returned by getRoles.
     */
    public suspend fun getRoles(argument: suspend GetRolesPlainArgsBuilder.() -> Unit): GetRolesResult {
        val builder = GetRolesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRolesResultToKotlin(getRolesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM SAML provider. This will allow you to easily retrieve the metadata
     * document of an existing SAML provider.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getSamlProvider({
     *     arn: "arn:aws:iam::123456789:saml-provider/myprovider",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_saml_provider(arn="arn:aws:iam::123456789:saml-provider/myprovider")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetSamlProvider.Invoke(new()
     *     {
     *         Arn = "arn:aws:iam::123456789:saml-provider/myprovider",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.LookupSamlProvider(ctx, &iam.LookupSamlProviderArgs{
     * 			Arn: "arn:aws:iam::123456789:saml-provider/myprovider",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetSamlProviderArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getSamlProvider(GetSamlProviderArgs.builder()
     *             .arn("arn:aws:iam::123456789:saml-provider/myprovider")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getSamlProvider
     *       Arguments:
     *         arn: arn:aws:iam::123456789:saml-provider/myprovider
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSamlProvider.
     * @return A collection of values returned by getSamlProvider.
     */
    public suspend fun getSamlProvider(argument: GetSamlProviderPlainArgs): GetSamlProviderResult =
        getSamlProviderResultToKotlin(getSamlProviderPlain(argument.toJava()).await())

    /**
     * @see [getSamlProvider].
     * @param arn ARN assigned by AWS for the provider.
     * @param tags Tags attached to the SAML provider.
     * @return A collection of values returned by getSamlProvider.
     */
    public suspend fun getSamlProvider(arn: String, tags: Map<String, String>? = null): GetSamlProviderResult {
        val argument = GetSamlProviderPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getSamlProviderResultToKotlin(getSamlProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getSamlProvider].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetSamlProviderPlainArgs].
     * @return A collection of values returned by getSamlProvider.
     */
    public suspend fun getSamlProvider(argument: suspend GetSamlProviderPlainArgsBuilder.() -> Unit): GetSamlProviderResult {
        val builder = GetSamlProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSamlProviderResultToKotlin(getSamlProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to lookup information about IAM Server Certificates.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const my-domain = aws.iam.getServerCertificate({
     *     namePrefix: "my-domain.org",
     *     latest: true,
     * });
     * const elb = new aws.elb.LoadBalancer("elb", {
     *     name: "my-domain-elb",
     *     listeners: [{
     *         instancePort: 8000,
     *         instanceProtocol: "https",
     *         lbPort: 443,
     *         lbProtocol: "https",
     *         sslCertificateId: my_domain.then(my_domain => my_domain.arn),
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * my_domain = aws.iam.get_server_certificate(name_prefix="my-domain.org",
     *     latest=True)
     * elb = aws.elb.LoadBalancer("elb",
     *     name="my-domain-elb",
     *     listeners=[{
     *         "instance_port": 8000,
     *         "instance_protocol": "https",
     *         "lb_port": 443,
     *         "lb_protocol": "https",
     *         "ssl_certificate_id": my_domain.arn,
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var my_domain = Aws.Iam.GetServerCertificate.Invoke(new()
     *     {
     *         NamePrefix = "my-domain.org",
     *         Latest = true,
     *     });
     *     var elb = new Aws.Elb.LoadBalancer("elb", new()
     *     {
     *         Name = "my-domain-elb",
     *         Listeners = new[]
     *         {
     *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
     *             {
     *                 InstancePort = 8000,
     *                 InstanceProtocol = "https",
     *                 LbPort = 443,
     *                 LbProtocol = "https",
     *                 SslCertificateId = my_domain.Apply(my_domain => my_domain.Apply(getServerCertificateResult => getServerCertificateResult.Arn)),
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		my_domain, err := iam.LookupServerCertificate(ctx, &iam.LookupServerCertificateArgs{
     * 			NamePrefix: pulumi.StringRef("my-domain.org"),
     * 			Latest:     pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = elb.NewLoadBalancer(ctx, "elb", &elb.LoadBalancerArgs{
     * 			Name: pulumi.String("my-domain-elb"),
     * 			Listeners: elb.LoadBalancerListenerArray{
     * 				&elb.LoadBalancerListenerArgs{
     * 					InstancePort:     pulumi.Int(8000),
     * 					InstanceProtocol: pulumi.String("https"),
     * 					LbPort:           pulumi.Int(443),
     * 					LbProtocol:       pulumi.String("https"),
     * 					SslCertificateId: pulumi.String(my_domain.Arn),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetServerCertificateArgs;
     * import com.pulumi.aws.elb.LoadBalancer;
     * import com.pulumi.aws.elb.LoadBalancerArgs;
     * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var my-domain = IamFunctions.getServerCertificate(GetServerCertificateArgs.builder()
     *             .namePrefix("my-domain.org")
     *             .latest(true)
     *             .build());
     *         var elb = new LoadBalancer("elb", LoadBalancerArgs.builder()
     *             .name("my-domain-elb")
     *             .listeners(LoadBalancerListenerArgs.builder()
     *                 .instancePort(8000)
     *                 .instanceProtocol("https")
     *                 .lbPort(443)
     *                 .lbProtocol("https")
     *                 .sslCertificateId(my_domain.arn())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   elb:
     *     type: aws:elb:LoadBalancer
     *     properties:
     *       name: my-domain-elb
     *       listeners:
     *         - instancePort: 8000
     *           instanceProtocol: https
     *           lbPort: 443
     *           lbProtocol: https
     *           sslCertificateId: ${["my-domain"].arn}
     * variables:
     *   my-domain:
     *     fn::invoke:
     *       Function: aws:iam:getServerCertificate
     *       Arguments:
     *         namePrefix: my-domain.org
     *         latest: true
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServerCertificate.
     * @return A collection of values returned by getServerCertificate.
     */
    public suspend fun getServerCertificate(argument: GetServerCertificatePlainArgs): GetServerCertificateResult =
        getServerCertificateResultToKotlin(getServerCertificatePlain(argument.toJava()).await())

    /**
     * @see [getServerCertificate].
     * @param latest sort results by expiration date. returns the certificate with expiration date in furthest in the future.
     * @param name exact name of the cert to lookup
     * @param namePrefix prefix of cert to filter by
     * @param pathPrefix prefix of path to filter by
     * @return A collection of values returned by getServerCertificate.
     */
    public suspend fun getServerCertificate(
        latest: Boolean? = null,
        name: String? = null,
        namePrefix: String? = null,
        pathPrefix: String? = null,
    ): GetServerCertificateResult {
        val argument = GetServerCertificatePlainArgs(
            latest = latest,
            name = name,
            namePrefix = namePrefix,
            pathPrefix = pathPrefix,
        )
        return getServerCertificateResultToKotlin(getServerCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getServerCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetServerCertificatePlainArgs].
     * @return A collection of values returned by getServerCertificate.
     */
    public suspend fun getServerCertificate(argument: suspend GetServerCertificatePlainArgsBuilder.() -> Unit): GetServerCertificateResult {
        val builder = GetServerCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerCertificateResultToKotlin(getServerCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides information on the IAM source role of an STS assumed role. For non-role ARNs, this data source simply passes the ARN through in `issuer_arn`.
     * For some AWS resources, multiple types of principals are allowed in the same argument (e.g., IAM users and IAM roles). However, these arguments often do not allow assumed-role (i.e., STS, temporary credential) principals. Given an STS ARN, this data source provides the ARN for the source IAM role.
     * ## Example Usage
     * ### Basic Example
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getSessionContext({
     *     arn: "arn:aws:sts::123456789012:assumed-role/Audien-Heaven/MatyNoyes",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_session_context(arn="arn:aws:sts::123456789012:assumed-role/Audien-Heaven/MatyNoyes")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetSessionContext.Invoke(new()
     *     {
     *         Arn = "arn:aws:sts::123456789012:assumed-role/Audien-Heaven/MatyNoyes",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetSessionContext(ctx, &iam.GetSessionContextArgs{
     * 			Arn: "arn:aws:sts::123456789012:assumed-role/Audien-Heaven/MatyNoyes",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetSessionContextArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getSessionContext(GetSessionContextArgs.builder()
     *             .arn("arn:aws:sts::123456789012:assumed-role/Audien-Heaven/MatyNoyes")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getSessionContext
     *       Arguments:
     *         arn: arn:aws:sts::123456789012:assumed-role/Audien-Heaven/MatyNoyes
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Find the Runner's Source Role
     * Combined with `aws.getCallerIdentity`, you can get the current user's source IAM role ARN (`issuer_arn`) if you're using an assumed role. If you're not using an assumed role, the caller's (e.g., an IAM user's) ARN will simply be passed through. In environments where both IAM users and individuals using assumed roles need to apply the same configurations, this data source enables seamless use.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getCallerIdentity({});
     * const example = current.then(current => aws.iam.getSessionContext({
     *     arn: current.arn,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_caller_identity()
     * example = aws.iam.get_session_context(arn=current.arn)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetCallerIdentity.Invoke();
     *     var example = Aws.Iam.GetSessionContext.Invoke(new()
     *     {
     *         Arn = current.Apply(getCallerIdentityResult => getCallerIdentityResult.Arn),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = iam.GetSessionContext(ctx, &iam.GetSessionContextArgs{
     * 			Arn: current.Arn,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetSessionContextArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         final var example = IamFunctions.getSessionContext(GetSessionContextArgs.builder()
     *             .arn(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getCallerIdentity
     *       Arguments: {}
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getSessionContext
     *       Arguments:
     *         arn: ${current.arn}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSessionContext.
     * @return A collection of values returned by getSessionContext.
     */
    public suspend fun getSessionContext(argument: GetSessionContextPlainArgs): GetSessionContextResult =
        getSessionContextResultToKotlin(getSessionContextPlain(argument.toJava()).await())

    /**
     * @see [getSessionContext].
     * @param arn ARN for an assumed role.
     * > If `arn` is a non-role ARN, Pulumi gives no error and `issuer_arn` will be equal to the `arn` value. For STS assumed-role ARNs, Pulumi gives an error if the identified IAM role does not exist.
     * @return A collection of values returned by getSessionContext.
     */
    public suspend fun getSessionContext(arn: String): GetSessionContextResult {
        val argument = GetSessionContextPlainArgs(
            arn = arn,
        )
        return getSessionContextResultToKotlin(getSessionContextPlain(argument.toJava()).await())
    }

    /**
     * @see [getSessionContext].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetSessionContextPlainArgs].
     * @return A collection of values returned by getSessionContext.
     */
    public suspend fun getSessionContext(argument: suspend GetSessionContextPlainArgsBuilder.() -> Unit): GetSessionContextResult {
        val builder = GetSessionContextPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSessionContextResultToKotlin(getSessionContextPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source can be used to fetch information about a specific
     * IAM user. By using this data source, you can reference IAM user
     * properties without having to hard code ARNs or unique IDs as input.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getUser({
     *     userName: "an_example_user_name",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_user(user_name="an_example_user_name")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetUser.Invoke(new()
     *     {
     *         UserName = "an_example_user_name",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.LookupUser(ctx, &iam.LookupUserArgs{
     * 			UserName: "an_example_user_name",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUserArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getUser(GetUserArgs.builder()
     *             .userName("an_example_user_name")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getUser
     *       Arguments:
     *         userName: an_example_user_name
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUser.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param tags Map of key-value pairs associated with the user.
     * @param userName Friendly IAM user name to match.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(tags: Map<String, String>? = null, userName: String): GetUserResult {
        val argument = GetUserPlainArgs(
            tags = tags,
            userName = userName,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a SSH public key associated with the specified IAM user.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.iam.getUserSshKey({
     *     encoding: "SSH",
     *     sshPublicKeyId: "APKARUZ32GUTKIGARLXE",
     *     username: "test-user",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.iam.get_user_ssh_key(encoding="SSH",
     *     ssh_public_key_id="APKARUZ32GUTKIGARLXE",
     *     username="test-user")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Iam.GetUserSshKey.Invoke(new()
     *     {
     *         Encoding = "SSH",
     *         SshPublicKeyId = "APKARUZ32GUTKIGARLXE",
     *         Username = "test-user",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetUserSshKey(ctx, &iam.GetUserSshKeyArgs{
     * 			Encoding:       "SSH",
     * 			SshPublicKeyId: "APKARUZ32GUTKIGARLXE",
     * 			Username:       "test-user",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUserSshKeyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = IamFunctions.getUserSshKey(GetUserSshKeyArgs.builder()
     *             .encoding("SSH")
     *             .sshPublicKeyId("APKARUZ32GUTKIGARLXE")
     *             .username("test-user")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:iam:getUserSshKey
     *       Arguments:
     *         encoding: SSH
     *         sshPublicKeyId: APKARUZ32GUTKIGARLXE
     *         username: test-user
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserSshKey.
     * @return A collection of values returned by getUserSshKey.
     */
    public suspend fun getUserSshKey(argument: GetUserSshKeyPlainArgs): GetUserSshKeyResult =
        getUserSshKeyResultToKotlin(getUserSshKeyPlain(argument.toJava()).await())

    /**
     * @see [getUserSshKey].
     * @param encoding Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use `SSH`. To retrieve the public key in PEM format, use `PEM`.
     * @param sshPublicKeyId Unique identifier for the SSH public key.
     * @param username Name of the IAM user associated with the SSH public key.
     * @return A collection of values returned by getUserSshKey.
     */
    public suspend fun getUserSshKey(
        encoding: String,
        sshPublicKeyId: String,
        username: String,
    ): GetUserSshKeyResult {
        val argument = GetUserSshKeyPlainArgs(
            encoding = encoding,
            sshPublicKeyId = sshPublicKeyId,
            username = username,
        )
        return getUserSshKeyResultToKotlin(getUserSshKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserSshKey].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetUserSshKeyPlainArgs].
     * @return A collection of values returned by getUserSshKey.
     */
    public suspend fun getUserSshKey(argument: suspend GetUserSshKeyPlainArgsBuilder.() -> Unit): GetUserSshKeyResult {
        val builder = GetUserSshKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserSshKeyResultToKotlin(getUserSshKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and Names of IAM Users.
     * ## Example Usage
     * ### All users in an account
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const users = aws.iam.getUsers({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * users = aws.iam.get_users()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var users = Aws.Iam.GetUsers.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetUsers(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var users = IamFunctions.getUsers();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   users:
     *     fn::invoke:
     *       Function: aws:iam:getUsers
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Users filtered by name regex
     * Users whose username contains `abc`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const users = aws.iam.getUsers({
     *     nameRegex: ".*abc.*",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * users = aws.iam.get_users(name_regex=".*abc.*")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var users = Aws.Iam.GetUsers.Invoke(new()
     *     {
     *         NameRegex = ".*abc.*",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetUsers(ctx, &iam.GetUsersArgs{
     * 			NameRegex: pulumi.StringRef(".*abc.*"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var users = IamFunctions.getUsers(GetUsersArgs.builder()
     *             .nameRegex(".*abc.*")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   users:
     *     fn::invoke:
     *       Function: aws:iam:getUsers
     *       Arguments:
     *         nameRegex: .*abc.*
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Users filtered by path prefix
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const users = aws.iam.getUsers({
     *     pathPrefix: "/custom-path",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * users = aws.iam.get_users(path_prefix="/custom-path")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var users = Aws.Iam.GetUsers.Invoke(new()
     *     {
     *         PathPrefix = "/custom-path",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iam.GetUsers(ctx, &iam.GetUsersArgs{
     * 			PathPrefix: pulumi.StringRef("/custom-path"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var users = IamFunctions.getUsers(GetUsersArgs.builder()
     *             .pathPrefix("/custom-path")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   users:
     *     fn::invoke:
     *       Function: aws:iam:getUsers
     *       Arguments:
     *         pathPrefix: /custom-path
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUsers.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: GetUsersPlainArgs): GetUsersResult =
        getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())

    /**
     * @see [getUsers].
     * @param nameRegex Regex string to apply to the IAM users list returned by AWS. This allows more advanced filtering not supported from the AWS API. This filtering is done locally on what AWS returns, and could have a performance impact if the result is large. Combine this with other options to narrow down the list AWS returns.
     * @param pathPrefix Path prefix for filtering the results. For example, the prefix `/division_abc/subdivision_xyz/` gets all users whose path starts with `/division_abc/subdivision_xyz/`. If it is not included, it defaults to a slash (`/`), listing all users. For more details, check out [list-users in the AWS CLI reference][1].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(nameRegex: String? = null, pathPrefix: String? = null): GetUsersResult {
        val argument = GetUsersPlainArgs(
            nameRegex = nameRegex,
            pathPrefix = pathPrefix,
        )
        return getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getUsers].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;iam&#46;kotlin&#46;inputs&#46;GetUsersPlainArgs].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: suspend GetUsersPlainArgsBuilder.() -> Unit): GetUsersResult {
        val builder = GetUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUsersResultToKotlin(getUsersPlain(builtArgument.toJava()).await())
    }
}
