@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [OpenIdConnectProvider].
 */
@PulumiTagMarker
public class OpenIdConnectProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OpenIdConnectProviderArgs = OpenIdConnectProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OpenIdConnectProviderArgsBuilder.() -> Unit) {
        val builder = OpenIdConnectProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OpenIdConnectProvider {
        val builtJavaResource = com.pulumi.aws.iam.OpenIdConnectProvider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OpenIdConnectProvider(builtJavaResource)
    }
}

/**
 * Provides an IAM OpenID Connect provider.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.iam.OpenIdConnectProvider("default", {
 *     url: "https://accounts.google.com",
 *     clientIdLists: ["266362248691-342342xasdasdasda-apps&#46;googleusercontent&#46;com"],
 *     thumbprintLists: ["cf23df2207d99a74fbe169e3eba035e633b65d94"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.iam.OpenIdConnectProvider("default",
 *     url="https://accounts.google.com",
 *     client_id_lists=["266362248691-342342xasdasdasda-apps&#46;googleusercontent&#46;com"],
 *     thumbprint_lists=["cf23df2207d99a74fbe169e3eba035e633b65d94"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Iam.OpenIdConnectProvider("default", new()
 *     {
 *         Url = "https://accounts.google.com",
 *         ClientIdLists = new[]
 *         {
 *             "266362248691-342342xasdasdasda-apps.googleusercontent.com",
 *         },
 *         ThumbprintLists = new[]
 *         {
 *             "cf23df2207d99a74fbe169e3eba035e633b65d94",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewOpenIdConnectProvider(ctx, "default", &iam.OpenIdConnectProviderArgs{
 * 			Url: pulumi.String("https://accounts.google.com"),
 * 			ClientIdLists: pulumi.StringArray{
 * 				pulumi.String("266362248691-342342xasdasdasda-apps.googleusercontent.com"),
 * 			},
 * 			ThumbprintLists: pulumi.StringArray{
 * 				pulumi.String("cf23df2207d99a74fbe169e3eba035e633b65d94"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.OpenIdConnectProvider;
 * import com.pulumi.aws.iam.OpenIdConnectProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new OpenIdConnectProvider("default", OpenIdConnectProviderArgs.builder()
 *             .url("https://accounts.google.com")
 *             .clientIdLists("266362248691-342342xasdasdasda-apps.googleusercontent.com")
 *             .thumbprintLists("cf23df2207d99a74fbe169e3eba035e633b65d94")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:iam:OpenIdConnectProvider
 *     properties:
 *       url: https://accounts.google.com
 *       clientIdLists:
 *         - 266362248691-342342xasdasdasda-apps.googleusercontent.com
 *       thumbprintLists:
 *         - cf23df2207d99a74fbe169e3eba035e633b65d94
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM OpenID Connect Providers using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:iam/openIdConnectProvider:OpenIdConnectProvider default arn:aws:iam::123456789012:oidc-provider/accounts.google.com
 * ```
 */
public class OpenIdConnectProvider internal constructor(
    override val javaResource: com.pulumi.aws.iam.OpenIdConnectProvider,
) : KotlinCustomResource(javaResource, OpenIdConnectProviderMapper) {
    /**
     * The ARN assigned by AWS for this provider.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A list of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that's sent as the client_id parameter on OAuth requests.)
     */
    public val clientIdLists: Output<List<String>>
        get() = javaResource.clientIdLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of resource tags for the IAM OIDC provider. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificate(s).
     */
    public val thumbprintLists: Output<List<String>>
        get() = javaResource.thumbprintLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The URL of the identity provider. Corresponds to the _iss_ claim.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object OpenIdConnectProviderMapper : ResourceMapper<OpenIdConnectProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.OpenIdConnectProvider::class == javaResource::class

    override fun map(javaResource: Resource): OpenIdConnectProvider =
        OpenIdConnectProvider(javaResource as com.pulumi.aws.iam.OpenIdConnectProvider)
}

/**
 * @see [OpenIdConnectProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OpenIdConnectProvider].
 */
public suspend fun openIdConnectProvider(
    name: String,
    block: suspend OpenIdConnectProviderResourceBuilder.() -> Unit,
): OpenIdConnectProvider {
    val builder = OpenIdConnectProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OpenIdConnectProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun openIdConnectProvider(name: String): OpenIdConnectProvider {
    val builder = OpenIdConnectProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
