@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.OpenIdConnectProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IAM OpenID Connect provider.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.iam.OpenIdConnectProvider("default", {
 *     url: "https://accounts.google.com",
 *     clientIdLists: ["266362248691-342342xasdasdasda-apps&#46;googleusercontent&#46;com"],
 *     thumbprintLists: ["cf23df2207d99a74fbe169e3eba035e633b65d94"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.iam.OpenIdConnectProvider("default",
 *     url="https://accounts.google.com",
 *     client_id_lists=["266362248691-342342xasdasdasda-apps&#46;googleusercontent&#46;com"],
 *     thumbprint_lists=["cf23df2207d99a74fbe169e3eba035e633b65d94"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Iam.OpenIdConnectProvider("default", new()
 *     {
 *         Url = "https://accounts.google.com",
 *         ClientIdLists = new[]
 *         {
 *             "266362248691-342342xasdasdasda-apps.googleusercontent.com",
 *         },
 *         ThumbprintLists = new[]
 *         {
 *             "cf23df2207d99a74fbe169e3eba035e633b65d94",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewOpenIdConnectProvider(ctx, "default", &iam.OpenIdConnectProviderArgs{
 * 			Url: pulumi.String("https://accounts.google.com"),
 * 			ClientIdLists: pulumi.StringArray{
 * 				pulumi.String("266362248691-342342xasdasdasda-apps.googleusercontent.com"),
 * 			},
 * 			ThumbprintLists: pulumi.StringArray{
 * 				pulumi.String("cf23df2207d99a74fbe169e3eba035e633b65d94"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.OpenIdConnectProvider;
 * import com.pulumi.aws.iam.OpenIdConnectProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new OpenIdConnectProvider("default", OpenIdConnectProviderArgs.builder()
 *             .url("https://accounts.google.com")
 *             .clientIdLists("266362248691-342342xasdasdasda-apps.googleusercontent.com")
 *             .thumbprintLists("cf23df2207d99a74fbe169e3eba035e633b65d94")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:iam:OpenIdConnectProvider
 *     properties:
 *       url: https://accounts.google.com
 *       clientIdLists:
 *         - 266362248691-342342xasdasdasda-apps.googleusercontent.com
 *       thumbprintLists:
 *         - cf23df2207d99a74fbe169e3eba035e633b65d94
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM OpenID Connect Providers using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:iam/openIdConnectProvider:OpenIdConnectProvider default arn:aws:iam::123456789012:oidc-provider/accounts.google.com
 * ```
 * @property clientIdLists A list of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that's sent as the client_id parameter on OAuth requests.)
 * @property tags Map of resource tags for the IAM OIDC provider. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property thumbprintLists A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificate(s).
 * @property url The URL of the identity provider. Corresponds to the _iss_ claim.
 */
public data class OpenIdConnectProviderArgs(
    public val clientIdLists: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val thumbprintLists: Output<List<String>>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.OpenIdConnectProviderArgs> {
    override fun toJava(): com.pulumi.aws.iam.OpenIdConnectProviderArgs =
        com.pulumi.aws.iam.OpenIdConnectProviderArgs.builder()
            .clientIdLists(clientIdLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .thumbprintLists(thumbprintLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenIdConnectProviderArgs].
 */
@PulumiTagMarker
public class OpenIdConnectProviderArgsBuilder internal constructor() {
    private var clientIdLists: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var thumbprintLists: Output<List<String>>? = null

    private var url: Output<String>? = null

    /**
     * @param value A list of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that's sent as the client_id parameter on OAuth requests.)
     */
    @JvmName("clvutaihgatkbctr")
    public suspend fun clientIdLists(`value`: Output<List<String>>) {
        this.clientIdLists = value
    }

    @JvmName("elfetyheoflxusar")
    public suspend fun clientIdLists(vararg values: Output<String>) {
        this.clientIdLists = Output.all(values.asList())
    }

    /**
     * @param values A list of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that's sent as the client_id parameter on OAuth requests.)
     */
    @JvmName("jwabprnokkylommx")
    public suspend fun clientIdLists(values: List<Output<String>>) {
        this.clientIdLists = Output.all(values)
    }

    /**
     * @param value Map of resource tags for the IAM OIDC provider. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pnqcwmyytlchjdpk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificate(s).
     */
    @JvmName("ddmugwcavnolenqb")
    public suspend fun thumbprintLists(`value`: Output<List<String>>) {
        this.thumbprintLists = value
    }

    @JvmName("xblprvpjctqtitmh")
    public suspend fun thumbprintLists(vararg values: Output<String>) {
        this.thumbprintLists = Output.all(values.asList())
    }

    /**
     * @param values A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificate(s).
     */
    @JvmName("twyetdusyhuxgnwy")
    public suspend fun thumbprintLists(values: List<Output<String>>) {
        this.thumbprintLists = Output.all(values)
    }

    /**
     * @param value The URL of the identity provider. Corresponds to the _iss_ claim.
     */
    @JvmName("jhlfyllhatbdveou")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value A list of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that's sent as the client_id parameter on OAuth requests.)
     */
    @JvmName("bjfqgqvgdfrhtbtm")
    public suspend fun clientIdLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIdLists = mapped
    }

    /**
     * @param values A list of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that's sent as the client_id parameter on OAuth requests.)
     */
    @JvmName("swbbebjvvwajwgwi")
    public suspend fun clientIdLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientIdLists = mapped
    }

    /**
     * @param value Map of resource tags for the IAM OIDC provider. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("megyicesqaqmdqpy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags for the IAM OIDC provider. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tcmsgbsjibgowyvk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificate(s).
     */
    @JvmName("jwkwpjhsslofojis")
    public suspend fun thumbprintLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprintLists = mapped
    }

    /**
     * @param values A list of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificate(s).
     */
    @JvmName("tbhawmlmslhhuxnv")
    public suspend fun thumbprintLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thumbprintLists = mapped
    }

    /**
     * @param value The URL of the identity provider. Corresponds to the _iss_ claim.
     */
    @JvmName("ulsppmmwupldtdho")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): OpenIdConnectProviderArgs = OpenIdConnectProviderArgs(
        clientIdLists = clientIdLists,
        tags = tags,
        thumbprintLists = thumbprintLists,
        url = url,
    )
}
