@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.aws.iam.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Provides an IAM policy.
 * > **NOTE:** We suggest using explicit JSON encoding or `aws.iam.getPolicyDocument` when assigning a value to `policy`. They seamlessly translate configuration to JSON, enabling you to maintain consistency within your configuration without the need for context switches. Also, you can sidestep potential complications arising from formatting discrepancies, whitespace inconsistencies, and other nuances inherent to JSON.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const policy = new aws.iam.Policy("policy", {
 *     name: "test_policy",
 *     path: "/",
 *     description: "My test policy",
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: ["ec2:Describe*"],
 *             Effect: "Allow",
 *             Resource: "*",
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * policy = aws.iam.Policy("policy",
 *     name="test_policy",
 *     path="/",
 *     description="My test policy",
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": ["ec2:Describe*"],
 *             "Effect": "Allow",
 *             "Resource": "*",
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new Aws.Iam.Policy("policy", new()
 *     {
 *         Name = "test_policy",
 *         Path = "/",
 *         Description = "My test policy",
 *         PolicyDocument = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "ec2:Describe*",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Resource"] = "*",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"ec2:Describe*",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = iam.NewPolicy(ctx, "policy", &iam.PolicyArgs{
 * 			Name:        pulumi.String("test_policy"),
 * 			Path:        pulumi.String("/"),
 * 			Description: pulumi.String("My test policy"),
 * 			Policy:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .name("test_policy")
 *             .path("/")
 *             .description("My test policy")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   policy:
 *     type: aws:iam:Policy
 *     properties:
 *       name: test_policy
 *       path: /
 *       description: My test policy
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - ec2:Describe*
 *               Effect: Allow
 *               Resource: '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM Policies using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:iam/policy:Policy administrator arn:aws:iam::123456789012:policy/UsersManageOwnCredentials
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.aws.iam.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * ARN assigned by AWS to this policy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Number of entities (users, groups, and roles) that the policy is attached to.
     */
    public val attachmentCount: Output<Int>
        get() = javaResource.attachmentCount().applyValue({ args0 -> args0 })

    /**
     * Description of the IAM policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the policy. If omitted, the provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Path in which to create the policy. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
     */
    public val path: Output<String>?
        get() = javaResource.path().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Policy document. This is a JSON formatted string. For more information about building AWS IAM policy documents, see the AWS IAM Policy Document Guide
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * Policy's ID.
     */
    public val policyId: Output<String>
        get() = javaResource.policyId().applyValue({ args0 -> args0 })

    /**
     * Map of resource tags for the IAM Policy. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.aws.iam.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
