@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [PolicyAttachment].
 */
@PulumiTagMarker
public class PolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyAttachmentArgs = PolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = PolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyAttachment {
        val builtJavaResource = com.pulumi.aws.iam.PolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PolicyAttachment(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const user = new aws.iam.User("user", {name: "test-user"});
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["ec2&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const role = new aws.iam.Role("role", {
 *     name: "test-role",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const group = new aws.iam.Group("group", {name: "test-group"});
 * const policy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["ec2:Describe*"],
 *         resources: ["*"],
 *     }],
 * });
 * const policyPolicy = new aws.iam.Policy("policy", {
 *     name: "test-policy",
 *     description: "A test policy",
 *     policy: policy.then(policy => policy.json),
 * });
 * const test_attach = new aws.iam.PolicyAttachment("test-attach", {
 *     name: "test-attachment",
 *     users: [user&#46;name],
 *     roles: [role&#46;name],
 *     groups: [group&#46;name],
 *     policyArn: policyPolicy.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user = aws.iam.User("user", name="test-user")
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["ec2&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * role = aws.iam.Role("role",
 *     name="test-role",
 *     assume_role_policy=assume_role.json)
 * group = aws.iam.Group("group", name="test-group")
 * policy = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "actions": ["ec2:Describe*"],
 *     "resources": ["*"],
 * }])
 * policy_policy = aws.iam.Policy("policy",
 *     name="test-policy",
 *     description="A test policy",
 *     policy=policy.json)
 * test_attach = aws.iam.PolicyAttachment("test-attach",
 *     name="test-attachment",
 *     users=[user&#46;name],
 *     roles=[role&#46;name],
 *     groups=[group&#46;name],
 *     policy_arn=policy_policy.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new Aws.Iam.User("user", new()
 *     {
 *         Name = "test-user",
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "ec2.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var role = new Aws.Iam.Role("role", new()
 *     {
 *         Name = "test-role",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var @group = new Aws.Iam.Group("group", new()
 *     {
 *         Name = "test-group",
 *     });
 *     var policy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:Describe*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var policyPolicy = new Aws.Iam.Policy("policy", new()
 *     {
 *         Name = "test-policy",
 *         Description = "A test policy",
 *         PolicyDocument = policy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var test_attach = new Aws.Iam.PolicyAttachment("test-attach", new()
 *     {
 *         Name = "test-attachment",
 *         Users = new[]
 *         {
 *             user.Name,
 *         },
 *         Roles = new[]
 *         {
 *             role.Name,
 *         },
 *         Groups = new[]
 *         {
 *             @group.Name,
 *         },
 *         PolicyArn = policyPolicy.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		user, err := iam.NewUser(ctx, "user", &iam.UserArgs{
 * 			Name: pulumi.String("test-user"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"ec2.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		role, err := iam.NewRole(ctx, "role", &iam.RoleArgs{
 * 			Name:             pulumi.String("test-role"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		group, err := iam.NewGroup(ctx, "group", &iam.GroupArgs{
 * 			Name: pulumi.String("test-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"ec2:Describe*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policyPolicy, err := iam.NewPolicy(ctx, "policy", &iam.PolicyArgs{
 * 			Name:        pulumi.String("test-policy"),
 * 			Description: pulumi.String("A test policy"),
 * 			Policy:      pulumi.String(policy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewPolicyAttachment(ctx, "test-attach", &iam.PolicyAttachmentArgs{
 * 			Name: pulumi.String("test-attachment"),
 * 			Users: pulumi.Array{
 * 				user.Name,
 * 			},
 * 			Roles: pulumi.Array{
 * 				role.Name,
 * 			},
 * 			Groups: pulumi.Array{
 * 				group.Name,
 * 			},
 * 			PolicyArn: policyPolicy.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.GroupArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.PolicyAttachment;
 * import com.pulumi.aws.iam.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .name("test-user")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .name("test-role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var group = new Group("group", GroupArgs.builder()
 *             .name("test-group")
 *             .build());
 *         final var policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var policyPolicy = new Policy("policyPolicy", PolicyArgs.builder()
 *             .name("test-policy")
 *             .description("A test policy")
 *             .policy(policy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var test_attach = new PolicyAttachment("test-attach", PolicyAttachmentArgs.builder()
 *             .name("test-attachment")
 *             .users(user.name())
 *             .roles(role.name())
 *             .groups(group.name())
 *             .policyArn(policyPolicy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   user:
 *     type: aws:iam:User
 *     properties:
 *       name: test-user
 *   role:
 *     type: aws:iam:Role
 *     properties:
 *       name: test-role
 *       assumeRolePolicy: ${assumeRole.json}
 *   group:
 *     type: aws:iam:Group
 *     properties:
 *       name: test-group
 *   policyPolicy:
 *     type: aws:iam:Policy
 *     name: policy
 *     properties:
 *       name: test-policy
 *       description: A test policy
 *       policy: ${policy.json}
 *   test-attach:
 *     type: aws:iam:PolicyAttachment
 *     properties:
 *       name: test-attachment
 *       users:
 *         - ${user.name}
 *       roles:
 *         - ${role.name}
 *       groups:
 *         - ${group.name}
 *       policyArn: ${policyPolicy.arn}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - ec2.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   policy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - ec2:Describe*
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class PolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.iam.PolicyAttachment,
) : KotlinCustomResource(javaResource, PolicyAttachmentMapper) {
    /**
     * Group(s) the policy should be applied to.
     */
    public val groups: Output<List<String>>?
        get() = javaResource.groups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Name of the attachment. This cannot be an empty string.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
     */
    public val policyArn: Output<String>
        get() = javaResource.policyArn().applyValue({ args0 -> args0 })

    /**
     * Role(s) the policy should be applied to.
     */
    public val roles: Output<List<String>>?
        get() = javaResource.roles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * User(s) the policy should be applied to.
     */
    public val users: Output<List<String>>?
        get() = javaResource.users().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object PolicyAttachmentMapper : ResourceMapper<PolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.PolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): PolicyAttachment = PolicyAttachment(
        javaResource as
            com.pulumi.aws.iam.PolicyAttachment,
    )
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyAttachment].
 */
public suspend fun policyAttachment(
    name: String,
    block: suspend PolicyAttachmentResourceBuilder.() -> Unit,
): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyAttachment(name: String): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
