@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.PolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const user = new aws.iam.User("user", {name: "test-user"});
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["ec2&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const role = new aws.iam.Role("role", {
 *     name: "test-role",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const group = new aws.iam.Group("group", {name: "test-group"});
 * const policy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: ["ec2:Describe*"],
 *         resources: ["*"],
 *     }],
 * });
 * const policyPolicy = new aws.iam.Policy("policy", {
 *     name: "test-policy",
 *     description: "A test policy",
 *     policy: policy.then(policy => policy.json),
 * });
 * const test_attach = new aws.iam.PolicyAttachment("test-attach", {
 *     name: "test-attachment",
 *     users: [user&#46;name],
 *     roles: [role&#46;name],
 *     groups: [group&#46;name],
 *     policyArn: policyPolicy.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user = aws.iam.User("user", name="test-user")
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["ec2&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * role = aws.iam.Role("role",
 *     name="test-role",
 *     assume_role_policy=assume_role.json)
 * group = aws.iam.Group("group", name="test-group")
 * policy = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "actions": ["ec2:Describe*"],
 *     "resources": ["*"],
 * }])
 * policy_policy = aws.iam.Policy("policy",
 *     name="test-policy",
 *     description="A test policy",
 *     policy=policy.json)
 * test_attach = aws.iam.PolicyAttachment("test-attach",
 *     name="test-attachment",
 *     users=[user&#46;name],
 *     roles=[role&#46;name],
 *     groups=[group&#46;name],
 *     policy_arn=policy_policy.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new Aws.Iam.User("user", new()
 *     {
 *         Name = "test-user",
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "ec2.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var role = new Aws.Iam.Role("role", new()
 *     {
 *         Name = "test-role",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var @group = new Aws.Iam.Group("group", new()
 *     {
 *         Name = "test-group",
 *     });
 *     var policy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:Describe*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var policyPolicy = new Aws.Iam.Policy("policy", new()
 *     {
 *         Name = "test-policy",
 *         Description = "A test policy",
 *         PolicyDocument = policy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var test_attach = new Aws.Iam.PolicyAttachment("test-attach", new()
 *     {
 *         Name = "test-attachment",
 *         Users = new[]
 *         {
 *             user.Name,
 *         },
 *         Roles = new[]
 *         {
 *             role.Name,
 *         },
 *         Groups = new[]
 *         {
 *             @group.Name,
 *         },
 *         PolicyArn = policyPolicy.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		user, err := iam.NewUser(ctx, "user", &iam.UserArgs{
 * 			Name: pulumi.String("test-user"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"ec2.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		role, err := iam.NewRole(ctx, "role", &iam.RoleArgs{
 * 			Name:             pulumi.String("test-role"),
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		group, err := iam.NewGroup(ctx, "group", &iam.GroupArgs{
 * 			Name: pulumi.String("test-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"ec2:Describe*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policyPolicy, err := iam.NewPolicy(ctx, "policy", &iam.PolicyArgs{
 * 			Name:        pulumi.String("test-policy"),
 * 			Description: pulumi.String("A test policy"),
 * 			Policy:      pulumi.String(policy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewPolicyAttachment(ctx, "test-attach", &iam.PolicyAttachmentArgs{
 * 			Name: pulumi.String("test-attachment"),
 * 			Users: pulumi.Array{
 * 				user.Name,
 * 			},
 * 			Roles: pulumi.Array{
 * 				role.Name,
 * 			},
 * 			Groups: pulumi.Array{
 * 				group.Name,
 * 			},
 * 			PolicyArn: policyPolicy.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.Group;
 * import com.pulumi.aws.iam.GroupArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.PolicyAttachment;
 * import com.pulumi.aws.iam.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .name("test-user")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var role = new Role("role", RoleArgs.builder()
 *             .name("test-role")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var group = new Group("group", GroupArgs.builder()
 *             .name("test-group")
 *             .build());
 *         final var policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("ec2:Describe*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var policyPolicy = new Policy("policyPolicy", PolicyArgs.builder()
 *             .name("test-policy")
 *             .description("A test policy")
 *             .policy(policy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var test_attach = new PolicyAttachment("test-attach", PolicyAttachmentArgs.builder()
 *             .name("test-attachment")
 *             .users(user.name())
 *             .roles(role.name())
 *             .groups(group.name())
 *             .policyArn(policyPolicy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   user:
 *     type: aws:iam:User
 *     properties:
 *       name: test-user
 *   role:
 *     type: aws:iam:Role
 *     properties:
 *       name: test-role
 *       assumeRolePolicy: ${assumeRole.json}
 *   group:
 *     type: aws:iam:Group
 *     properties:
 *       name: test-group
 *   policyPolicy:
 *     type: aws:iam:Policy
 *     name: policy
 *     properties:
 *       name: test-policy
 *       description: A test policy
 *       policy: ${policy.json}
 *   test-attach:
 *     type: aws:iam:PolicyAttachment
 *     properties:
 *       name: test-attachment
 *       users:
 *         - ${user.name}
 *       roles:
 *         - ${role.name}
 *       groups:
 *         - ${group.name}
 *       policyArn: ${policyPolicy.arn}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - ec2.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   policy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - ec2:Describe*
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * @property groups Group(s) the policy should be applied to.
 * @property name Name of the attachment. This cannot be an empty string.
 * @property policyArn ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
 * @property roles Role(s) the policy should be applied to.
 * @property users User(s) the policy should be applied to.
 */
public data class PolicyAttachmentArgs(
    public val groups: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val policyArn: Output<String>? = null,
    public val roles: Output<List<String>>? = null,
    public val users: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.PolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.iam.PolicyAttachmentArgs =
        com.pulumi.aws.iam.PolicyAttachmentArgs.builder()
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policyArn(policyArn?.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .users(users?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PolicyAttachmentArgs].
 */
@PulumiTagMarker
public class PolicyAttachmentArgsBuilder internal constructor() {
    private var groups: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var policyArn: Output<String>? = null

    private var roles: Output<List<String>>? = null

    private var users: Output<List<String>>? = null

    /**
     * @param value Group(s) the policy should be applied to.
     */
    @JvmName("dnnbumiffghqugpk")
    public suspend fun groups(`value`: Output<List<String>>) {
        this.groups = value
    }

    @JvmName("mavscavfkybdgdym")
    public suspend fun groups(vararg values: Output<String>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values Group(s) the policy should be applied to.
     */
    @JvmName("exlcfcrdokpqfxuw")
    public suspend fun groups(values: List<Output<String>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value Name of the attachment. This cannot be an empty string.
     */
    @JvmName("vhoepghtdglolpgh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
     */
    @JvmName("gumfkpctgkdtsxqy")
    public suspend fun policyArn(`value`: Output<String>) {
        this.policyArn = value
    }

    /**
     * @param value Role(s) the policy should be applied to.
     */
    @JvmName("rsgetgisxqgbwghw")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("csycavdibttujuog")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values Role(s) the policy should be applied to.
     */
    @JvmName("ibcwgsqsdbvsecit")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value User(s) the policy should be applied to.
     */
    @JvmName("ciikiylcweymtymt")
    public suspend fun users(`value`: Output<List<String>>) {
        this.users = value
    }

    @JvmName("ohfayxqtiqgiqlqu")
    public suspend fun users(vararg values: Output<String>) {
        this.users = Output.all(values.asList())
    }

    /**
     * @param values User(s) the policy should be applied to.
     */
    @JvmName("xjibgyrhggtanmsh")
    public suspend fun users(values: List<Output<String>>) {
        this.users = Output.all(values)
    }

    /**
     * @param value Group(s) the policy should be applied to.
     */
    @JvmName("kaabcujtyqlanwmq")
    public suspend fun groups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param values Group(s) the policy should be applied to.
     */
    @JvmName("egyyybpwityyagfl")
    public suspend fun groups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value Name of the attachment. This cannot be an empty string.
     */
    @JvmName("stqamaxkcwfcphrc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ARN of the policy you want to apply. Typically this should be a reference to the ARN of another resource to ensure dependency ordering, such as `aws_iam_policy.example.arn`.
     */
    @JvmName("ixuyyqgydshwyghf")
    public suspend fun policyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArn = mapped
    }

    /**
     * @param value Role(s) the policy should be applied to.
     */
    @JvmName("adshsokhbanwebgn")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values Role(s) the policy should be applied to.
     */
    @JvmName("bwqwkcwgwvuhnkio")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value User(s) the policy should be applied to.
     */
    @JvmName("wlrdkbehknvymrni")
    public suspend fun users(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.users = mapped
    }

    /**
     * @param values User(s) the policy should be applied to.
     */
    @JvmName("pxnbidxahxpvjswy")
    public suspend fun users(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.users = mapped
    }

    internal fun build(): PolicyAttachmentArgs = PolicyAttachmentArgs(
        groups = groups,
        name = name,
        policyArn = policyArn,
        roles = roles,
        users = users,
    )
}
