@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.kotlin.outputs.RoleInlinePolicy
import com.pulumi.aws.iam.kotlin.outputs.RoleInlinePolicy.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Role].
 */
@PulumiTagMarker
public class RoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleArgs = RoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleArgsBuilder.() -> Unit) {
        val builder = RoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Role {
        val builtJavaResource = com.pulumi.aws.iam.Role(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Role(builtJavaResource)
    }
}

/**
 * Provides an IAM role.
 * > **NOTE:** If policies are attached to the role via the `aws.iam.PolicyAttachment` resource and you are modifying the role `name` or `path`, the `force_detach_policies` argument must be set to `true` and applied before attempting the operation otherwise you will encounter a `DeleteConflict` error. The `aws.iam.RolePolicyAttachment` resource (recommended) does not have this requirement.
 * > **NOTE:** If you use this resource's `managed_policy_arns` argument or `inline_policy` configuration blocks, this resource will take over exclusive management of the role's respective policy types (e.g., both policy types if both arguments are used). These arguments are incompatible with other ways of managing a role's policies, such as `aws.iam.PolicyAttachment`, `aws.iam.RolePolicyAttachment`, and `aws.iam.RolePolicy`. If you attempt to manage a role's policies by multiple means, you will get resource cycling and/or errors.
 * > **NOTE:** We suggest using explicit JSON encoding or `aws.iam.getPolicyDocument` when assigning a value to `policy`. They seamlessly translate configuration to JSON, enabling you to maintain consistency within your configuration without the need for context switches. Also, you can sidestep potential complications arising from formatting discrepancies, whitespace inconsistencies, and other nuances inherent to JSON.
 * ## Example Usage
 * ### Basic Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testRole = new aws.iam.Role("test_role", {
 *     name: "test_role",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Sid: "",
 *             Principal: {
 *                 Service: "ec2.amazonaws.com",
 *             },
 *         }],
 *     }),
 *     tags: {
 *         "tag-key": "tag-value",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test_role = aws.iam.Role("test_role",
 *     name="test_role",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Sid": "",
 *             "Principal": {
 *                 "Service": "ec2.amazonaws.com",
 *             },
 *         }],
 *     }),
 *     tags={
 *         "tag-key": "tag-value",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testRole = new Aws.Iam.Role("test_role", new()
 *     {
 *         Name = "test_role",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "ec2.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *         Tags =
 *         {
 *             { "tag-key", "tag-value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "ec2.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = iam.NewRole(ctx, "test_role", &iam.RoleArgs{
 * 			Name:             pulumi.String("test_role"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 			Tags: pulumi.StringMap{
 * 				"tag-key": pulumi.String("tag-value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .name("test_role")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .tags(Map.of("tag-key", "tag-value"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testRole:
 *     type: aws:iam:Role
 *     name: test_role
 *     properties:
 *       name: test_role
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: ec2.amazonaws.com
 *       tags:
 *         tag-key: tag-value
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example of Using Data Source for Assume Role Policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const instanceAssumeRolePolicy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["ec2&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const instance = new aws.iam.Role("instance", {
 *     name: "instance_role",
 *     path: "/system/",
 *     assumeRolePolicy: instanceAssumeRolePolicy.then(instanceAssumeRolePolicy => instanceAssumeRolePolicy.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * instance_assume_role_policy = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["ec2&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * instance = aws.iam.Role("instance",
 *     name="instance_role",
 *     path="/system/",
 *     assume_role_policy=instance_assume_role_policy.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instanceAssumeRolePolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "ec2.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var instance = new Aws.Iam.Role("instance", new()
 *     {
 *         Name = "instance_role",
 *         Path = "/system/",
 *         AssumeRolePolicy = instanceAssumeRolePolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		instanceAssumeRolePolicy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"ec2.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRole(ctx, "instance", &iam.RoleArgs{
 * 			Name:             pulumi.String("instance_role"),
 * 			Path:             pulumi.String("/system/"),
 * 			AssumeRolePolicy: pulumi.String(instanceAssumeRolePolicy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var instanceAssumeRolePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("ec2.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var instance = new Role("instance", RoleArgs.builder()
 *             .name("instance_role")
 *             .path("/system/")
 *             .assumeRolePolicy(instanceAssumeRolePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   instance:
 *     type: aws:iam:Role
 *     properties:
 *       name: instance_role
 *       path: /system/
 *       assumeRolePolicy: ${instanceAssumeRolePolicy.json}
 * variables:
 *   instanceAssumeRolePolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - ec2.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example of Exclusive Inline Policies
 * This example creates an IAM role with two inline IAM policies. If someone adds another inline policy out-of-band, on the next apply, this provider will remove that policy. If someone deletes these policies out-of-band, this provider will recreate them.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const inlinePolicy = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["ec2:DescribeAccountAttributes"],
 *         resources: ["*"],
 *     }],
 * });
 * const example = new aws.iam.Role("example", {
 *     name: "yak_role",
 *     assumeRolePolicy: instanceAssumeRolePolicy.json,
 *     inlinePolicies: [
 *         {
 *             name: "my_inline_policy",
 *             policy: JSON.stringify({
 *                 Version: "2012-10-17",
 *                 Statement: [{
 *                     Action: ["ec2:Describe*"],
 *                     Effect: "Allow",
 *                     Resource: "*",
 *                 }],
 *             }),
 *         },
 *         {
 *             name: "policy-8675309",
 *             policy: inlinePolicy.then(inlinePolicy => inlinePolicy.json),
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * inline_policy = aws.iam.get_policy_document(statements=[{
 *     "actions": ["ec2:DescribeAccountAttributes"],
 *     "resources": ["*"],
 * }])
 * example = aws.iam.Role("example",
 *     name="yak_role",
 *     assume_role_policy=instance_assume_role_policy["json"],
 *     inline_policies=[
 *         {
 *             "name": "my_inline_policy",
 *             "policy": json.dumps({
 *                 "version": "2012-10-17",
 *                 "statement": [{
 *                     "action": ["ec2:Describe*"],
 *                     "effect": "Allow",
 *                     "resource": "*",
 *                 }],
 *             }),
 *         },
 *         {
 *             "name": "policy-8675309",
 *             "policy": inline_policy.json,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var inlinePolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "ec2:DescribeAccountAttributes",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "yak_role",
 *         AssumeRolePolicy = instanceAssumeRolePolicy.Json,
 *         InlinePolicies = new[]
 *         {
 *             new Aws.Iam.Inputs.RoleInlinePolicyArgs
 *             {
 *                 Name = "my_inline_policy",
 *                 Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *                 {
 *                     ["Version"] = "2012-10-17",
 *                     ["Statement"] = new[]
 *                     {
 *                         new Dictionary<string, object?>
 *                         {
 *                             ["Action"] = new[]
 *                             {
 *                                 "ec2:Describe*",
 *                             },
 *                             ["Effect"] = "Allow",
 *                             ["Resource"] = "*",
 *                         },
 *                     },
 *                 }),
 *             },
 *             new Aws.Iam.Inputs.RoleInlinePolicyArgs
 *             {
 *                 Name = "policy-8675309",
 *                 Policy = inlinePolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		inlinePolicy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"ec2:DescribeAccountAttributes",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"ec2:Describe*",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("yak_role"),
 * 			AssumeRolePolicy: pulumi.Any(instanceAssumeRolePolicy.Json),
 * 			InlinePolicies: iam.RoleInlinePolicyArray{
 * 				&iam.RoleInlinePolicyArgs{
 * 					Name:   pulumi.String("my_inline_policy"),
 * 					Policy: pulumi.String(json0),
 * 				},
 * 				&iam.RoleInlinePolicyArgs{
 * 					Name:   pulumi.String("policy-8675309"),
 * 					Policy: pulumi.String(inlinePolicy.Json),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var inlinePolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("ec2:DescribeAccountAttributes")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .name("yak_role")
 *             .assumeRolePolicy(instanceAssumeRolePolicy.json())
 *             .inlinePolicies(
 *                 RoleInlinePolicyArgs.builder()
 *                     .name("my_inline_policy")
 *                     .policy(serializeJson(
 *                         jsonObject(
 *                             jsonProperty("Version", "2012-10-17"),
 *                             jsonProperty("Statement", jsonArray(jsonObject(
 *                                 jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                                 jsonProperty("Effect", "Allow"),
 *                                 jsonProperty("Resource", "*")
 *                             )))
 *                         )))
 *                     .build(),
 *                 RoleInlinePolicyArgs.builder()
 *                     .name("policy-8675309")
 *                     .policy(inlinePolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       name: yak_role
 *       assumeRolePolicy: ${instanceAssumeRolePolicy.json}
 *       inlinePolicies:
 *         - name: my_inline_policy
 *           policy:
 *             fn::toJSON:
 *               Version: 2012-10-17
 *               Statement:
 *                 - Action:
 *                     - ec2:Describe*
 *                   Effect: Allow
 *                   Resource: '*'
 *         - name: policy-8675309
 *           policy: ${inlinePolicy.json}
 * variables:
 *   inlinePolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - ec2:DescribeAccountAttributes
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example of Removing Inline Policies
 * This example creates an IAM role with what appears to be empty IAM `inline_policy` argument instead of using `inline_policy` as a configuration block. The result is that if someone were to add an inline policy out-of-band, on the next apply, this provider will remove that policy.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iam.Role("example", {
 *     inlinePolicies: [{}],
 *     name: "yak_role",
 *     assumeRolePolicy: instanceAssumeRolePolicy.json,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.Role("example",
 *     inline_policies=[{}],
 *     name="yak_role",
 *     assume_role_policy=instance_assume_role_policy["json"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         InlinePolicies = new[]
 *         {
 *             null,
 *         },
 *         Name = "yak_role",
 *         AssumeRolePolicy = instanceAssumeRolePolicy.Json,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			InlinePolicies: iam.RoleInlinePolicyArray{
 * 				nil,
 * 			},
 * 			Name:             pulumi.String("yak_role"),
 * 			AssumeRolePolicy: pulumi.Any(instanceAssumeRolePolicy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .inlinePolicies()
 *             .name("yak_role")
 *             .assumeRolePolicy(instanceAssumeRolePolicy.json())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       inlinePolicies:
 *         - {}
 *       name: yak_role
 *       assumeRolePolicy: ${instanceAssumeRolePolicy.json}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example of Exclusive Managed Policies
 * This example creates an IAM role and attaches two managed IAM policies. If someone attaches another managed policy out-of-band, on the next apply, this provider will detach that policy. If someone detaches these policies out-of-band, this provider will attach them again.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const policyOne = new aws.iam.Policy("policy_one", {
 *     name: "policy-618033",
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: ["ec2:Describe*"],
 *             Effect: "Allow",
 *             Resource: "*",
 *         }],
 *     }),
 * });
 * const policyTwo = new aws.iam.Policy("policy_two", {
 *     name: "policy-381966",
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: [
 *                 "s3:ListAllMyBuckets",
 *                 "s3:ListBucket",
 *                 "s3:HeadBucket",
 *             ],
 *             Effect: "Allow",
 *             Resource: "*",
 *         }],
 *     }),
 * });
 * const example = new aws.iam.Role("example", {
 *     name: "yak_role",
 *     assumeRolePolicy: instanceAssumeRolePolicy.json,
 *     managedPolicyArns: [
 *         policyOne.arn,
 *         policyTwo.arn,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * policy_one = aws.iam.Policy("policy_one",
 *     name="policy-618033",
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": ["ec2:Describe*"],
 *             "Effect": "Allow",
 *             "Resource": "*",
 *         }],
 *     }))
 * policy_two = aws.iam.Policy("policy_two",
 *     name="policy-381966",
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": [
 *                 "s3:ListAllMyBuckets",
 *                 "s3:ListBucket",
 *                 "s3:HeadBucket",
 *             ],
 *             "Effect": "Allow",
 *             "Resource": "*",
 *         }],
 *     }))
 * example = aws.iam.Role("example",
 *     name="yak_role",
 *     assume_role_policy=instance_assume_role_policy["json"],
 *     managed_policy_arns=[
 *         policy_one.arn,
 *         policy_two.arn,
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyOne = new Aws.Iam.Policy("policy_one", new()
 *     {
 *         Name = "policy-618033",
 *         PolicyDocument = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "ec2:Describe*",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Resource"] = "*",
 *                 },
 *             },
 *         }),
 *     });
 *     var policyTwo = new Aws.Iam.Policy("policy_two", new()
 *     {
 *         Name = "policy-381966",
 *         PolicyDocument = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "s3:ListAllMyBuckets",
 *                         "s3:ListBucket",
 *                         "s3:HeadBucket",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Resource"] = "*",
 *                 },
 *             },
 *         }),
 *     });
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "yak_role",
 *         AssumeRolePolicy = instanceAssumeRolePolicy.Json,
 *         ManagedPolicyArns = new[]
 *         {
 *             policyOne.Arn,
 *             policyTwo.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"ec2:Describe*",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		policyOne, err := iam.NewPolicy(ctx, "policy_one", &iam.PolicyArgs{
 * 			Name:   pulumi.String("policy-618033"),
 * 			Policy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"s3:ListAllMyBuckets",
 * 						"s3:ListBucket",
 * 						"s3:HeadBucket",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json1 := string(tmpJSON1)
 * 		policyTwo, err := iam.NewPolicy(ctx, "policy_two", &iam.PolicyArgs{
 * 			Name:   pulumi.String("policy-381966"),
 * 			Policy: pulumi.String(json1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("yak_role"),
 * 			AssumeRolePolicy: pulumi.Any(instanceAssumeRolePolicy.Json),
 * 			ManagedPolicyArns: pulumi.StringArray{
 * 				policyOne.Arn,
 * 				policyTwo.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyOne = new Policy("policyOne", PolicyArgs.builder()
 *             .name("policy-618033")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var policyTwo = new Policy("policyTwo", PolicyArgs.builder()
 *             .name("policy-381966")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "s3:ListAllMyBuckets",
 *                             "s3:ListBucket",
 *                             "s3:HeadBucket"
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .name("yak_role")
 *             .assumeRolePolicy(instanceAssumeRolePolicy.json())
 *             .managedPolicyArns(
 *                 policyOne.arn(),
 *                 policyTwo.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       name: yak_role
 *       assumeRolePolicy: ${instanceAssumeRolePolicy.json}
 *       managedPolicyArns:
 *         - ${policyOne.arn}
 *         - ${policyTwo.arn}
 *   policyOne:
 *     type: aws:iam:Policy
 *     name: policy_one
 *     properties:
 *       name: policy-618033
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - ec2:Describe*
 *               Effect: Allow
 *               Resource: '*'
 *   policyTwo:
 *     type: aws:iam:Policy
 *     name: policy_two
 *     properties:
 *       name: policy-381966
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - s3:ListAllMyBuckets
 *                 - s3:ListBucket
 *                 - s3:HeadBucket
 *               Effect: Allow
 *               Resource: '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example of Removing Managed Policies
 * This example creates an IAM role with an empty `managed_policy_arns` argument. If someone attaches a policy out-of-band, on the next apply, this provider will detach that policy.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iam.Role("example", {
 *     name: "yak_role",
 *     assumeRolePolicy: instanceAssumeRolePolicy.json,
 *     managedPolicyArns: [],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.Role("example",
 *     name="yak_role",
 *     assume_role_policy=instance_assume_role_policy["json"],
 *     managed_policy_arns=[])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "yak_role",
 *         AssumeRolePolicy = instanceAssumeRolePolicy.Json,
 *         ManagedPolicyArns = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:              pulumi.String("yak_role"),
 * 			AssumeRolePolicy:  pulumi.Any(instanceAssumeRolePolicy.Json),
 * 			ManagedPolicyArns: pulumi.StringArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .name("yak_role")
 *             .assumeRolePolicy(instanceAssumeRolePolicy.json())
 *             .managedPolicyArns()
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       name: yak_role
 *       assumeRolePolicy: ${instanceAssumeRolePolicy.json}
 *       managedPolicyArns: []
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM Roles using the `name`. For example:
 * ```sh
 * $ pulumi import aws:iam/role:Role developer developer_name
 * ```
 */
public class Role internal constructor(
    override val javaResource: com.pulumi.aws.iam.Role,
) : KotlinCustomResource(javaResource, RoleMapper) {
    /**
     * Amazon Resource Name (ARN) specifying the role.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Policy that grants an entity permission to assume the role.
     * > **NOTE:** The `assume_role_policy` is very similar to but slightly different than a standard IAM policy and cannot use an `aws.iam.Policy` resource.  However, it _can_ use an `aws.iam.getPolicyDocument` data source. See the example above of how this works.
     * The following arguments are optional:
     */
    public val assumeRolePolicy: Output<String>
        get() = javaResource.assumeRolePolicy().applyValue({ args0 -> args0 })

    /**
     * Creation date of the IAM role.
     */
    public val createDate: Output<String>
        get() = javaResource.createDate().applyValue({ args0 -> args0 })

    /**
     * Description of the role.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to force detaching any policies the role has before destroying it. Defaults to `false`.
     */
    public val forceDetachPolicies: Output<Boolean>?
        get() = javaResource.forceDetachPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block defining an exclusive set of IAM inline policies associated with the IAM role. See below. If no blocks are configured, the provider will not manage any inline policies in this resource. Configuring one empty block (i.e., `inline_policy {}`) will cause the provider to remove _all_ inline policies added out of band on `apply`.
     */
    public val inlinePolicies: Output<List<RoleInlinePolicy>>
        get() = javaResource.inlinePolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    public val managedPolicyArns: Output<List<String>>
        get() = javaResource.managedPolicyArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Maximum session duration (in seconds) that you want to set for the specified role. If you do not specify a value for this setting, the default maximum of one hour is applied. This setting can have a value from 1 hour to 12 hours.
     */
    public val maxSessionDuration: Output<Int>?
        get() = javaResource.maxSessionDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Friendly name of the role. If omitted, the provider will assign a random, unique name. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique friendly name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Path to the role. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) for more information.
     */
    public val path: Output<String>?
        get() = javaResource.path().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARN of the policy that is used to set the permissions boundary for the role.
     */
    public val permissionsBoundary: Output<String>?
        get() = javaResource.permissionsBoundary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Stable and unique string identifying the role.
     */
    public val uniqueId: Output<String>
        get() = javaResource.uniqueId().applyValue({ args0 -> args0 })
}

public object RoleMapper : ResourceMapper<Role> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.Role::class == javaResource::class

    override fun map(javaResource: Resource): Role = Role(javaResource as com.pulumi.aws.iam.Role)
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Role].
 */
public suspend fun role(name: String, block: suspend RoleResourceBuilder.() -> Unit): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 */
public fun role(name: String): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
