@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.RolePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM role inline policy.
 * > **NOTE:** For a given role, this resource is incompatible with using the `aws.iam.Role` resource `inline_policy` argument. When using that argument and this resource, both will attempt to manage the role's inline policies and the provider will show a permanent difference.
 * > **NOTE:** We suggest using explicit JSON encoding or `aws.iam.getPolicyDocument` when assigning a value to `policy`. They seamlessly translate configuration to JSON, enabling you to maintain consistency within your configuration without the need for context switches. Also, you can sidestep potential complications arising from formatting discrepancies, whitespace inconsistencies, and other nuances inherent to JSON.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testRole = new aws.iam.Role("test_role", {
 *     name: "test_role",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Sid: "",
 *             Principal: {
 *                 Service: "ec2.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const testPolicy = new aws.iam.RolePolicy("test_policy", {
 *     name: "test_policy",
 *     role: testRole.id,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: ["ec2:Describe*"],
 *             Effect: "Allow",
 *             Resource: "*",
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test_role = aws.iam.Role("test_role",
 *     name="test_role",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Sid": "",
 *             "Principal": {
 *                 "Service": "ec2.amazonaws.com",
 *             },
 *         }],
 *     }))
 * test_policy = aws.iam.RolePolicy("test_policy",
 *     name="test_policy",
 *     role=test_role.id,
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": ["ec2:Describe*"],
 *             "Effect": "Allow",
 *             "Resource": "*",
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testRole = new Aws.Iam.Role("test_role", new()
 *     {
 *         Name = "test_role",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "ec2.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var testPolicy = new Aws.Iam.RolePolicy("test_policy", new()
 *     {
 *         Name = "test_policy",
 *         Role = testRole.Id,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "ec2:Describe*",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Resource"] = "*",
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "ec2.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		testRole, err := iam.NewRole(ctx, "test_role", &iam.RoleArgs{
 * 			Name:             pulumi.String("test_role"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"ec2:Describe*",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json1 := string(tmpJSON1)
 * 		_, err = iam.NewRolePolicy(ctx, "test_policy", &iam.RolePolicyArgs{
 * 			Name:   pulumi.String("test_policy"),
 * 			Role:   testRole.ID(),
 * 			Policy: pulumi.String(json1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .name("test_role")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var testPolicy = new RolePolicy("testPolicy", RolePolicyArgs.builder()
 *             .name("test_policy")
 *             .role(testRole.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testPolicy:
 *     type: aws:iam:RolePolicy
 *     name: test_policy
 *     properties:
 *       name: test_policy
 *       role: ${testRole.id}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - ec2:Describe*
 *               Effect: Allow
 *               Resource: '*'
 *   testRole:
 *     type: aws:iam:Role
 *     name: test_role
 *     properties:
 *       name: test_role
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: ec2.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM Role Policies using the `role_name:role_policy_name`. For example:
 * ```sh
 * $ pulumi import aws:iam/rolePolicy:RolePolicy mypolicy role_of_mypolicy_name:mypolicy_name
 * ```
 * @property name The name of the role policy. If omitted, this provider will
 * assign a random, unique name.
 * @property namePrefix Creates a unique name beginning with the specified
 * prefix. Conflicts with `name`.
 * @property policy The inline policy document. This is a JSON formatted string. For more information about building IAM policy documents with the provider, see the AWS IAM Policy Document Guide
 * @property role The name of the IAM role to attach to the policy.
 */
public data class RolePolicyArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val role: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.RolePolicyArgs> {
    override fun toJava(): com.pulumi.aws.iam.RolePolicyArgs =
        com.pulumi.aws.iam.RolePolicyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RolePolicyArgs].
 */
@PulumiTagMarker
public class RolePolicyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var policy: Output<String>? = null

    private var role: Output<String>? = null

    /**
     * @param value The name of the role policy. If omitted, this provider will
     * assign a random, unique name.
     */
    @JvmName("vapjfaftlqehwpxa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("frowqjbaphyeursa")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The inline policy document. This is a JSON formatted string. For more information about building IAM policy documents with the provider, see the AWS IAM Policy Document Guide
     */
    @JvmName("nprbvqkjwyxsuipu")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The name of the IAM role to attach to the policy.
     */
    @JvmName("bagqbstaxrshlceg")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The name of the role policy. If omitted, this provider will
     * assign a random, unique name.
     */
    @JvmName("tnadihmfthdemjdp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("tmyqcjgprouueakd")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The inline policy document. This is a JSON formatted string. For more information about building IAM policy documents with the provider, see the AWS IAM Policy Document Guide
     */
    @JvmName("knpyjjckwxdlapuq")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The name of the IAM role to attach to the policy.
     */
    @JvmName("eamdxtlurqrusvhp")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    internal fun build(): RolePolicyArgs = RolePolicyArgs(
        name = name,
        namePrefix = namePrefix,
        policy = policy,
        role = role,
    )
}
