@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SamlProvider].
 */
@PulumiTagMarker
public class SamlProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SamlProviderArgs = SamlProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SamlProviderArgsBuilder.() -> Unit) {
        val builder = SamlProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SamlProvider {
        val builtJavaResource = com.pulumi.aws.iam.SamlProvider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SamlProvider(builtJavaResource)
    }
}

/**
 * Provides an IAM SAML provider.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const _default = new aws.iam.SamlProvider("default", {
 *     name: "myprovider",
 *     samlMetadataDocument: std.file({
 *         input: "saml-metadata.xml",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * default = aws.iam.SamlProvider("default",
 *     name="myprovider",
 *     saml_metadata_document=std.file(input="saml-metadata.xml").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Iam.SamlProvider("default", new()
 *     {
 *         Name = "myprovider",
 *         SamlMetadataDocument = Std.File.Invoke(new()
 *         {
 *             Input = "saml-metadata.xml",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "saml-metadata.xml",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewSamlProvider(ctx, "default", &iam.SamlProviderArgs{
 * 			Name:                 pulumi.String("myprovider"),
 * 			SamlMetadataDocument: pulumi.String(invokeFile.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SamlProvider;
 * import com.pulumi.aws.iam.SamlProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SamlProvider("default", SamlProviderArgs.builder()
 *             .name("myprovider")
 *             .samlMetadataDocument(StdFunctions.file(FileArgs.builder()
 *                 .input("saml-metadata.xml")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:iam:SamlProvider
 *     properties:
 *       name: myprovider
 *       samlMetadataDocument:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: saml-metadata.xml
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM SAML Providers using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:iam/samlProvider:SamlProvider default arn:aws:iam::123456789012:saml-provider/SAMLADFS
 * ```
 */
public class SamlProvider internal constructor(
    override val javaResource: com.pulumi.aws.iam.SamlProvider,
) : KotlinCustomResource(javaResource, SamlProviderMapper) {
    /**
     * The ARN assigned by AWS for this provider.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the provider to create.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An XML document generated by an identity provider that supports SAML 2.0.
     */
    public val samlMetadataDocument: Output<String>
        get() = javaResource.samlMetadataDocument().applyValue({ args0 -> args0 })

    /**
     * Map of resource tags for the IAM SAML provider. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The expiration date and time for the SAML provider in RFC1123 format, e.g., `Mon, 02 Jan 2006 15:04:05 MST`.
     */
    public val validUntil: Output<String>
        get() = javaResource.validUntil().applyValue({ args0 -> args0 })
}

public object SamlProviderMapper : ResourceMapper<SamlProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.SamlProvider::class == javaResource::class

    override fun map(javaResource: Resource): SamlProvider = SamlProvider(
        javaResource as
            com.pulumi.aws.iam.SamlProvider,
    )
}

/**
 * @see [SamlProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SamlProvider].
 */
public suspend fun samlProvider(
    name: String,
    block: suspend SamlProviderResourceBuilder.() -> Unit,
): SamlProvider {
    val builder = SamlProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SamlProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun samlProvider(name: String): SamlProvider {
    val builder = SamlProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
