@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.SamlProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IAM SAML provider.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const _default = new aws.iam.SamlProvider("default", {
 *     name: "myprovider",
 *     samlMetadataDocument: std.file({
 *         input: "saml-metadata.xml",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * default = aws.iam.SamlProvider("default",
 *     name="myprovider",
 *     saml_metadata_document=std.file(input="saml-metadata.xml").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Iam.SamlProvider("default", new()
 *     {
 *         Name = "myprovider",
 *         SamlMetadataDocument = Std.File.Invoke(new()
 *         {
 *             Input = "saml-metadata.xml",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "saml-metadata.xml",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewSamlProvider(ctx, "default", &iam.SamlProviderArgs{
 * 			Name:                 pulumi.String("myprovider"),
 * 			SamlMetadataDocument: pulumi.String(invokeFile.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SamlProvider;
 * import com.pulumi.aws.iam.SamlProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SamlProvider("default", SamlProviderArgs.builder()
 *             .name("myprovider")
 *             .samlMetadataDocument(StdFunctions.file(FileArgs.builder()
 *                 .input("saml-metadata.xml")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:iam:SamlProvider
 *     properties:
 *       name: myprovider
 *       samlMetadataDocument:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: saml-metadata.xml
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM SAML Providers using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:iam/samlProvider:SamlProvider default arn:aws:iam::123456789012:saml-provider/SAMLADFS
 * ```
 * @property name The name of the provider to create.
 * @property samlMetadataDocument An XML document generated by an identity provider that supports SAML 2.0.
 * @property tags Map of resource tags for the IAM SAML provider. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SamlProviderArgs(
    public val name: Output<String>? = null,
    public val samlMetadataDocument: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.SamlProviderArgs> {
    override fun toJava(): com.pulumi.aws.iam.SamlProviderArgs =
        com.pulumi.aws.iam.SamlProviderArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .samlMetadataDocument(samlMetadataDocument?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SamlProviderArgs].
 */
@PulumiTagMarker
public class SamlProviderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var samlMetadataDocument: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the provider to create.
     */
    @JvmName("gowkhxwxrpibdpxl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An XML document generated by an identity provider that supports SAML 2.0.
     */
    @JvmName("pnjvebumaeyspksq")
    public suspend fun samlMetadataDocument(`value`: Output<String>) {
        this.samlMetadataDocument = value
    }

    /**
     * @param value Map of resource tags for the IAM SAML provider. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("krtcteuxpcbwmtqe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the provider to create.
     */
    @JvmName("gerhiciybeqwrdfe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An XML document generated by an identity provider that supports SAML 2.0.
     */
    @JvmName("hmtnlqctjpnykeir")
    public suspend fun samlMetadataDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samlMetadataDocument = mapped
    }

    /**
     * @param value Map of resource tags for the IAM SAML provider. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wubfpirgflgaahwx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags for the IAM SAML provider. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gtbbjldvvyjwjnwa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SamlProviderArgs = SamlProviderArgs(
        name = name,
        samlMetadataDocument = samlMetadataDocument,
        tags = tags,
    )
}
