@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityTokenServicePreferences].
 */
@PulumiTagMarker
public class SecurityTokenServicePreferencesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityTokenServicePreferencesArgs = SecurityTokenServicePreferencesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityTokenServicePreferencesArgsBuilder.() -> Unit) {
        val builder = SecurityTokenServicePreferencesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityTokenServicePreferences {
        val builtJavaResource =
            com.pulumi.aws.iam.SecurityTokenServicePreferences(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecurityTokenServicePreferences(builtJavaResource)
    }
}

/**
 * Provides an IAM Security Token Service Preferences resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iam.SecurityTokenServicePreferences("example", {globalEndpointTokenVersion: "v2Token"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.SecurityTokenServicePreferences("example", global_endpoint_token_version="v2Token")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iam.SecurityTokenServicePreferences("example", new()
 *     {
 *         GlobalEndpointTokenVersion = "v2Token",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewSecurityTokenServicePreferences(ctx, "example", &iam.SecurityTokenServicePreferencesArgs{
 * 			GlobalEndpointTokenVersion: pulumi.String("v2Token"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SecurityTokenServicePreferences;
 * import com.pulumi.aws.iam.SecurityTokenServicePreferencesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityTokenServicePreferences("example", SecurityTokenServicePreferencesArgs.builder()
 *             .globalEndpointTokenVersion("v2Token")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:SecurityTokenServicePreferences
 *     properties:
 *       globalEndpointTokenVersion: v2Token
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class SecurityTokenServicePreferences internal constructor(
    override val javaResource: com.pulumi.aws.iam.SecurityTokenServicePreferences,
) : KotlinCustomResource(javaResource, SecurityTokenServicePreferencesMapper) {
    /**
     * The version of the STS global endpoint token. Valid values: `v1Token`, `v2Token`.
     */
    public val globalEndpointTokenVersion: Output<String>
        get() = javaResource.globalEndpointTokenVersion().applyValue({ args0 -> args0 })
}

public object SecurityTokenServicePreferencesMapper :
    ResourceMapper<SecurityTokenServicePreferences> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.SecurityTokenServicePreferences::class == javaResource::class

    override fun map(javaResource: Resource): SecurityTokenServicePreferences =
        SecurityTokenServicePreferences(
            javaResource as
                com.pulumi.aws.iam.SecurityTokenServicePreferences,
        )
}

/**
 * @see [SecurityTokenServicePreferences].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityTokenServicePreferences].
 */
public suspend fun securityTokenServicePreferences(
    name: String,
    block: suspend SecurityTokenServicePreferencesResourceBuilder.() -> Unit,
): SecurityTokenServicePreferences {
    val builder = SecurityTokenServicePreferencesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityTokenServicePreferences].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityTokenServicePreferences(name: String): SecurityTokenServicePreferences {
    val builder = SecurityTokenServicePreferencesResourceBuilder()
    builder.name(name)
    return builder.build()
}
