@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.ServiceLinkedRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an [IAM service-linked role](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const elasticbeanstalk = new aws.iam.ServiceLinkedRole("elasticbeanstalk", {awsServiceName: "elasticbeanstalk.amazonaws.com"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * elasticbeanstalk = aws.iam.ServiceLinkedRole("elasticbeanstalk", aws_service_name="elasticbeanstalk.amazonaws.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var elasticbeanstalk = new Aws.Iam.ServiceLinkedRole("elasticbeanstalk", new()
 *     {
 *         AwsServiceName = "elasticbeanstalk.amazonaws.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewServiceLinkedRole(ctx, "elasticbeanstalk", &iam.ServiceLinkedRoleArgs{
 * 			AwsServiceName: pulumi.String("elasticbeanstalk.amazonaws.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.ServiceLinkedRole;
 * import com.pulumi.aws.iam.ServiceLinkedRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var elasticbeanstalk = new ServiceLinkedRole("elasticbeanstalk", ServiceLinkedRoleArgs.builder()
 *             .awsServiceName("elasticbeanstalk.amazonaws.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   elasticbeanstalk:
 *     type: aws:iam:ServiceLinkedRole
 *     properties:
 *       awsServiceName: elasticbeanstalk.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM service-linked roles using role ARN. For example:
 * ```sh
 * $ pulumi import aws:iam/serviceLinkedRole:ServiceLinkedRole elasticbeanstalk arn:aws:iam::123456789012:role/aws-service-role/elasticbeanstalk.amazonaws.com/AWSServiceRoleForElasticBeanstalk
 * ```
 * @property awsServiceName The AWS service to which this role is attached. You use a string similar to a URL but without the `http://` in front. For example: `elasticbeanstalk.amazonaws.com`. To find the full list of services that support service-linked roles, check [the docs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html).
 * @property customSuffix Additional string appended to the role name. Not all AWS services support custom suffixes.
 * @property description The description of the role.
 * @property tags Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ServiceLinkedRoleArgs(
    public val awsServiceName: Output<String>? = null,
    public val customSuffix: Output<String>? = null,
    public val description: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.ServiceLinkedRoleArgs> {
    override fun toJava(): com.pulumi.aws.iam.ServiceLinkedRoleArgs =
        com.pulumi.aws.iam.ServiceLinkedRoleArgs.builder()
            .awsServiceName(awsServiceName?.applyValue({ args0 -> args0 }))
            .customSuffix(customSuffix?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceLinkedRoleArgs].
 */
@PulumiTagMarker
public class ServiceLinkedRoleArgsBuilder internal constructor() {
    private var awsServiceName: Output<String>? = null

    private var customSuffix: Output<String>? = null

    private var description: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The AWS service to which this role is attached. You use a string similar to a URL but without the `http://` in front. For example: `elasticbeanstalk.amazonaws.com`. To find the full list of services that support service-linked roles, check [the docs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html).
     */
    @JvmName("hkkahgoqohokkgtk")
    public suspend fun awsServiceName(`value`: Output<String>) {
        this.awsServiceName = value
    }

    /**
     * @param value Additional string appended to the role name. Not all AWS services support custom suffixes.
     */
    @JvmName("vxsqmxvtbujvvdqo")
    public suspend fun customSuffix(`value`: Output<String>) {
        this.customSuffix = value
    }

    /**
     * @param value The description of the role.
     */
    @JvmName("vswwnldmjlscmwhv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hkdolyqvxnhxamqa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The AWS service to which this role is attached. You use a string similar to a URL but without the `http://` in front. For example: `elasticbeanstalk.amazonaws.com`. To find the full list of services that support service-linked roles, check [the docs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html).
     */
    @JvmName("shukvrmvyewwixyw")
    public suspend fun awsServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsServiceName = mapped
    }

    /**
     * @param value Additional string appended to the role name. Not all AWS services support custom suffixes.
     */
    @JvmName("vkqwomiwpxgagjtb")
    public suspend fun customSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSuffix = mapped
    }

    /**
     * @param value The description of the role.
     */
    @JvmName("dnupgamabdkvxcgg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mvafsjapgjmudjcr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of tags for the IAM role. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tqskkddfmgadjypt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceLinkedRoleArgs = ServiceLinkedRoleArgs(
        awsServiceName = awsServiceName,
        customSuffix = customSuffix,
        description = description,
        tags = tags,
    )
}
