@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.SigningCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM Signing Certificate resource to upload Signing Certificates.
 * > **Note:** All arguments including the certificate body will be stored in the raw state as plain-text.
 * ## Example Usage
 * **Using certs on file:**
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const testCert = new aws.iam.SigningCertificate("test_cert", {
 *     username: "some_test_cert",
 *     certificateBody: std.file({
 *         input: "self-ca-cert.pem",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * test_cert = aws.iam.SigningCertificate("test_cert",
 *     username="some_test_cert",
 *     certificate_body=std.file(input="self-ca-cert.pem").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testCert = new Aws.Iam.SigningCertificate("test_cert", new()
 *     {
 *         Username = "some_test_cert",
 *         CertificateBody = Std.File.Invoke(new()
 *         {
 *             Input = "self-ca-cert.pem",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "self-ca-cert.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewSigningCertificate(ctx, "test_cert", &iam.SigningCertificateArgs{
 * 			Username:        pulumi.String("some_test_cert"),
 * 			CertificateBody: pulumi.String(invokeFile.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SigningCertificate;
 * import com.pulumi.aws.iam.SigningCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCert = new SigningCertificate("testCert", SigningCertificateArgs.builder()
 *             .username("some_test_cert")
 *             .certificateBody(StdFunctions.file(FileArgs.builder()
 *                 .input("self-ca-cert.pem")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testCert:
 *     type: aws:iam:SigningCertificate
 *     name: test_cert
 *     properties:
 *       username: some_test_cert
 *       certificateBody:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: self-ca-cert.pem
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * **Example with cert in-line:**
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testCertAlt = new aws.iam.SigningCertificate("test_cert_alt", {
 *     username: "some_test_cert",
 *     certificateBody: `-----BEGIN CERTIFICATE-----
 * [&#46;&#46;&#46;&#46;&#46;&#46;] # cert contents
 * -----END CERTIFICATE-----
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_cert_alt = aws.iam.SigningCertificate("test_cert_alt",
 *     username="some_test_cert",
 *     certificate_body="""-----BEGIN CERTIFICATE-----
 * [&#46;&#46;&#46;&#46;&#46;&#46;] # cert contents
 * -----END CERTIFICATE-----
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testCertAlt = new Aws.Iam.SigningCertificate("test_cert_alt", new()
 *     {
 *         Username = "some_test_cert",
 *         CertificateBody = @"-----BEGIN CERTIFICATE-----
 * [&#46;&#46;&#46;&#46;&#46;&#46;] # cert contents
 * -----END CERTIFICATE-----
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewSigningCertificate(ctx, "test_cert_alt", &iam.SigningCertificateArgs{
 * 			Username:        pulumi.String("some_test_cert"),
 * 			CertificateBody: pulumi.String("-----BEGIN CERTIFICATE-----\n[&#46;&#46;&#46;&#46;&#46;&#46;] # cert contents\n-----END CERTIFICATE-----\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.SigningCertificate;
 * import com.pulumi.aws.iam.SigningCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCertAlt = new SigningCertificate("testCertAlt", SigningCertificateArgs.builder()
 *             .username("some_test_cert")
 *             .certificateBody("""
 * -----BEGIN CERTIFICATE-----
 * [&#46;&#46;&#46;&#46;&#46;&#46;] # cert contents
 * -----END CERTIFICATE-----
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testCertAlt:
 *     type: aws:iam:SigningCertificate
 *     name: test_cert_alt
 *     properties:
 *       username: some_test_cert
 *       certificateBody: |
 *         -----BEGIN CERTIFICATE-----
 *         [&#46;&#46;&#46;&#46;&#46;&#46;] # cert contents
 *         -----END CERTIFICATE-----
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM Signing Certificates using the `id`. For example:
 * ```sh
 * $ pulumi import aws:iam/signingCertificate:SigningCertificate certificate IDIDIDIDID:user-name
 * ```
 * @property certificateBody The contents of the signing certificate in PEM-encoded format.
 * @property status The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
 * @property userName The name of the user the signing certificate is for.
 */
public data class SigningCertificateArgs(
    public val certificateBody: Output<String>? = null,
    public val status: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.SigningCertificateArgs> {
    override fun toJava(): com.pulumi.aws.iam.SigningCertificateArgs =
        com.pulumi.aws.iam.SigningCertificateArgs.builder()
            .certificateBody(certificateBody?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SigningCertificateArgs].
 */
@PulumiTagMarker
public class SigningCertificateArgsBuilder internal constructor() {
    private var certificateBody: Output<String>? = null

    private var status: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The contents of the signing certificate in PEM-encoded format.
     */
    @JvmName("vdhjgbwrndabyuow")
    public suspend fun certificateBody(`value`: Output<String>) {
        this.certificateBody = value
    }

    /**
     * @param value The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
     */
    @JvmName("gjburgoprcxcopka")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the user the signing certificate is for.
     */
    @JvmName("bbnuomtldbjyjgnc")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The contents of the signing certificate in PEM-encoded format.
     */
    @JvmName("lnexbhikwttghqfa")
    public suspend fun certificateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateBody = mapped
    }

    /**
     * @param value The status you want to assign to the certificate. `Active` means that the certificate can be used for programmatic calls to Amazon Web Services `Inactive` means that the certificate cannot be used.
     */
    @JvmName("tastmfbgggrwafsp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the user the signing certificate is for.
     */
    @JvmName("qohuaykxgmjkxkke")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SigningCertificateArgs = SigningCertificateArgs(
        certificateBody = certificateBody,
        status = status,
        userName = userName,
    )
}
