@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.UserLoginProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an IAM User Login Profile with limited support for password creation during this provider resource creation. Uses PGP to encrypt the password for safe transport to the user. PGP keys can be obtained from Keybase.
 * > To reset an IAM User login password via this provider, you can use delete and recreate this resource or change any of the arguments.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iam.User("example", {
 *     name: "example",
 *     path: "/",
 *     forceDestroy: true,
 * });
 * const exampleUserLoginProfile = new aws.iam.UserLoginProfile("example", {
 *     user: example.name,
 *     pgpKey: "keybase:some_person_that_exists",
 * });
 * export const password = exampleUserLoginProfile.encryptedPassword;
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.User("example",
 *     name="example",
 *     path="/",
 *     force_destroy=True)
 * example_user_login_profile = aws.iam.UserLoginProfile("example",
 *     user=example.name,
 *     pgp_key="keybase:some_person_that_exists")
 * pulumi.export("password", example_user_login_profile.encrypted_password)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iam.User("example", new()
 *     {
 *         Name = "example",
 *         Path = "/",
 *         ForceDestroy = true,
 *     });
 *     var exampleUserLoginProfile = new Aws.Iam.UserLoginProfile("example", new()
 *     {
 *         User = example.Name,
 *         PgpKey = "keybase:some_person_that_exists",
 *     });
 *     return new Dictionary<string, object?>
 *     {
 *         ["password"] = exampleUserLoginProfile.EncryptedPassword,
 *     };
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := iam.NewUser(ctx, "example", &iam.UserArgs{
 * 			Name:         pulumi.String("example"),
 * 			Path:         pulumi.String("/"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleUserLoginProfile, err := iam.NewUserLoginProfile(ctx, "example", &iam.UserLoginProfileArgs{
 * 			User:   example.Name,
 * 			PgpKey: pulumi.String("keybase:some_person_that_exists"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ctx.Export("password", exampleUserLoginProfile.EncryptedPassword)
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.UserLoginProfile;
 * import com.pulumi.aws.iam.UserLoginProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .name("example")
 *             .path("/")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleUserLoginProfile = new UserLoginProfile("exampleUserLoginProfile", UserLoginProfileArgs.builder()
 *             .user(example.name())
 *             .pgpKey("keybase:some_person_that_exists")
 *             .build());
 *         ctx.export("password", exampleUserLoginProfile.encryptedPassword());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:User
 *     properties:
 *       name: example
 *       path: /
 *       forceDestroy: true
 *   exampleUserLoginProfile:
 *     type: aws:iam:UserLoginProfile
 *     name: example
 *     properties:
 *       user: ${example.name}
 *       pgpKey: keybase:some_person_that_exists
 * outputs:
 *   password: ${exampleUserLoginProfile.encryptedPassword}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM User Login Profiles without password information via the IAM User name. For example:
 * ```sh
 * $ pulumi import aws:iam/userLoginProfile:UserLoginProfile example myusername
 * ```
 * Since Pulumi has no method to read the PGP or password information during import, use the resource options `ignore_changes` argument to ignore them (unless you want to recreate a password). For example:
 * @property passwordLength The length of the generated password on resource creation. Only applies on resource creation. Drift detection is not possible with this argument. Default value is `20`.
 * @property passwordResetRequired Whether the user should be forced to reset the generated password on resource creation. Only applies on resource creation.
 * @property pgpKey Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Only applies on resource creation. Drift detection is not possible with this argument.
 * @property user The IAM user's name.
 */
public data class UserLoginProfileArgs(
    public val passwordLength: Output<Int>? = null,
    public val passwordResetRequired: Output<Boolean>? = null,
    public val pgpKey: Output<String>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.UserLoginProfileArgs> {
    override fun toJava(): com.pulumi.aws.iam.UserLoginProfileArgs =
        com.pulumi.aws.iam.UserLoginProfileArgs.builder()
            .passwordLength(passwordLength?.applyValue({ args0 -> args0 }))
            .passwordResetRequired(passwordResetRequired?.applyValue({ args0 -> args0 }))
            .pgpKey(pgpKey?.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserLoginProfileArgs].
 */
@PulumiTagMarker
public class UserLoginProfileArgsBuilder internal constructor() {
    private var passwordLength: Output<Int>? = null

    private var passwordResetRequired: Output<Boolean>? = null

    private var pgpKey: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value The length of the generated password on resource creation. Only applies on resource creation. Drift detection is not possible with this argument. Default value is `20`.
     */
    @JvmName("tordaeqhenmxvnll")
    public suspend fun passwordLength(`value`: Output<Int>) {
        this.passwordLength = value
    }

    /**
     * @param value Whether the user should be forced to reset the generated password on resource creation. Only applies on resource creation.
     */
    @JvmName("uugynslwbrxivrbo")
    public suspend fun passwordResetRequired(`value`: Output<Boolean>) {
        this.passwordResetRequired = value
    }

    /**
     * @param value Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Only applies on resource creation. Drift detection is not possible with this argument.
     */
    @JvmName("grxevqwxvyakegwj")
    public suspend fun pgpKey(`value`: Output<String>) {
        this.pgpKey = value
    }

    /**
     * @param value The IAM user's name.
     */
    @JvmName("ittwiryidauwybqn")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value The length of the generated password on resource creation. Only applies on resource creation. Drift detection is not possible with this argument. Default value is `20`.
     */
    @JvmName("asrlwjbmdtmelepd")
    public suspend fun passwordLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordLength = mapped
    }

    /**
     * @param value Whether the user should be forced to reset the generated password on resource creation. Only applies on resource creation.
     */
    @JvmName("rdqtxajpeijwrdnn")
    public suspend fun passwordResetRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordResetRequired = mapped
    }

    /**
     * @param value Either a base-64 encoded PGP public key, or a keybase username in the form `keybase:username`. Only applies on resource creation. Drift detection is not possible with this argument.
     */
    @JvmName("ywhkbyvreqetotpf")
    public suspend fun pgpKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pgpKey = mapped
    }

    /**
     * @param value The IAM user's name.
     */
    @JvmName("sayrptxmlirltkag")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): UserLoginProfileArgs = UserLoginProfileArgs(
        passwordLength = passwordLength,
        passwordResetRequired = passwordResetRequired,
        pgpKey = pgpKey,
        user = user,
    )
}
