@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserPolicy].
 */
@PulumiTagMarker
public class UserPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPolicyArgs = UserPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPolicyArgsBuilder.() -> Unit) {
        val builder = UserPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserPolicy {
        val builtJavaResource = com.pulumi.aws.iam.UserPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPolicy(builtJavaResource)
    }
}

/**
 * Provides an IAM policy attached to a user.
 * > **NOTE:** We suggest using explicit JSON encoding or `aws.iam.getPolicyDocument` when assigning a value to `policy`. They seamlessly translate configuration to JSON, enabling you to maintain consistency within your configuration without the need for context switches. Also, you can sidestep potential complications arising from formatting discrepancies, whitespace inconsistencies, and other nuances inherent to JSON.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const lb = new aws.iam.User("lb", {
 *     name: "loadbalancer",
 *     path: "/system/",
 * });
 * const lbRo = new aws.iam.UserPolicy("lb_ro", {
 *     name: "test",
 *     user: lb.name,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: ["ec2:Describe*"],
 *             Effect: "Allow",
 *             Resource: "*",
 *         }],
 *     }),
 * });
 * const lbAccessKey = new aws.iam.AccessKey("lb", {user: lb.name});
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * lb = aws.iam.User("lb",
 *     name="loadbalancer",
 *     path="/system/")
 * lb_ro = aws.iam.UserPolicy("lb_ro",
 *     name="test",
 *     user=lb.name,
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": ["ec2:Describe*"],
 *             "Effect": "Allow",
 *             "Resource": "*",
 *         }],
 *     }))
 * lb_access_key = aws.iam.AccessKey("lb", user=lb.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lb = new Aws.Iam.User("lb", new()
 *     {
 *         Name = "loadbalancer",
 *         Path = "/system/",
 *     });
 *     var lbRo = new Aws.Iam.UserPolicy("lb_ro", new()
 *     {
 *         Name = "test",
 *         User = lb.Name,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "ec2:Describe*",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Resource"] = "*",
 *                 },
 *             },
 *         }),
 *     });
 *     var lbAccessKey = new Aws.Iam.AccessKey("lb", new()
 *     {
 *         User = lb.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		lb, err := iam.NewUser(ctx, "lb", &iam.UserArgs{
 * 			Name: pulumi.String("loadbalancer"),
 * 			Path: pulumi.String("/system/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"ec2:Describe*",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = iam.NewUserPolicy(ctx, "lb_ro", &iam.UserPolicyArgs{
 * 			Name:   pulumi.String("test"),
 * 			User:   lb.Name,
 * 			Policy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewAccessKey(ctx, "lb", &iam.AccessKeyArgs{
 * 			User: lb.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.UserPolicy;
 * import com.pulumi.aws.iam.UserPolicyArgs;
 * import com.pulumi.aws.iam.AccessKey;
 * import com.pulumi.aws.iam.AccessKeyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new User("lb", UserArgs.builder()
 *             .name("loadbalancer")
 *             .path("/system/")
 *             .build());
 *         var lbRo = new UserPolicy("lbRo", UserPolicyArgs.builder()
 *             .name("test")
 *             .user(lb.name())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var lbAccessKey = new AccessKey("lbAccessKey", AccessKeyArgs.builder()
 *             .user(lb.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lbRo:
 *     type: aws:iam:UserPolicy
 *     name: lb_ro
 *     properties:
 *       name: test
 *       user: ${lb.name}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - ec2:Describe*
 *               Effect: Allow
 *               Resource: '*'
 *   lb:
 *     type: aws:iam:User
 *     properties:
 *       name: loadbalancer
 *       path: /system/
 *   lbAccessKey:
 *     type: aws:iam:AccessKey
 *     name: lb
 *     properties:
 *       user: ${lb.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM User Policies using the `user_name:user_policy_name`. For example:
 * ```sh
 * $ pulumi import aws:iam/userPolicy:UserPolicy mypolicy user_of_mypolicy_name:mypolicy_name
 * ```
 */
public class UserPolicy internal constructor(
    override val javaResource: com.pulumi.aws.iam.UserPolicy,
) : KotlinCustomResource(javaResource, UserPolicyMapper) {
    /**
     * The name of the policy. If omitted, the provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The policy document. This is a JSON formatted string.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * IAM user to which to attach this policy.
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })
}

public object UserPolicyMapper : ResourceMapper<UserPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.UserPolicy::class == javaResource::class

    override fun map(javaResource: Resource): UserPolicy = UserPolicy(
        javaResource as
            com.pulumi.aws.iam.UserPolicy,
    )
}

/**
 * @see [UserPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPolicy].
 */
public suspend fun userPolicy(name: String, block: suspend UserPolicyResourceBuilder.() -> Unit): UserPolicy {
    val builder = UserPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPolicy(name: String): UserPolicy {
    val builder = UserPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
